/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.identifier;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class StepIdentifier {
    private String serviceType;
    private String action;
    private String text;

    public StepIdentifier(String text) {
        if (VerifyUtil.isEmpty((String)text)) {
            throw new LegoCheckedException(1073952404L, "Identifier text can not is empty.");
        }
        this.text = text;
    }

    public StepIdentifier(String serviceType, String action) {
        if (VerifyUtil.isEmpty((String)action) || VerifyUtil.isEmpty((String)serviceType)) {
            throw new LegoCheckedException(1073952404L, "Identifier action and serviceType can not is empty.");
        }
        this.serviceType = serviceType;
        this.action = action;
    }

    public String render() {
        String identifier = "";
        if (this.serviceType != null) {
            identifier = identifier + this.serviceType.trim();
        }
        if (this.action != null) {
            return identifier + "_" + this.action.trim();
        }
        return identifier + this.text.trim();
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

