/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.manager;

import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AbstractAppManager;
import com.huawei.csr.framework.core.manager.AppManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.Map;

public final class AppPluginManager {
    private static final Log logger = LogFactory.getInstance(AppPluginManager.class);
    private static final String SERVICE_TYPE_KEY = "serviceType";
    private static AppPluginManager instance;
    private final Map<String, AbstractAppManager> appManagers = new HashMap<String, AbstractAppManager>();

    private AppPluginManager() {
    }

    public static synchronized AppPluginManager getInstance() {
        if (instance == null) {
            instance = new AppPluginManager();
        }
        return instance;
    }

    public void register(AbstractAppManager appManager, Map<String, Object> properties) {
        if (appManager.getAppIdentifier() == null) {
            throw new LegoCheckedException(1073952404L, "The app register to csr failed, identifier is not found, class: " + appManager.getClass().getName());
        }
        String identifier = appManager.getAppIdentifier().render();
        this.appManagers.put(identifier, appManager);
        logger.info((Object)"The app register to csr success, identifier: %s", new Object[]{identifier});
    }

    public void unregister(AbstractAppManager appManager, Map<String, Object> properties) {
        if (appManager.getAppIdentifier() == null) {
            throw new LegoCheckedException(1073952404L, "The app unregister from csr failed, identifier is not found, class: " + appManager.getClass().getName());
        }
        String identifier = appManager.getAppIdentifier().render();
        this.appManagers.remove(identifier);
        logger.info((Object)"The app unregister from csr success, identifier: %s", new Object[]{identifier});
    }

    public AppManager getAppManager(AppIdentifier identifier) {
        if (!this.appManagers.containsKey(identifier.render())) {
            throw new LegoCheckedException(1073952404L, "The app manager class is not found, identifier: " + identifier.render());
        }
        return this.appManagers.get(identifier.render());
    }
}

