/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.task.app;

import com.huawei.csr.framework.common.operationtask.OperationTaskManager;
import com.huawei.csr.framework.common.operationtask.app.RefreshAppTask;
import com.huawei.csr.framework.common.utils.AppServiceUtil;
import com.huawei.csr.framework.core.thread.ThreadPoolFactory;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.om.auth.util.AuthUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;

public class AutoRefreshTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance(AutoRefreshTask.class);
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR = ThreadPoolFactory.getThreadPool("refresh-task");
    private static final int COUNT = 20;

    @Override
    public void run() {
        this.doWork();
    }

    private void doWork() {
        List<Application> allApplications = this.getService(ApplicationDao.class).getAllApplications();
        int startIdx = 0;
        int endIdx = 0;
        while (endIdx < allApplications.size()) {
            endIdx = Integer.min(startIdx + 20, allApplications.size());
            CountDownLatch countDownLatch = new CountDownLatch(endIdx - startIdx);
            for (int i = startIdx; i < endIdx; ++i) {
                Application app = allApplications.get(i);
                String authToken = null;
                try {
                    authToken = AuthUtil.getScopedAuthToken((String)app.getProjectId());
                }
                catch (ClientException | ResponseException | IOException e) {
                    LOGGER.error((Object)"Fetch authToken failed. msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                    continue;
                }
                Credential credential = new Credential(app.getProjectId(), authToken, null);
                this.executeRefresh(countDownLatch, allApplications.get(i), credential);
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            }
            startIdx = endIdx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRefresh(CountDownLatch countDownLatch, Application application, Credential credential) {
        try {
            BackTask backTaskModel = AppServiceUtil.buildBackupTaskModel(application.getProjectId(), application.getName(), "operation.task.refresh.app");
            RefreshAppTask refreshAppTask = new RefreshAppTask(backTaskModel, application, credential);
            OperationTaskManager.submitTask(refreshAppTask);
        }
        catch (Exception e) {
            LOGGER.error((Object)"app(%s):(%s) refresh failed. msg: %s", new Object[]{application.getId(), application.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            countDownLatch.countDown();
        }
    }

    private <T> T getService(Class<? extends T> serviceClass) {
        return (T)ServiceLocator.getInstance().getService(serviceClass);
    }
}

