/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.task.recover;

import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.model.RecoverLogQuery;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.common.utils.DateUtil;
import com.huawei.csr.framework.common.utils.RecoverPlanUtil;
import com.huawei.csr.framework.core.callback.FailCallback;
import com.huawei.csr.framework.core.callback.SuccessCallback;
import com.huawei.csr.framework.core.callback.SuspendCallBack;
import com.huawei.csr.framework.core.event.DefaultEventDispatcher;
import com.huawei.csr.framework.core.event.entity.RecoverTaskEventEntity;
import com.huawei.csr.framework.core.event.objects.RecoverTaskEvent;
import com.huawei.csr.framework.core.task.recover.RecoverContext;
import com.huawei.csr.framework.core.task.recover.RecoverTaskResult;
import com.huawei.csr.framework.dao.impl.RecoverLogDaoImpl;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

public abstract class AbstractRecoverTask
implements Callable<RecoverTaskResult> {
    protected static final int PROCESS_100 = 100;
    private static final Log logger = LogFactory.getInstance(AbstractRecoverTask.class);
    private int processUnit = 0;
    private RecoverContext recoverContext;

    public AbstractRecoverTask(RecoverContext recoverContext) {
        this.recoverContext = recoverContext;
    }

    @Override
    public RecoverTaskResult call() {
        try {
            if (this.recoverContext.getRecoverLog().getProcess() == 100) {
                logger.info((Object)"Recover log(%s) of resource(%s) has finished, so not need execute.", new Object[]{this.recoverContext.getRecoverLog().getId(), this.recoverContext.getResourceId()});
                RecoverTaskResult recoverTaskResult = new RecoverTaskResult(true);
                return recoverTaskResult;
            }
            logger.info((Object)"Start execute recover task, recover log: %s, resource id: %s", new Object[]{this.recoverContext.getRecoverLog().getId(), this.recoverContext.getResourceId()});
            this.updateRecoverLog(RecoverLogStatus.RUNNING.getValue(), null, null);
            this.updateResource(RecoverPlanUtil.getRunningStatus(this.getRecoverContext().getRecoverOperateType()));
            this.doWork();
            RecoverTaskResult recoverTaskResult = this.onSuccess();
            return recoverTaskResult;
        }
        catch (LegoCheckedException legoErr) {
            if (legoErr.getErrorCode() == -1000L) {
                RecoverTaskResult recoverTaskResult = this.onSuspend();
                return recoverTaskResult;
            }
            RecoverTaskResult recoverTaskResult = this.onFailed(legoErr.getErrorCode(), legoErr.getMessage());
            return recoverTaskResult;
        }
        catch (Exception err) {
            RecoverTaskResult recoverTaskResult = this.onFailed(1073952404L, ExceptionUtil.getErrorMessage((Throwable)err));
            return recoverTaskResult;
        }
        finally {
            Optional.ofNullable(this.recoverContext.getLatch()).ifPresent(CountDownLatch::countDown);
            if (!RecoverLogStatus.SUSPENDED.getValue().equals(this.recoverContext.getRecoverLog().getStatus())) {
                DefaultEventDispatcher.getInstance().asyncDispatchEvent(new RecoverTaskEvent(new RecoverTaskEventEntity(this.recoverContext), RecoverTaskEvent.EventType.RECOVER_TASK));
            }
        }
    }

    public abstract void doWork();

    protected boolean isBatchSuccess(List<Future<RecoverTaskResult>> futures) {
        for (Future<RecoverTaskResult> future : futures) {
            if (future.get().isSuccess()) continue;
            return false;
        }
        return true;
    }

    public Optional<RecoverLog> getCurrentLogByParentId(String resourceId) {
        RecoverLogQuery logQuery = new RecoverLogQuery();
        logQuery.setProjectId(this.recoverContext.getRequestContext().getProjectId());
        logQuery.setResourceIds(Collections.singletonList(resourceId));
        logQuery.setParentIds(Collections.singletonList(this.recoverContext.getRecoverLog().getId()));
        logQuery.setLimit(1);
        List<RecoverLog> logs = ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).queryRecoverLogs(logQuery);
        return VerifyUtil.isEmpty(logs) ? Optional.empty() : Optional.of(logs.get(0));
    }

    private RecoverLog getTopOrRecoverPlanLog(RecoverLog recoverLog) {
        if (VerifyUtil.isEmpty((Object)recoverLog) || VerifyUtil.isEmpty((String)recoverLog.getParentId()) || RecoverResourceType.RECOVER_PLAN.getValue().equals(recoverLog.getResourceType())) {
            return recoverLog;
        }
        return this.getTopOrRecoverPlanLog(((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).getRecoverLogById(recoverLog.getParentId()));
    }

    public void checkTaskSuspendOrStop() {
        RecoverLog log = this.getTopOrRecoverPlanLog(((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).getRecoverLogById(this.recoverContext.getRecoverLog().getId()));
        if (!VerifyUtil.isEmpty((Object)log.getErrorCode()) && log.getErrorCode() == -1000L) {
            if (!VerifyUtil.isEmpty((String)log.getParentId())) {
                this.recoverContext.getParentLog().setStatus(RecoverLogStatus.SUSPENDED.getValue());
            }
            logger.info((Object)"The %s (%s) execute be suspended.", new Object[]{this.recoverContext.getResourceType(), this.recoverContext.getResourceId()});
            throw new LegoCheckedException(-1000L);
        }
        if (!VerifyUtil.isEmpty((Object)log.getErrorCode()) && log.getErrorCode() == 1073952114L) {
            logger.warn((Object)"The %s (%s) execute be stop.", new Object[]{this.recoverContext.getResourceType(), this.recoverContext.getResourceId()});
            throw new LegoCheckedException(1073952114L);
        }
    }

    public void checkRecoverResources(String resourceType) {
        RecoverLogQuery resourceLogQuery = new RecoverLogQuery();
        resourceLogQuery.setParentIds(Collections.singletonList(this.recoverContext.getRecoverLog().getId()));
        resourceLogQuery.setResourceType(resourceType);
        resourceLogQuery.setProjectId(this.recoverContext.getRecoverLog().getProjectId());
        List<RecoverLog> recoverLogs = ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).queryRecoverLogs(resourceLogQuery);
        if (this.failedResourceExist(recoverLogs)) {
            logger.error((Object)"The %s (%s) execute failed after suspend.", new Object[]{this.recoverContext.getResourceType(), this.recoverContext.getResourceId()});
            throw new LegoCheckedException(1073952219L);
        }
        if (this.pausedResourceExist(recoverLogs)) {
            logger.info((Object)"The %s (%s) execute be suspended.", new Object[]{this.recoverContext.getResourceType(), this.recoverContext.getResourceId()});
            throw new LegoCheckedException(-1000L);
        }
    }

    private boolean failedResourceExist(List<RecoverLog> recoverLogs) {
        return recoverLogs.stream().anyMatch(recoverLog -> RecoverLogStatus.FAILED.getValue().equals(recoverLog.getStatus()) && this.resourceExsit(recoverLog.getResourceId()));
    }

    private boolean pausedResourceExist(List<RecoverLog> recoverLogs) {
        return recoverLogs.stream().anyMatch(recoverLog -> RecoverLogStatus.SUSPENDED.getValue().equals(recoverLog.getStatus()) && this.resourceExsit(recoverLog.getResourceId()));
    }

    protected boolean resourceExsit(String resourceId) {
        return true;
    }

    protected void updateResource(RecoverStatus status) {
    }

    private RecoverTaskResult onSuccess() {
        if (RecoverLogStatus.SUSPENDED.getValue().equals(this.recoverContext.getRecoverLog().getStatus())) {
            return this.onSuspend();
        }
        this.updateRecoverLog(RecoverLogStatus.SUCCESS.getValue(), null, null);
        this.updateResource(RecoverPlanUtil.getCompletedStatus(this.recoverContext.getRecoverOperateType()));
        logger.info((Object)"Recover log(%s) is success, resource id: %s", new Object[]{this.recoverContext.getRecoverLog().getId(), this.recoverContext.getResourceId()});
        Optional.ofNullable(this.recoverContext.getSuccessCallback()).ifPresent(SuccessCallback::onSuccess);
        return new RecoverTaskResult(true);
    }

    private RecoverTaskResult onSuspend() {
        this.updateRecoverLog(RecoverLogStatus.SUSPENDED.getValue(), null, null);
        this.updateResource(RecoverPlanUtil.getSuspendedStatus(this.recoverContext.getRecoverOperateType()));
        logger.info((Object)"Recover log(%s) is paused, resource id: %s", new Object[]{this.recoverContext.getRecoverLog().getId(), this.recoverContext.getResourceId()});
        Optional.ofNullable(this.recoverContext.getSuspendCallBack()).ifPresent(SuspendCallBack::onSuspend);
        return new RecoverTaskResult(true);
    }

    private RecoverTaskResult onFailed(long errorCode, String errorMsg) {
        this.updateRecoverLog(RecoverLogStatus.FAILED.getValue(), errorCode, errorMsg);
        this.updateResource(RecoverPlanUtil.getFailedStatus(this.getRecoverContext().getRecoverOperateType()));
        logger.error((Object)"Execute recover log(%s) of resource(%s) failed, msg: %s", new Object[]{this.recoverContext.getRecoverLog().getId(), this.recoverContext.getResourceId(), errorMsg});
        Optional.ofNullable(this.recoverContext.getFailCallback()).ifPresent(FailCallback::onFail);
        return new RecoverTaskResult(false);
    }

    private void updateRecoverLog(String status, Long errorCode, String errorMsg) {
        if (RecoverLogStatus.WAITING.getValue().equals(this.recoverContext.getRecoverLog().getStatus())) {
            this.getRecoverContext().getRecoverLog().setStartTime(new Timestamp(DateUtil.getUtcTimeStamp()));
        }
        if (RecoverLogStatus.RUNNING.getValue().equals(status)) {
            this.recoverContext.getRecoverLog().setErrorCode(null);
            this.recoverContext.getRecoverLog().setOperationType(this.recoverContext.getRecoverOperateType().getValue());
        }
        if (RecoverLogStatus.SUCCESS.getValue().equals(status)) {
            this.recoverContext.getRecoverLog().setProcess(100);
            this.recoverContext.getRecoverLog().setEndTime(new Timestamp(DateUtil.getUtcTimeStamp()));
            this.recoverContext.getRecoverLog().setErrorCode(null);
        }
        if (RecoverLogStatus.FAILED.getValue().equals(status)) {
            this.recoverContext.getRecoverLog().setErrorCode(errorCode);
            this.recoverContext.getRecoverLog().setErrorMsg(errorMsg);
            this.recoverContext.getRecoverLog().setEndTime(new Timestamp(DateUtil.getUtcTimeStamp()));
        }
        this.recoverContext.getRecoverLog().setStatus(status);
        ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).update(this.recoverContext.getRecoverLog());
    }

    protected long getAverageRto() {
        RecoverLogQuery logQuery = new RecoverLogQuery();
        logQuery.setProjectId(this.recoverContext.getRequestContext().getProjectId());
        logQuery.setResourceIds(Collections.singletonList(this.recoverContext.getResourceId()));
        logQuery.setStatus(Collections.singletonList(RecoverLogStatus.SUCCESS.getValue()));
        logQuery.setStartTimeAsc(false);
        logQuery.setLimit(50);
        List<RecoverLog> recoverLogs = ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).queryRecoverLogs(logQuery);
        if (VerifyUtil.isEmpty(recoverLogs)) {
            return 0L;
        }
        long totalTime = recoverLogs.stream().mapToLong(recoverLog -> recoverLog.getEndTime().getTime() - recoverLog.getStartTime().getTime()).sum();
        return totalTime / (long)recoverLogs.size();
    }

    public synchronized void successCallback() {
        this.recoverContext.getRecoverLog().setProcess(Math.min(this.recoverContext.getRecoverLog().getProcess() + this.getProcessUnit(), 100));
        ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).update(this.recoverContext.getRecoverLog());
    }

    public synchronized void suspendCallback() {
        this.recoverContext.getRecoverLog().setErrorCode(-1000L);
        Optional<RecoverLog> parentLog = Optional.ofNullable(this.recoverContext.getParentLog());
        parentLog.ifPresent(recoverLog -> recoverLog.setStatus(RecoverLogStatus.SUSPENDED.getValue()));
    }

    public RecoverContext getRecoverContext() {
        return this.recoverContext;
    }

    public void setRecoverContext(RecoverContext recoverContext) {
        this.recoverContext = recoverContext;
    }

    public int getProcessUnit() {
        return this.processUnit;
    }

    public void setProcessUnit(int processUnit) {
        this.processUnit = processUnit;
    }
}

