/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.task.recover;

import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.core.task.recover.AbstractRecoverTask;
import com.huawei.csr.framework.core.task.recover.RecoverContext;
import com.huawei.csr.framework.core.task.recover.RecoverStepTask;
import com.huawei.csr.framework.core.task.recover.RecoverTaskExecuteThreadPool;
import com.huawei.csr.framework.core.task.recover.RecoverTaskResult;
import com.huawei.csr.framework.dao.impl.ApplicationDaoImpl;
import com.huawei.csr.framework.dao.impl.FlowStepMapDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverFlowDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverStepChainDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverStepDaoImpl;
import com.huawei.csr.framework.dao.model.FlowStepMap;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.StepChain;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

public class RecoverFlowTask
extends AbstractRecoverTask {
    private static final Log LOG = LogFactory.getInstance(RecoverFlowTask.class);
    private RecoverFlow flow;

    public RecoverFlowTask(RecoverContext recoverContext, RecoverFlow flow) {
        super(recoverContext);
        this.flow = flow;
    }

    @Override
    public void doWork() {
        Queue<RecoverStep> rootSteps = this.getRootSteps();
        while (!rootSteps.isEmpty()) {
            this.batchExecuteTask(rootSteps);
            if (VerifyUtil.isEmpty(rootSteps)) {
                LOG.info((Object)"Recover steps of recover flow %s has finished.", new Object[]{this.flow.getId()});
                break;
            }
            this.checkTaskSuspendOrStop();
        }
        this.checkRecoverResources(RecoverResourceType.RECOVER_STEP.getValue());
        LOG.info((Object)"Recover flow(%s) execute success", new Object[]{this.flow.getId()});
    }

    private void batchExecuteTask(Queue<RecoverStep> rootSteps) {
        int size = rootSteps.size();
        CountDownLatch stepLatch = new CountDownLatch(size);
        HashSet visited = new HashSet();
        ArrayList<Future<RecoverTaskResult>> futures = new ArrayList<Future<RecoverTaskResult>>();
        for (int index = 0; index < size; ++index) {
            RecoverStep step = rootSteps.remove();
            if (step == null) {
                stepLatch.countDown();
                continue;
            }
            this.executeStep(step, stepLatch, futures);
            List<StepChain> nextStepChainList = ((RecoverStepChainDaoImpl)ServiceLocator.getInstance().getService(RecoverStepChainDaoImpl.class)).queryNextStepList(this.flow.getId(), step.getId());
            nextStepChainList.forEach(nextStepChain -> {
                if (!visited.contains(nextStepChain.getNextStepId())) {
                    RecoverStepQuery stepQuery = new RecoverStepQuery();
                    stepQuery.setProjectId(this.getRecoverContext().getRequestContext().getProjectId());
                    stepQuery.setStepId(nextStepChain.getNextStepId());
                    rootSteps.add(((RecoverStepDaoImpl)ServiceLocator.getInstance().getService(RecoverStepDaoImpl.class)).queryRecoverStep(stepQuery));
                    visited.add(nextStepChain.getNextStepId());
                }
            });
        }
        stepLatch.await();
        if (!this.isBatchSuccess(futures)) {
            LOG.error((Object)"Recover flow(%s) execute failed", new Object[]{this.flow.getId()});
            throw new LegoCheckedException(1073952606L, new String[]{this.flow.getName()});
        }
    }

    @Override
    protected boolean resourceExsit(String resourceId) {
        return !VerifyUtil.isEmpty((Object)((RecoverStepDaoImpl)ServiceLocator.getInstance().getService(RecoverStepDaoImpl.class)).queryRecoverStepById(resourceId));
    }

    @Override
    protected void updateResource(RecoverStatus status) {
        if (this.getRecoverContext().getRecoverLog().getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            this.flow.setLastExecuteTime(this.getRecoverContext().getRecoverLog().getStartTime());
            this.flow.setLastExecuteDuration(this.getRecoverContext().getRecoverLog().getEndTime().getTime() - this.getRecoverContext().getRecoverLog().getStartTime().getTime());
            this.flow.setAverageExecuteDuration(this.getAverageRto());
        }
        this.flow.setStatus(status.getValue());
        ((RecoverFlowDaoImpl)ServiceLocator.getInstance().getService(RecoverFlowDaoImpl.class)).update(this.flow);
        ((ApplicationDaoImpl)ServiceLocator.getInstance().getService(ApplicationDaoImpl.class)).updateAppStatus(this.flow.getAppId(), status.getValue());
    }

    private void executeStep(RecoverStep step, CountDownLatch stepLatch, List<Future<RecoverTaskResult>> futures) {
        Future<RecoverTaskResult> future;
        Optional<RecoverLog> optionalRecoverLog = this.getCurrentLogByParentId(step.getId());
        if (optionalRecoverLog.isPresent() && optionalRecoverLog.get().getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            LOG.info((Object)"The recover step(%s) task has completed, so not need execute.", new Object[]{step.getId()});
            stepLatch.countDown();
            return;
        }
        RecoverStepTask stepTask = new RecoverStepTask(new RecoverContext(this.getRecoverContext().getRequestContext()).setParentLog(this.getRecoverContext().getRecoverLog()).setLatch(stepLatch).setResourceId(step.getId()).setResourceName(step.getName()).setResourceType(RecoverResourceType.RECOVER_STEP.getValue()).setRecoverOperateType(this.getRecoverContext().getRecoverOperateType()).setSiteId(this.getRecoverContext().getSiteId()).setSuspendCallBack(this::suspendCallback).setSuccessCallback(this::successCallback), step);
        if (optionalRecoverLog.isPresent()) {
            LOG.info((Object)"The step(%s) task log(%s) has existed, so continue execute.", new Object[]{step.getId(), optionalRecoverLog.get().getId()});
            stepTask.getRecoverContext().setRecoverLog(optionalRecoverLog.get());
            future = RecoverTaskExecuteThreadPool.submit(stepTask);
        } else {
            LOG.info((Object)"Start execute a new step(%s) task", new Object[]{step.getId()});
            future = RecoverTaskExecuteThreadPool.submitWithRecoverLog(stepTask);
        }
        futures.add(future);
    }

    private Queue<RecoverStep> getRootSteps() {
        List<FlowStepMap> flowStepMaps = ((FlowStepMapDaoImpl)ServiceLocator.getInstance().getService(FlowStepMapDaoImpl.class)).queryFlowStepMapByFlowId(this.flow.getId());
        LinkedList<RecoverStep> rootSteps = new LinkedList<RecoverStep>();
        if (VerifyUtil.isEmpty(flowStepMaps)) {
            return rootSteps;
        }
        this.setProcessUnit(100 / flowStepMaps.size());
        HashSet<String> visited = new HashSet<String>();
        for (FlowStepMap flowStepMap : flowStepMaps) {
            if (visited.contains(flowStepMap.getRecoverStepId())) continue;
            this.addRootStep(flowStepMap, visited, rootSteps);
        }
        return rootSteps;
    }

    private void addRootStep(FlowStepMap flowStepMap, Set<String> visited, Queue<RecoverStep> rootSteps) {
        LinkedList<String> stepIds = new LinkedList<String>();
        stepIds.add(flowStepMap.getRecoverStepId());
        visited.add(flowStepMap.getRecoverStepId());
        while (!VerifyUtil.isEmpty(stepIds)) {
            String stepId = (String)stepIds.remove();
            RecoverStepQuery stepQuery = new RecoverStepQuery();
            stepQuery.setProjectId(this.getRecoverContext().getRequestContext().getProjectId());
            stepQuery.setStepId(stepId);
            RecoverStep recoverStep = ((RecoverStepDaoImpl)ServiceLocator.getInstance().getService(RecoverStepDaoImpl.class)).queryRecoverStep(stepQuery);
            List<StepChain> preStepChainList = ((RecoverStepChainDaoImpl)ServiceLocator.getInstance().getService(RecoverStepChainDaoImpl.class)).queryPreStepList(this.flow.getId(), stepId);
            if (VerifyUtil.isEmpty(preStepChainList)) {
                rootSteps.add(recoverStep);
                continue;
            }
            preStepChainList.forEach(preStepChain -> {
                if (!visited.contains(preStepChain.getPrevStepId())) {
                    stepIds.add(preStepChain.getPrevStepId());
                    visited.add(preStepChain.getPrevStepId());
                }
            });
        }
    }

    public RecoverFlow getFlow() {
        return this.flow;
    }

    public void setFlow(RecoverFlow flow) {
        this.flow = flow;
    }
}

