/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.task.recover;

import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.core.task.recover.AbstractRecoverTask;
import com.huawei.csr.framework.core.task.recover.RecoverContext;
import com.huawei.csr.framework.core.task.recover.RecoverPreplanTask;
import com.huawei.csr.framework.core.task.recover.RecoverTaskExecuteThreadPool;
import com.huawei.csr.framework.core.task.recover.RecoverTaskResult;
import com.huawei.csr.framework.dao.impl.RecoverPlanDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPreplanDaoImpl;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

public class RecoverPlanTask
extends AbstractRecoverTask {
    private static final Log logger = LogFactory.getInstance(RecoverPlanTask.class);
    private RecoverPlan plan;
    private RecoverPreplan preplan;

    public RecoverPlanTask(RecoverContext recoverContext, RecoverPlan plan, RecoverPreplan preplan) {
        super(recoverContext);
        this.plan = plan;
        this.preplan = preplan;
    }

    @Override
    public void doWork() {
        List<RecoverPreplan> preplans = this.getPreplans();
        if (VerifyUtil.isEmpty(preplans)) {
            logger.warn((Object)"The preplan of plan(%s) is empty", new Object[]{this.plan.getId()});
            return;
        }
        this.setProcessUnit(100 / preplans.size());
        this.batchExecuteTask(preplans);
        this.checkTaskSuspendOrStop();
        logger.info((Object)"Recover plan(%s) execute success", new Object[]{this.plan.getId()});
    }

    private void batchExecuteTask(List<RecoverPreplan> preplans) {
        int size = preplans.size();
        CountDownLatch preplanLatch = new CountDownLatch(size);
        ArrayList<Future<RecoverTaskResult>> futures = new ArrayList<Future<RecoverTaskResult>>();
        preplans.forEach(pplan -> this.executePreplan((RecoverPreplan)pplan, preplanLatch, (List<Future<RecoverTaskResult>>)futures));
        preplanLatch.await();
        if (!this.isBatchSuccess(futures)) {
            logger.error((Object)"Recover plan(%s) execute failed", new Object[]{this.plan.getId()});
            throw new LegoCheckedException(1073952116L);
        }
    }

    private List<RecoverPreplan> getPreplans() {
        RecoverPreplanQuery preplanQuery = new RecoverPreplanQuery();
        if (VerifyUtil.isEmpty((Object)this.preplan)) {
            preplanQuery.setSiteId(this.getRecoverContext().getSiteId());
            preplanQuery.setPreplanType(this.getRecoverContext().getRecoverOperateType().getValue());
            preplanQuery.setPlanId(this.plan.getId());
        } else {
            preplanQuery.setRecoverPreplanId(this.preplan.getId());
        }
        return ((RecoverPreplanDaoImpl)ServiceLocator.getInstance().getService(RecoverPreplanDaoImpl.class)).queryPreplans(preplanQuery);
    }

    private void executePreplan(RecoverPreplan pplan, CountDownLatch preplanLatch, List<Future<RecoverTaskResult>> futures) {
        Future<RecoverTaskResult> future;
        Optional<RecoverLog> optionalRecoverLog = this.getCurrentLogByParentId(pplan.getId());
        if (optionalRecoverLog.isPresent() && optionalRecoverLog.get().getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            logger.info((Object)"The recover preplan(%s) task has completed, so not need execute.", new Object[]{pplan.getId()});
            preplanLatch.countDown();
            return;
        }
        RecoverPreplanTask preplanTask = new RecoverPreplanTask(new RecoverContext(this.getRecoverContext().getRequestContext()).setParentLog(this.getRecoverContext().getRecoverLog()).setLatch(preplanLatch).setResourceId(pplan.getId()).setResourceName(pplan.getName()).setResourceType(RecoverResourceType.RECOVER_PREPLAN.getValue()).setSiteId(this.getRecoverContext().getSiteId()).setRecoverOperateType(this.getRecoverContext().getRecoverOperateType()).setSuspendCallBack(this::suspendCallback).setSuccessCallback(this::successCallback), pplan);
        if (optionalRecoverLog.isPresent()) {
            logger.info((Object)"The preplan(%s) task log(%s) has existed, so continue execute.", new Object[]{pplan.getId(), optionalRecoverLog.get().getId()});
            preplanTask.getRecoverContext().setRecoverLog(optionalRecoverLog.get());
            future = RecoverTaskExecuteThreadPool.submit(preplanTask);
        } else {
            logger.info((Object)"Start execute a new preplan(%s) task", new Object[]{pplan.getId()});
            future = RecoverTaskExecuteThreadPool.submitWithRecoverLog(preplanTask);
        }
        futures.add(future);
    }

    @Override
    protected void updateResource(RecoverStatus status) {
        if (this.getRecoverContext().getRecoverLog().getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            this.plan.setLastExecuteTime(this.getRecoverContext().getRecoverLog().getStartTime());
        }
        this.plan.setStatus(status.getValue());
        ((RecoverPlanDaoImpl)ServiceLocator.getInstance().getService(RecoverPlanDaoImpl.class)).updatePlanBasicInfo(this.plan);
    }

    public RecoverPlan getPlan() {
        return this.plan;
    }

    public void setPlan(RecoverPlan plan) {
        this.plan = plan;
    }

    public RecoverPreplan getPreplan() {
        return this.preplan;
    }

    public void setPreplan(RecoverPreplan preplan) {
        this.preplan = preplan;
    }
}

