/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.task.recover;

import com.huawei.csr.framework.common.constants.RecoverExecuteAction;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.common.utils.ResourceUpdateUtil;
import com.huawei.csr.framework.core.task.recover.AbstractRecoverTask;
import com.huawei.csr.framework.core.task.recover.RecoverContext;
import com.huawei.csr.framework.core.task.recover.RecoverStageTask;
import com.huawei.csr.framework.core.task.recover.RecoverTaskExecuteThreadPool;
import com.huawei.csr.framework.core.task.recover.RecoverTaskResult;
import com.huawei.csr.framework.dao.impl.RecoverPreplanDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverStageDaoImpl;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;

public class RecoverPreplanTask
extends AbstractRecoverTask {
    private static final Log logger = LogFactory.getInstance(RecoverPreplanTask.class);
    private RecoverPreplan preplan;

    public RecoverPreplanTask(RecoverContext recoverContext, RecoverPreplan preplan) {
        super(recoverContext);
        this.preplan = preplan;
    }

    @Override
    public void doWork() {
        Optional<RecoverStage> optional = this.getRootStage();
        if (!optional.isPresent()) {
            logger.warn((Object)"The stages of preplan(%s) is empty", new Object[]{this.preplan.getId()});
            return;
        }
        RecoverStage rootStage = optional.get();
        while (true) {
            Optional<RecoverLog> optionalStageLog = this.getCurrentLogByParentId(rootStage.getId());
            this.executeStage(rootStage);
            if (VerifyUtil.isEmpty((String)rootStage.getNextStageId())) {
                logger.info((Object)"The preplan(%s) execute success.", new Object[]{this.preplan.getId()});
                return;
            }
            if (rootStage.getType().equals(RecoverExecuteAction.SUSPEND.getValue()) && !optionalStageLog.isPresent()) {
                this.getRecoverContext().getParentLog().setStatus(RecoverLogStatus.SUSPENDED.getValue());
                logger.info((Object)"The preplan(%s) execute be suspended by suspend type stage.", new Object[]{this.preplan.getId()});
                throw new LegoCheckedException(-1000L);
            }
            this.checkTaskSuspendOrStop();
            rootStage = ((RecoverStageDaoImpl)ServiceLocator.getInstance().getService(RecoverStageDaoImpl.class)).getRecoverStageById(rootStage.getNextStageId());
        }
    }

    @Override
    protected void updateResource(RecoverStatus status) {
        if (this.getRecoverContext().getRecoverLog().getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            this.preplan.setLastExecuteTime(this.getRecoverContext().getRecoverLog().getStartTime());
            this.preplan.setLastExecuteDuration(this.getRecoverContext().getRecoverLog().getEndTime().getTime() - this.getRecoverContext().getRecoverLog().getStartTime().getTime());
            this.preplan.setAverageExecuteDuration(this.getAverageRto());
            if (RecoverOperateType.REPROTECT.getValue().equals(this.preplan.getType())) {
                ResourceUpdateUtil.updateDisasterRecoveryResources(this.preplan.getId());
            }
        }
        this.preplan.setStatus(status.getValue());
        ((RecoverPreplanDaoImpl)ServiceLocator.getInstance().getService(RecoverPreplanDaoImpl.class)).update(this.preplan);
    }

    private void executeStage(RecoverStage rootStage) {
        Future<RecoverTaskResult> future;
        Optional<RecoverLog> optionalRecoverLog = this.getCurrentLogByParentId(rootStage.getId());
        if (optionalRecoverLog.isPresent() && optionalRecoverLog.get().getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            logger.info((Object)"The recover stage(%s) task has completed, so not need execute.", new Object[]{rootStage.getId()});
            return;
        }
        RecoverStageTask stageTask = new RecoverStageTask(new RecoverContext(this.getRecoverContext().getRequestContext()).setParentLog(this.getRecoverContext().getRecoverLog()).setResourceId(rootStage.getId()).setResourceName(rootStage.getName()).setResourceType(RecoverResourceType.RECOVER_STAGE.getValue()).setRecoverOperateType(this.getRecoverContext().getRecoverOperateType()).setSiteId(this.getRecoverContext().getSiteId()).setSuspendCallBack(this::suspendCallback).setSuccessCallback(this::successCallback), rootStage);
        if (optionalRecoverLog.isPresent()) {
            logger.info((Object)"The stage(%s) task log(%s) has existed, so continue execute.", new Object[]{rootStage.getId(), optionalRecoverLog.get().getId()});
            stageTask.getRecoverContext().setRecoverLog(optionalRecoverLog.get());
            future = RecoverTaskExecuteThreadPool.submit(stageTask);
        } else {
            logger.info((Object)"Start execute a new stage(%s) task", new Object[]{rootStage.getId()});
            future = RecoverTaskExecuteThreadPool.submitWithRecoverLog(stageTask);
        }
        if (!this.isBatchSuccess(Collections.singletonList(future))) {
            logger.error((Object)"The preplan(%s) execute failed", new Object[]{this.preplan.getId()});
            throw new LegoCheckedException(1073952807L, new String[]{this.preplan.getName()});
        }
    }

    private Optional<RecoverStage> getRootStage() {
        List<RecoverStage> stages = ((RecoverStageDaoImpl)ServiceLocator.getInstance().getService(RecoverStageDaoImpl.class)).getRecoverStageListByPrePlan(this.getRecoverContext().getRequestContext().getProjectId(), this.preplan.getId());
        if (!VerifyUtil.isEmpty(stages)) {
            this.setProcessUnit(100 / stages.size());
            RecoverStage stage = stages.get(0);
            while (stage != null) {
                String preStageId = stage.getPreStageId();
                if (VerifyUtil.isEmpty((String)preStageId)) {
                    return Optional.of(stage);
                }
                stage = ((RecoverStageDaoImpl)ServiceLocator.getInstance().getService(RecoverStageDaoImpl.class)).getRecoverStageById(preStageId);
            }
        }
        return Optional.empty();
    }

    public RecoverPreplan getPreplan() {
        return this.preplan;
    }

    public void setPreplan(RecoverPreplan preplan) {
        this.preplan = preplan;
    }
}

