/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.task.recover;

import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.core.task.recover.AbstractRecoverTask;
import com.huawei.csr.framework.core.task.recover.RecoverContext;
import com.huawei.csr.framework.core.task.recover.RecoverFlowTask;
import com.huawei.csr.framework.core.task.recover.RecoverTaskExecuteThreadPool;
import com.huawei.csr.framework.core.task.recover.RecoverTaskResult;
import com.huawei.csr.framework.dao.impl.RecoverFlowChainDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverFlowDaoImpl;
import com.huawei.csr.framework.dao.impl.StageFlowMapDaoImpl;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverFlowChain;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

public class RecoverStageTask
extends AbstractRecoverTask {
    private static final Log logger = LogFactory.getInstance(RecoverStageTask.class);
    private RecoverStage stage;

    public RecoverStageTask(RecoverContext recoverContext, RecoverStage stage) {
        super(recoverContext);
        this.stage = stage;
    }

    @Override
    public void doWork() {
        Queue<RecoverFlow> rootFlows = this.getRootFlows();
        while (!rootFlows.isEmpty()) {
            this.batchExecuteTask(rootFlows);
            if (VerifyUtil.isEmpty(rootFlows)) {
                logger.info((Object)"Recover flows of recover stage %s has finished.", new Object[]{this.stage.getId()});
                break;
            }
            this.checkTaskSuspendOrStop();
        }
        this.checkRecoverResources(RecoverResourceType.RECOVER_FLOW.getValue());
        logger.info((Object)"Recover stage(%s) execute success", new Object[]{this.stage.getId()});
    }

    private void batchExecuteTask(Queue<RecoverFlow> rootFlows) {
        int size = rootFlows.size();
        CountDownLatch flowLatch = new CountDownLatch(size);
        HashSet visited = new HashSet();
        ArrayList<Future<RecoverTaskResult>> futures = new ArrayList<Future<RecoverTaskResult>>();
        for (int index = 0; index < size; ++index) {
            RecoverFlow flow = rootFlows.remove();
            this.executeFlow(flow, flowLatch, futures);
            List<RecoverFlowChain> nextFlowChainList = ((RecoverFlowChainDaoImpl)ServiceLocator.getInstance().getService(RecoverFlowChainDaoImpl.class)).getNextFlowChainList(this.stage.getId(), flow.getId());
            nextFlowChainList.forEach(nextFlowChain -> {
                if (!visited.contains(nextFlowChain.getNextFlowId())) {
                    rootFlows.add(((RecoverFlowDaoImpl)ServiceLocator.getInstance().getService(RecoverFlowDaoImpl.class)).getRecoverFlowById(nextFlowChain.getNextFlowId()));
                    visited.add(nextFlowChain.getNextFlowId());
                }
            });
        }
        flowLatch.await();
        if (!this.isBatchSuccess(futures)) {
            logger.error((Object)"Recover stage(%s) execute failed", new Object[]{this.stage.getId()});
            throw new LegoCheckedException(1073952702L, new String[]{this.stage.getName()});
        }
    }

    private void executeFlow(RecoverFlow flow, CountDownLatch flowLatch, List<Future<RecoverTaskResult>> futures) {
        Future<RecoverTaskResult> future;
        Optional<RecoverLog> optionalRecoverLog = this.getCurrentLogByParentId(flow.getId());
        if (optionalRecoverLog.isPresent() && optionalRecoverLog.get().getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            logger.info((Object)"The recover flow(%s) task has completed, so not need execute.", new Object[]{flow.getId()});
            flowLatch.countDown();
            return;
        }
        RecoverFlowTask flowTask = new RecoverFlowTask(new RecoverContext(this.getRecoverContext().getRequestContext()).setParentLog(this.getRecoverContext().getRecoverLog()).setLatch(flowLatch).setResourceId(flow.getId()).setResourceName(flow.getName()).setResourceType(RecoverResourceType.RECOVER_FLOW.getValue()).setSiteId(this.getRecoverContext().getSiteId()).setRecoverOperateType(this.getRecoverContext().getRecoverOperateType()).setSuspendCallBack(this::suspendCallback).setSuccessCallback(this::successCallback), flow);
        if (optionalRecoverLog.isPresent()) {
            logger.info((Object)"The flow(%s) task log(%s) has existed, so continue execute.", new Object[]{flow.getId(), optionalRecoverLog.get().getId()});
            flowTask.getRecoverContext().setRecoverLog(optionalRecoverLog.get());
            future = RecoverTaskExecuteThreadPool.submit(flowTask);
        } else {
            logger.info((Object)"Start execute a new flow(%s) task", new Object[]{flow.getId()});
            future = RecoverTaskExecuteThreadPool.submitWithRecoverLog(flowTask);
        }
        futures.add(future);
    }

    private Queue<RecoverFlow> getRootFlows() {
        List<StageFlowMap> stageFlowMaps = ((StageFlowMapDaoImpl)ServiceLocator.getInstance().getService(StageFlowMapDaoImpl.class)).queryStageFlowMapByStageId(this.stage.getId());
        LinkedList<RecoverFlow> rootFlows = new LinkedList<RecoverFlow>();
        if (VerifyUtil.isEmpty(stageFlowMaps)) {
            return rootFlows;
        }
        this.setProcessUnit(100 / stageFlowMaps.size());
        HashSet<String> visited = new HashSet<String>();
        for (StageFlowMap stageFlowMap : stageFlowMaps) {
            if (visited.contains(stageFlowMap.getFlowId())) continue;
            this.addRootFlow(stageFlowMap, visited, rootFlows);
        }
        return rootFlows;
    }

    private void addRootFlow(StageFlowMap stageFlowMap, Set<String> visited, Queue<RecoverFlow> rootFlows) {
        LinkedList<String> flowIds = new LinkedList<String>();
        flowIds.add(stageFlowMap.getFlowId());
        visited.add(stageFlowMap.getFlowId());
        while (!VerifyUtil.isEmpty(flowIds)) {
            String flowId = (String)flowIds.remove();
            RecoverFlow recoverFlow = ((RecoverFlowDaoImpl)ServiceLocator.getInstance().getService(RecoverFlowDaoImpl.class)).getRecoverFlowById(flowId);
            List<RecoverFlowChain> preFlowChainList = ((RecoverFlowChainDaoImpl)ServiceLocator.getInstance().getService(RecoverFlowChainDaoImpl.class)).getPreFlowChainList(this.stage.getId(), flowId);
            if (VerifyUtil.isEmpty(preFlowChainList)) {
                rootFlows.add(recoverFlow);
                continue;
            }
            preFlowChainList.forEach(preFlowChain -> {
                if (!visited.contains(preFlowChain.getPreFlowId())) {
                    flowIds.add(preFlowChain.getPreFlowId());
                    visited.add(preFlowChain.getPreFlowId());
                }
            });
        }
    }

    @Override
    protected boolean resourceExsit(String resourceId) {
        return !VerifyUtil.isEmpty((Object)((RecoverFlowDaoImpl)ServiceLocator.getInstance().getService(RecoverFlowDaoImpl.class)).getRecoverFlowById(resourceId));
    }

    public RecoverStage getStage() {
        return this.stage;
    }

    public void setStage(RecoverStage stage) {
        this.stage = stage;
    }
}

