/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.task.recover;

import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.core.executor.AbstractStepExecutor;
import com.huawei.csr.framework.core.executor.StepExecuteContext;
import com.huawei.csr.framework.core.executor.StepExecutorManager;
import com.huawei.csr.framework.core.identifier.StepIdentifier;
import com.huawei.csr.framework.core.task.recover.AbstractRecoverTask;
import com.huawei.csr.framework.core.task.recover.RecoverContext;
import com.huawei.csr.framework.dao.impl.RecoverStepDaoImpl;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;

public class RecoverStepTask
extends AbstractRecoverTask {
    private static final Log logger = LogFactory.getInstance(RecoverStepTask.class);
    private static final int SLEEP_TIME_DEFAULT = 1000;
    private RecoverStep step;

    public RecoverStepTask(RecoverContext recoverContext, RecoverStep step) {
        super(recoverContext);
        this.step = step;
    }

    @Override
    public void doWork() {
        AbstractStepExecutor stepExecutor = StepExecutorManager.getInstance().getStepExecutor(new StepIdentifier(this.step.getServiceType(), this.step.getAction()));
        try {
            this.beforeStepTask();
            stepExecutor.work(this.step, new StepExecuteContext(this.getRecoverContext().getSiteId(), this.getRecoverContext().getRequestContext(), this.getRecoverContext().getRecoverOperateType()));
            this.afterStepTask();
        }
        catch (ClientException err) {
            logger.error((Object)"Before call service(%s) instance(%s) step(%s) occur exc, msg: %s", new Object[]{this.step.getServiceType(), this.step.getServiceInstanceId(), this.step.getAction(), ExceptionUtil.getErrorMessage((Throwable)err)});
            throw new LegoCheckedException(-1L, (Throwable)err);
        }
        catch (IOException err) {
            logger.error((Object)"Call service(%s) instance(%s) step(%s) http occur exc, msg: %s", new Object[]{this.step.getServiceType(), this.step.getServiceInstanceId(), this.step.getAction(), ExceptionUtil.getErrorMessage((Throwable)err)});
            throw new LegoCheckedException(1073952401L, (Throwable)err);
        }
        catch (ResponseException err) {
            logger.error((Object)"Service(%s) instance(%s) step(%s) interface result error, msg: %s", new Object[]{this.step.getServiceType(), this.step.getServiceInstanceId(), this.step.getAction(), ExceptionUtil.getErrorMessage((Throwable)err)});
            throw new LegoCheckedException(1073952402L, (Throwable)err);
        }
        logger.info((Object)"Execute service(%s) instance(%s) step(%s) success.", new Object[]{this.step.getServiceType(), this.step.getServiceInstanceId(), this.step.getAction()});
    }

    private void beforeStepTask() {
        if (this.step.getPreDelayTime() > 0L) {
            logger.debug((Object)"Step(%s) before delay(%s)", new Object[]{this.step.getName(), this.step.getPreDelayTime()});
            CommonUtil.sleep((long)(this.step.getPreDelayTime() * 1000L));
        }
    }

    private void afterStepTask() {
        if (this.step.getAfterDelayTime() > 0L) {
            logger.debug((Object)"Step(%s) after delay(%s)", new Object[]{this.step.getName(), this.step.getPreDelayTime()});
            CommonUtil.sleep((long)(this.step.getAfterDelayTime() * 1000L));
        }
    }

    @Override
    protected void updateResource(RecoverStatus status) {
        if (this.getRecoverContext().getRecoverLog().getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            this.step.setLastExecuteTime(this.getRecoverContext().getRecoverLog().getStartTime());
            this.step.setLastExecuteDuration(this.getRecoverContext().getRecoverLog().getEndTime().getTime() - this.getRecoverContext().getRecoverLog().getStartTime().getTime());
            this.step.setAverageExecuteDuration(this.getAverageRto());
        }
        this.step.setStatus(status.getValue());
        ((RecoverStepDaoImpl)ServiceLocator.getInstance().getService(RecoverStepDaoImpl.class)).update(this.step);
    }

    public RecoverStep getStep() {
        return this.step;
    }

    public void setStep(RecoverStep step) {
        this.step = step;
    }
}

