/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.task.recover;

import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.common.utils.DateUtil;
import com.huawei.csr.framework.core.task.recover.AbstractRecoverTask;
import com.huawei.csr.framework.core.task.recover.RecoverTaskResult;
import com.huawei.csr.framework.core.thread.ThreadPoolFactory;
import com.huawei.csr.framework.dao.impl.RecoverLogDaoImpl;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

public final class RecoverTaskExecuteThreadPool {
    private static final Log logger = LogFactory.getInstance(RecoverTaskExecuteThreadPool.class);
    private static Map<String, ThreadPoolExecutor> executorMap = new ConcurrentHashMap<String, ThreadPoolExecutor>();

    private RecoverTaskExecuteThreadPool() {
    }

    private static ThreadPoolExecutor getExecutor() {
        return executorMap.computeIfAbsent("recover-task-execute", value -> ThreadPoolFactory.getThreadPool("recover-task-execute"));
    }

    private static ThreadPoolExecutor getExecutor(String threadPoolName) {
        return executorMap.computeIfAbsent(threadPoolName, value -> ThreadPoolFactory.getThreadPool(threadPoolName));
    }

    public static Future<RecoverTaskResult> submit(AbstractRecoverTask recoverTask) {
        try {
            logger.info((Object)"Current executing task count: %s", new Object[]{String.valueOf(RecoverTaskExecuteThreadPool.getExecutor().getActiveCount())});
            return RecoverTaskExecuteThreadPool.getExecutor().submit(recoverTask);
        }
        catch (RejectedExecutionException err) {
            logger.error((Object)"The tasks has reached the upper limit, err: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err)});
            throw new LegoCheckedException(1073952405L);
        }
    }

    public static Future<RecoverTaskResult> submit(AbstractRecoverTask recoverTask, String threadPoolName) {
        try {
            logger.info((Object)"Current executing task count: %s", new Object[]{String.valueOf(RecoverTaskExecuteThreadPool.getExecutor(threadPoolName).getActiveCount())});
            return RecoverTaskExecuteThreadPool.getExecutor(threadPoolName).submit(recoverTask);
        }
        catch (RejectedExecutionException err) {
            logger.error((Object)"The tasks of (%s) pool has reached the upper limit, err: %s", new Object[]{threadPoolName, ExceptionUtil.getErrorMessage((Throwable)err)});
            throw new LegoCheckedException(1073952405L);
        }
    }

    public static Future<RecoverTaskResult> submitWithRecoverLog(AbstractRecoverTask recoverTask) {
        RecoverLog recoverLog = RecoverTaskExecuteThreadPool.createRecoverLog(recoverTask);
        recoverTask.getRecoverContext().setRecoverLog(recoverLog);
        try {
            logger.info((Object)"Current executing task count: %s", new Object[]{String.valueOf(RecoverTaskExecuteThreadPool.getExecutor().getActiveCount())});
            return RecoverTaskExecuteThreadPool.getExecutor().submit(recoverTask);
        }
        catch (RejectedExecutionException err) {
            logger.error((Object)"The tasks has reached the upper limit, err: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err)});
            throw new LegoCheckedException(1073952405L);
        }
    }

    public static Future<RecoverTaskResult> submitWithRecoverLog(AbstractRecoverTask recoverTask, String threadPoolName) {
        RecoverLog recoverLog = RecoverTaskExecuteThreadPool.createRecoverLog(recoverTask);
        recoverTask.getRecoverContext().setRecoverLog(recoverLog);
        try {
            logger.info((Object)"Current executing task count: %s", new Object[]{String.valueOf(RecoverTaskExecuteThreadPool.getExecutor(threadPoolName).getActiveCount())});
            return RecoverTaskExecuteThreadPool.getExecutor(threadPoolName).submit(recoverTask);
        }
        catch (RejectedExecutionException err) {
            logger.error((Object)"The tasks of (%s) pool has reached the upper limit, err: %s", new Object[]{threadPoolName, ExceptionUtil.getErrorMessage((Throwable)err)});
            throw new LegoCheckedException(1073952405L);
        }
    }

    public static String submitWithTaskId(AbstractRecoverTask recoverTask) {
        RecoverLog recoverLog = RecoverTaskExecuteThreadPool.createRecoverLog(recoverTask);
        recoverTask.getRecoverContext().setRecoverLog(recoverLog);
        try {
            logger.info((Object)"Current executing task count: %s", new Object[]{String.valueOf(RecoverTaskExecuteThreadPool.getExecutor().getActiveCount())});
            Future<RecoverTaskResult> future = RecoverTaskExecuteThreadPool.getExecutor().submit(recoverTask);
            logger.debug((Object)"Task submit success, future: %s", new Object[]{future});
        }
        catch (RejectedExecutionException err) {
            logger.error((Object)"The tasks has reached the upper limit, err: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)err)});
            throw new LegoCheckedException(1073952405L);
        }
        return recoverLog.getId();
    }

    public static String submitWithTaskId(AbstractRecoverTask recoverTask, String threadPoolName) {
        RecoverLog recoverLog = RecoverTaskExecuteThreadPool.createRecoverLog(recoverTask);
        recoverTask.getRecoverContext().setRecoverLog(recoverLog);
        try {
            logger.info((Object)"Current executing task count: %s", new Object[]{String.valueOf(RecoverTaskExecuteThreadPool.getExecutor(threadPoolName).getActiveCount())});
            Future<RecoverTaskResult> future = RecoverTaskExecuteThreadPool.getExecutor(threadPoolName).submit(recoverTask);
            logger.debug((Object)"Task submit to (%s) pool success, future: %s", new Object[]{threadPoolName, future});
        }
        catch (RejectedExecutionException err) {
            logger.error((Object)"The tasks of (%s) pool has reached the upper limit, err: %s", new Object[]{threadPoolName, ExceptionUtil.getErrorMessage((Throwable)err)});
            throw new LegoCheckedException(1073952405L);
        }
        return recoverLog.getId();
    }

    private static RecoverLog createRecoverLog(AbstractRecoverTask recoverTask) {
        RecoverLog recoverLog = new RecoverLog();
        recoverLog.setProjectId(recoverTask.getRecoverContext().getRequestContext().getProjectId());
        recoverLog.setStartTime(new Timestamp(DateUtil.getUtcTimeStamp()));
        recoverLog.setProcess(0);
        recoverLog.setStatus(RecoverLogStatus.WAITING.getValue());
        recoverLog.setResourceId(recoverTask.getRecoverContext().getResourceId());
        recoverLog.setResourceName(recoverTask.getRecoverContext().getResourceName());
        recoverLog.setSiteId(recoverTask.getRecoverContext().getSiteId());
        recoverLog.setResourceType(recoverTask.getRecoverContext().getResourceType());
        if (!VerifyUtil.isEmpty((Object)((Object)recoverTask.getRecoverContext().getRecoverOperateType()))) {
            recoverLog.setOperationType(recoverTask.getRecoverContext().getRecoverOperateType().getValue());
        }
        if (!VerifyUtil.isEmpty((Object)recoverTask.getRecoverContext().getParentLog())) {
            recoverLog.setParentId(recoverTask.getRecoverContext().getParentLog().getId());
        }
        ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).save(recoverLog);
        return recoverLog;
    }
}

