/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.task.recover;

import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.model.SitePlanMapQuery;
import com.huawei.csr.framework.common.statusopt.StatusOptChecker;
import com.huawei.csr.framework.common.statusopt.opt.RecoverPlanOpt;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.core.task.recover.AbstractRecoverTask;
import com.huawei.csr.framework.core.task.recover.RecoverContext;
import com.huawei.csr.framework.core.task.recover.RecoverPlanTask;
import com.huawei.csr.framework.core.task.recover.RecoverTaskExecuteThreadPool;
import com.huawei.csr.framework.core.task.recover.RecoverTaskResult;
import com.huawei.csr.framework.dao.impl.RecoverLogDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPlanDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPreplanDaoImpl;
import com.huawei.csr.framework.dao.impl.SitePlanDaoImpl;
import com.huawei.csr.framework.dao.impl.SitePlanMapDaoImpl;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.dao.model.SitePlan;
import com.huawei.csr.framework.dao.model.SitePlanMap;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

public class SitePlanTask
extends AbstractRecoverTask {
    private static final Log LOG = LogFactory.getInstance(SitePlanTask.class);
    private SitePlan sitePlan;
    private String continuePlanId;

    public SitePlanTask(RecoverContext recoverContext, SitePlan sitePlan, String continuePlanId) {
        super(recoverContext);
        this.sitePlan = sitePlan;
        this.continuePlanId = continuePlanId;
    }

    @Override
    public void doWork() {
        Optional<Deque<List<String>>> planGroupIdsOpt = this.getRecoverPlans();
        if (!planGroupIdsOpt.isPresent()) {
            LOG.warn((Object)"The plan of sitePlan(%s) is empty", new Object[]{this.sitePlan.getId()});
            return;
        }
        Deque<Object> planGroupIds = new LinkedList<List<String>>();
        if (VerifyUtil.isEmpty((String)this.continuePlanId)) {
            planGroupIds = this.createRecoverPlanLogs(planGroupIdsOpt.get());
        } else {
            planGroupIds.add(Collections.singletonList(this.continuePlanId));
        }
        while (!VerifyUtil.isEmpty(planGroupIds)) {
            List planIds = (List)planGroupIds.remove();
            this.batchExecuteTask(planIds);
            if (VerifyUtil.isEmpty(planGroupIds) && VerifyUtil.isEmpty((String)this.continuePlanId)) {
                LOG.info((Object)"Recover plans of site plan %s has finished.", new Object[]{this.sitePlan.getId()});
                break;
            }
            this.checkTaskSuspendOrStop();
            this.checkRecoverResources(RecoverResourceType.RECOVER_PLAN.getValue());
        }
    }

    private void updateExistRecoverPlanLog(RecoverLog recoverLog) {
        if (!recoverLog.getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            recoverLog.setProcess(0);
            recoverLog.setStatus(RecoverLogStatus.WAITING.getValue());
            ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).update(recoverLog);
        }
    }

    private void saveNewRecoverPlanLog(String planId) {
        RecoverLog recoverLog = new RecoverLog();
        recoverLog.setProjectId(this.getRecoverContext().getRequestContext().getProjectId());
        recoverLog.setProcess(0);
        recoverLog.setStatus(RecoverLogStatus.WAITING.getValue());
        recoverLog.setResourceId(planId);
        recoverLog.setResourceName(((RecoverPlanDaoImpl)ServiceLocator.getInstance().getService(RecoverPlanDaoImpl.class)).getRecoverPlanById(planId).getName());
        recoverLog.setSiteId(this.getRecoverContext().getSiteId());
        recoverLog.setResourceType(RecoverResourceType.RECOVER_PLAN.getValue());
        recoverLog.setOperationType(this.getRecoverContext().getRecoverOperateType().getValue());
        recoverLog.setParentId(this.getRecoverContext().getRecoverLog().getId());
        ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).save(recoverLog);
    }

    private Deque<List<String>> createRecoverPlanLogs(Deque<List<String>> lists) {
        LinkedList<List<String>> tempQueue = new LinkedList<List<String>>();
        while (lists.size() > 0) {
            List<String> planIdList = lists.pop();
            planIdList.forEach(planId -> {
                Optional<RecoverLog> optionalLog = this.getCurrentLogByParentId((String)planId);
                if (optionalLog.isPresent()) {
                    this.updateExistRecoverPlanLog(optionalLog.get());
                } else {
                    this.saveNewRecoverPlanLog((String)planId);
                }
            });
            tempQueue.add(planIdList);
        }
        return tempQueue;
    }

    private void batchExecuteTask(List<String> planIds) {
        int size = planIds.size();
        CountDownLatch planLatch = new CountDownLatch(size);
        ArrayList<Future<RecoverTaskResult>> futures = new ArrayList<Future<RecoverTaskResult>>();
        planIds.forEach(planId -> {
            RecoverPlan plan = ((RecoverPlanDaoImpl)ServiceLocator.getInstance().getService(RecoverPlanDaoImpl.class)).getRecoverPlanById((String)planId);
            this.executePlan(plan, planLatch, futures);
        });
        planLatch.await();
        if (!this.isBatchSuccess(futures)) {
            LOG.error((Object)"Site plan(%s) execute failed", new Object[]{this.sitePlan.getId()});
            throw new LegoCheckedException(1073952219L);
        }
    }

    private Optional<Deque<List<String>>> getRecoverPlans() {
        SitePlanMapQuery sitePlanMapQuery = new SitePlanMapQuery();
        sitePlanMapQuery.setSitePlanId(this.sitePlan.getId());
        List<SitePlanMap> sitePlanMaps = ((SitePlanMapDaoImpl)ServiceLocator.getInstance().getService(SitePlanMapDaoImpl.class)).queryPagedSitePlanMapBySitePlanId(sitePlanMapQuery);
        sitePlanMaps.removeIf(sitePlanMap -> this.removeRecoverPlanFromTask(sitePlanMap.getRecoverPlanId()));
        if (VerifyUtil.isEmpty(sitePlanMaps)) {
            return Optional.empty();
        }
        sitePlanMaps.sort(Comparator.comparingInt(SitePlanMap::getPriority));
        LinkedList planIds = new LinkedList();
        ArrayList<String> subPlanIds = new ArrayList<String>();
        subPlanIds.add(sitePlanMaps.get(0).getRecoverPlanId());
        planIds.add(subPlanIds);
        for (int i = 1; i < sitePlanMaps.size(); ++i) {
            SitePlanMap sitePlanMap2 = sitePlanMaps.get(i);
            if (sitePlanMap2.getPriority() != sitePlanMaps.get(i - 1).getPriority()) {
                subPlanIds = new ArrayList();
                subPlanIds.add(sitePlanMap2.getRecoverPlanId());
                planIds.add(subPlanIds);
                continue;
            }
            ((List)planIds.peekLast()).add(sitePlanMap2.getRecoverPlanId());
        }
        this.setProcessUnit(100 / sitePlanMaps.size());
        return Optional.of(planIds);
    }

    private boolean removeRecoverPlanFromTask(String planId) {
        RecoverPlan plan = ((RecoverPlanDaoImpl)ServiceLocator.getInstance().getService(RecoverPlanDaoImpl.class)).getRecoverPlanById(planId);
        if (VerifyUtil.isEmpty((Object)plan)) {
            LOG.info((Object)"Recover plan %s empty.", new Object[]{planId});
            return true;
        }
        if (!this.executablePreplanExist(plan, this.getRecoverContext().getRecoverOperateType())) {
            LOG.info((Object)"Preplan type %s of site plan %s is empty in recover plan %s.", new Object[]{this.getRecoverContext().getRecoverOperateType().getValue(), this.sitePlan.getId(), planId});
            return true;
        }
        try {
            StatusOptChecker.checkRecoverPlanStatusOpt(RecoverStatus.from(plan.getStatus()).getIndex(), RecoverPlanOpt.from(this.getRecoverContext().getRecoverOperateType().getValue()).getIndex(), 1073952403L);
            if (!(RecoverStatus.NORMAL.getValue().equals(plan.getStatus()) || RecoverStatus.DISASTER_RECOVERY_COMPLETED.getValue().equals(plan.getStatus()) || this.getCurrentLogByParentId(planId).isPresent())) {
                LOG.info((Object)"Recover plan %s status is %s,contain unfinished task,remove from sitePlanTask.", new Object[]{planId, plan.getStatus()});
                return true;
            }
        }
        catch (LegoCheckedException exception) {
            LOG.info((Object)"Recover plan %s status is %s,can't execute,remove from sitePlanTask.", new Object[]{planId, plan.getStatus()});
            return true;
        }
        return false;
    }

    private void executePlan(RecoverPlan plan, CountDownLatch planLatch, List<Future<RecoverTaskResult>> futures) {
        Optional<RecoverLog> optionalRecoverLog = this.getCurrentLogByParentId(plan.getId());
        if (optionalRecoverLog.isPresent() && optionalRecoverLog.get().getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            LOG.info((Object)"The recover plan(%s) task has completed, so not need execute.", new Object[]{plan.getId()});
            planLatch.countDown();
            return;
        }
        if (!optionalRecoverLog.isPresent()) {
            LOG.error((Object)"Recover plan: %s log is empty in site plan %s", new Object[]{plan.getId(), this.sitePlan.getId()});
            throw new LegoCheckedException(1073952219L);
        }
        RecoverPlanTask planTask = new RecoverPlanTask(new RecoverContext(this.getRecoverContext().getRequestContext()).setParentLog(this.getRecoverContext().getRecoverLog()).setLatch(planLatch).setRecoverLog(optionalRecoverLog.get()).setResourceId(plan.getId()).setResourceName(plan.getName()).setResourceType(RecoverResourceType.RECOVER_PLAN.getValue()).setSiteId(this.getRecoverContext().getSiteId()).setRecoverOperateType(this.getRecoverContext().getRecoverOperateType()).setSuspendCallBack(this::suspendCallback).setSuccessCallback(this::successCallback), plan, null);
        LOG.info((Object)"The plan(%s) task log(%s) has existed, so continue execute.", new Object[]{plan.getId(), optionalRecoverLog.get().getId()});
        planTask.getRecoverContext().setRecoverLog(optionalRecoverLog.get());
        Future<RecoverTaskResult> future = RecoverTaskExecuteThreadPool.submit(planTask);
        futures.add(future);
    }

    private boolean executablePreplanExist(RecoverPlan plan, RecoverOperateType recoverOperateType) {
        RecoverPreplanQuery recoverPreplanQuery = new RecoverPreplanQuery();
        recoverPreplanQuery.setPlanId(plan.getId());
        recoverPreplanQuery.setSiteId(this.sitePlan.getSiteId());
        recoverPreplanQuery.setPreplanType(recoverOperateType.getValue());
        return ((RecoverPreplanDaoImpl)ServiceLocator.getInstance().getService(RecoverPreplanDaoImpl.class)).queryPreplansCount(recoverPreplanQuery) > 0;
    }

    @Override
    protected boolean resourceExsit(String resourceId) {
        return !this.removeRecoverPlanFromTask(resourceId);
    }

    @Override
    protected void updateResource(RecoverStatus status) {
        if (this.getRecoverContext().getRecoverLog().getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            this.sitePlan.setLastExecuteTime(this.getRecoverContext().getRecoverLog().getStartTime());
        }
        this.sitePlan.setStatus(status.getValue());
        ((SitePlanDaoImpl)ServiceLocator.getInstance().getService(SitePlanDaoImpl.class)).updateSitePlan(this.sitePlan);
    }

    public SitePlan getSitePlan() {
        return this.sitePlan;
    }

    public void setSitePlan(SitePlan sitePlan) {
        this.sitePlan = sitePlan;
    }
}

