/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.core.thread;

import com.huawei.csr.framework.config.YamlConfigFactory;
import com.huawei.csr.framework.core.thread.ThreadPoolConfig;
import com.huawei.csr.framework.core.thread.ThreadPoolsConfig;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.PathUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPoolFactory {
    private static Map<String, ThreadPoolExecutor> threadPoolExecutorMap = new HashMap<String, ThreadPoolExecutor>();
    private static Map<String, ThreadPoolConfig> configMap = null;
    private static final String CONFIG_FILE = "/csr/conf/threadpool.yaml";

    private ThreadPoolFactory() {
    }

    public static synchronized ThreadPoolExecutor getThreadPool(String threadPoolName) {
        if (!ThreadPoolFactory.getConfig().containsKey(threadPoolName)) {
            throw new LegoCheckedException("The thread pool name not in the yaml file, name: " + threadPoolName);
        }
        if (!threadPoolExecutorMap.containsKey(threadPoolName)) {
            ThreadPoolConfig config = ThreadPoolFactory.getConfig().get(threadPoolName);
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(config.getCorePoolSize(), config.getMaximumPoolSize(), config.getKeepAliveTime(), TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(config.getQueueCapacity(), true));
            threadPoolExecutor.allowCoreThreadTimeOut(config.isAllowCoreThreadTimeOut());
            threadPoolExecutorMap.put(threadPoolName, threadPoolExecutor);
            return threadPoolExecutor;
        }
        return threadPoolExecutorMap.get(threadPoolName);
    }

    private static synchronized Map<String, ThreadPoolConfig> getConfig() {
        if (configMap == null) {
            configMap = new HashMap<String, ThreadPoolConfig>();
            ThreadPoolsConfig threadPoolsConfig = (ThreadPoolsConfig)YamlConfigFactory.getInstance(PathUtil.getInstallPath() + CONFIG_FILE, ThreadPoolsConfig.class).getConfig();
            for (ThreadPoolConfig config : threadPoolsConfig.getThreadPoolsConfig()) {
                configMap.put(config.getName(), config);
            }
        }
        return configMap;
    }
}

