/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.model.ApplicationQuery;
import com.huawei.csr.framework.common.model.PageQuery;
import com.huawei.csr.framework.common.utils.CommonUtil;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.JoinField;
import com.huawei.csr.framework.dao.support.JoinManager;
import com.huawei.csr.framework.dao.support.SelectField;
import com.huawei.csr.framework.dao.support.SelectManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.base.util.ConverterUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.apache.commons.compress.utils.Lists;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ApplicationDaoImpl
extends BaseDao<Application>
implements ApplicationDao {
    @Override
    public void saveApp(Application application) {
        this.checkParams(application);
        this.saveRecord(application);
    }

    @Override
    public void saveOrUpdate(Application application) {
        this.saveOrUpdateRecord(application);
    }

    @Override
    public void updateAppInfo(Application application) {
        this.checkParams(application);
        UpdateManager updateManager = new UpdateManager();
        updateManager.addQueryField(Application.class, "name", application.getName());
        updateManager.addQueryField(Application.class, "description", application.getDescription());
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(Application.class, "id", application.getId());
        conditionManager.addQueryField(Application.class, "projectId", application.getProjectId());
        this.updateRecord(Application.class, updateManager, conditionManager);
    }

    @Override
    public void deleteApp(String appId) {
        this.checkParams(appId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(Application.class, "id", appId);
        this.deleteRecords(Application.class, conditionManager);
    }

    @Override
    public Application getApp(String appId) {
        this.checkParams(appId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(Application.class, "id", appId);
        return this.queryRecord(Application.class, conditionManager);
    }

    @Override
    public Application getApp(String appId, String projectId) {
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(Application.class, "id", appId);
        conditionManager.addQueryField(Application.class, "projectId", projectId);
        return this.queryRecord(Application.class, conditionManager);
    }

    @Override
    public void updateAppStatus(String appId, String status) {
        this.checkParams(appId, status);
        UpdateManager updateManager = new UpdateManager();
        updateManager.addQueryField(Application.class, "status", status);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(Application.class, "id", appId);
        this.updateRecord(Application.class, updateManager, conditionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Application> getAppList(ApplicationQuery appQuery) {
        List resultList;
        this.checkParams(appQuery);
        try (Session session = null;){
            session = this.getHibernateTamplate().getSessionFactory().openSession();
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(Application.class);
            Root applicationRoot = cq.from(Application.class);
            Join serviceInstances = applicationRoot.join("serviceInstances", JoinType.LEFT);
            this.builcCriteria(appQuery, cb, cq, (Root<Application>)applicationRoot, (Join<Application, AppServiceInstance>)serviceInstances);
            cq.distinct(true);
            ArrayList<Order> orderList = new ArrayList<Order>();
            orderList.add(cb.desc((Expression)applicationRoot.get("createdAt")));
            cq.orderBy(orderList);
            int marker = appQuery.getMarker();
            int limit = appQuery.getLimit();
            if (appQuery.isPage() && !VerifyUtil.isEmpty((String)appQuery.getFlowId())) {
                if (marker == 0) {
                    --limit;
                } else {
                    --marker;
                }
            }
            resultList = appQuery.isPage() ? session.createQuery(cq).setFirstResult(marker).setMaxResults(limit).getResultList() : session.createQuery(cq).getResultList();
        }
        return resultList;
    }

    @Override
    public long getAppCountByRecoverPlanId(String recoverPlanId) {
        this.checkParams(recoverPlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(Application.class, "recoverPlanId", recoverPlanId);
        return this.getRecordsCount(Application.class, conditionManager);
    }

    @Override
    public void updateAppRecoverPlanId(String projectId, String applicationId, String recoverPlanId) {
        this.checkParams(projectId, applicationId);
        UpdateManager updateManager = new UpdateManager();
        updateManager.addQueryField(Application.class, "recoverPlanId", recoverPlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(Application.class, "id", applicationId);
        conditionManager.addQueryField(Application.class, "projectId", projectId);
        this.updateRecord(Application.class, updateManager, conditionManager);
    }

    @Override
    public List<Application> getAppByRecoverPlanId(String projectId, String recoverPlanId) {
        this.checkParams(projectId, recoverPlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(Application.class, "projectId", projectId);
        conditionManager.addQueryField(Application.class, "recoverPlanId", recoverPlanId);
        return this.queryRecordsList(Application.class, conditionManager);
    }

    @Override
    public void deleteApp(Application app) {
        this.checkParams(app);
        this.deleteRecord(app);
    }

    @Override
    public HibernateTemplate getHibernateTamplate() {
        return super.getHibernateTemplate();
    }

    @Override
    public List<Application> getAppList(Integer limit, Integer marker) {
        this.checkParams(limit, marker);
        PageQuery pageQuery = new PageQuery();
        pageQuery.setMarker(marker);
        pageQuery.setLimit(limit);
        pageQuery.setPage(true);
        ConditionManager conditionManager = new ConditionManager(pageQuery);
        return this.queryRecordsList(Application.class, conditionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getAppCountByQuery(ApplicationQuery appQuery) {
        int count;
        this.checkParams(appQuery);
        try (Session session = null;){
            session = this.getHibernateTamplate().getSessionFactory().openSession();
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(Long.class);
            Root applicationRoot = cq.from(Application.class);
            Join serviceInstances = applicationRoot.join("serviceInstances", JoinType.LEFT);
            this.builcCriteria(appQuery, cb, cq, (Root<Application>)applicationRoot, (Join<Application, AppServiceInstance>)serviceInstances);
            cq.select((Selection)cb.countDistinct((Expression)applicationRoot));
            count = ((Long)session.createQuery(cq).getSingleResult()).intValue();
        }
        return count;
    }

    @Override
    public List<Application> getAllApplications() {
        return this.queryAllRecords(Application.class);
    }

    @Override
    public Integer getAppCountByName(ApplicationQuery query) {
        this.checkParams(query);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(Application.class, "name", query.getName());
        return this.getRecordsCount(Application.class, conditionManager).intValue();
    }

    @Override
    public List<Application> getAppListByRecoverPlanId(String projectId, String recoverPlanId) {
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(Application.class, "projectId", projectId);
        conditionManager.addNotNullQueryField(Application.class, "recoverPlanId", recoverPlanId);
        return this.queryRecordsList(Application.class, conditionManager);
    }

    @Override
    public Set<String> getPlanIdsBySiteName(String siteFieldName, String siteName) {
        SelectManager selectManager = new SelectManager(new SelectField(Application.class, "recoverPlanId"));
        selectManager.addSelectField(new SelectField(Application.class, "id"));
        JoinField appJoinServiceInst = new JoinField(Application.class, AppServiceInstance.class, new JoinField.Pair("id", "application"));
        JoinManager joinManager = new JoinManager();
        joinManager.addJoinField(appJoinServiceInst);
        ConditionManager conditionManager = new ConditionManager();
        String siteNameWithWildcard = ConverterUtil.convertString((String)siteName, (boolean)true);
        conditionManager.addQueryField(AppServiceInstance.class, siteFieldName, siteNameWithWildcard, SqlSentence.LIKE.getValue());
        conditionManager.addQueryField(Application.class, "recoverPlanId", "null", SqlSentence.NOT_EQUAL.getValue());
        return Optional.ofNullable(this.queryRecordsList(selectManager, Application.class, conditionManager, joinManager)).orElse(Lists.newArrayList()).stream().map(objList -> String.valueOf(objList[0])).collect(Collectors.toSet());
    }

    @Override
    public List<Application> queryAppListInPreplan(String preplanId) {
        this.checkParams(preplanId);
        JoinManager joinManager = new JoinManager();
        JoinField flowJoinField = new JoinField(Application.class, RecoverFlow.class, new JoinField.Pair("id", "appId"));
        JoinField stageFlowMapJoinField = new JoinField(RecoverFlow.class, StageFlowMap.class, new JoinField.Pair("id", "flowId"));
        JoinField stageJoinField = new JoinField(StageFlowMap.class, RecoverStage.class, new JoinField.Pair("stageId", "id"));
        JoinField prePlanJoinField = new JoinField(RecoverStage.class, RecoverPreplan.class, new JoinField.Pair("prePlanId", "id"));
        joinManager.addJoinField(flowJoinField);
        joinManager.addJoinField(stageFlowMapJoinField);
        joinManager.addJoinField(stageJoinField);
        joinManager.addJoinField(prePlanJoinField);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverPreplan.class, "id", preplanId);
        return this.queryRecordsList(Application.class, conditionManager, joinManager, Application.class);
    }

    private void builcCriteria(ApplicationQuery appQuery, CriteriaBuilder cb, CriteriaQuery cq, Root<Application> application, Join<Application, AppServiceInstance> serviceInstances) {
        Subquery subquery;
        ArrayList<Object> predicateList = new ArrayList<Object>();
        predicateList.add(cb.equal((Expression)application.get("projectId"), (Object)appQuery.getProjectId()));
        if (!VerifyUtil.isEmpty((String)appQuery.getName())) {
            String instanceName = ConverterUtil.convertString((String)appQuery.getName(), (boolean)true);
            predicateList.add(cb.like((Expression)application.get("name"), instanceName));
        }
        if (!VerifyUtil.isEmpty((String)appQuery.getStatus())) {
            predicateList.add(cb.equal((Expression)application.get("status"), (Object)appQuery.getStatus()));
        }
        if (!VerifyUtil.isEmpty((String)appQuery.getSiteId())) {
            Predicate pdSiteIdPredicate = cb.equal((Expression)serviceInstances.get("pdSiteId"), (Object)appQuery.getSiteId());
            Predicate drSiteIdPredicate = cb.equal((Expression)serviceInstances.get("drSiteId"), (Object)appQuery.getSiteId());
            Predicate[] predicates = new Predicate[]{pdSiteIdPredicate, drSiteIdPredicate};
            predicateList.add(cb.or(predicates));
        }
        if (appQuery.getBelongPlan() != null) {
            if (appQuery.getBelongPlan().booleanValue()) {
                predicateList.add(cb.isNotNull((Expression)application.get("recoverPlanId")));
            } else {
                predicateList.add(cb.isNull((Expression)application.get("recoverPlanId")));
            }
        }
        if (!VerifyUtil.isEmpty((String)appQuery.getPlanId())) {
            predicateList.add(cb.equal((Expression)application.get("recoverPlanId"), (Object)appQuery.getPlanId()));
        }
        if (!VerifyUtil.isEmpty((String)appQuery.getDescription())) {
            predicateList.add(cb.equal((Expression)application.get("description"), (Object)appQuery.getDescription()));
        }
        if (!VerifyUtil.isEmpty((Object)appQuery.getSupportCreateFlow())) {
            subquery = cq.subquery(String.class);
            Root serviceInstanceRoot = subquery.from(AppServiceInstance.class);
            subquery.select((Expression)serviceInstanceRoot.get("application").get("id"));
            subquery.where((Expression)cb.isNotNull((Expression)serviceInstanceRoot.get("pdSiteId")));
            if (appQuery.getSupportCreateFlow().booleanValue()) {
                predicateList.add(cb.in((Expression)application.get("id")).value((Expression)subquery));
            } else {
                predicateList.add(cb.not((Expression)cb.in((Expression)application.get("id")).value((Expression)subquery)));
            }
        }
        if (!VerifyUtil.isEmpty((String)appQuery.getFlowId())) {
            subquery = cq.subquery(String.class);
            Root recoverFlow = subquery.from(RecoverFlow.class);
            subquery.select((Expression)recoverFlow.get("appId")).where((Expression)cb.equal((Expression)recoverFlow.get("id"), (Object)appQuery.getFlowId()));
            predicateList.add(cb.notEqual((Expression)application.get("id"), (Expression)subquery));
        }
        cq.where(predicateList.toArray(new Predicate[0]));
    }

    @Override
    public void changeStatusRunningToFailed() {
        List<Application> applications = this.queryRecordsList(Application.class, (ConditionManager)new ConditionManager().addQueryField(Application.class, "status", CommonUtil.getRecoverStatusIng(), SqlSentence.IN.getValue()));
        applications.forEach(application -> {
            if (CommonUtil.getRecoverStatusMap().containsKey(application.getStatus())) {
                this.updateRecord(Application.class, (UpdateManager)new UpdateManager().addQueryField(Application.class, "status", CommonUtil.getRecoverStatusMap().get(application.getStatus())), (ConditionManager)new ConditionManager().addQueryField(Application.class, "id", application.getId()));
            }
        });
    }

    @Override
    public int getAllAppCount() {
        ConditionManager condition = new ConditionManager();
        condition.addQueryField(Application.class, "id", "null", SqlSentence.NOT_EQUAL.getValue());
        return this.getRecordsCount(Application.class, condition).intValue();
    }

    @Override
    public Application getAppByName(String applicationName) {
        this.checkParams(applicationName);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(Application.class, "name", applicationName);
        return this.queryRecord(Application.class, conditionManager);
    }
}

