/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.dao.FlowStepMapDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.FlowStepMap;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import java.util.LinkedList;
import java.util.List;

public class FlowStepMapDaoImpl
extends BaseDao<FlowStepMap>
implements FlowStepMapDao {
    @Override
    public void addStepToFlow(FlowStepMap flowStepMap) {
        this.checkParams(flowStepMap);
        this.saveRecord(flowStepMap);
    }

    @Override
    public void removeStepFromFlow(String flowId, String stepId) {
        this.checkParams(flowId, stepId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(FlowStepMap.class, "recoverFlowId", flowId);
        conditionManager.addNotNullQueryField(FlowStepMap.class, "recoverStepId", stepId);
        this.deleteRecords(FlowStepMap.class, conditionManager);
    }

    @Override
    public List<FlowStepMap> queryFlowStepMapByStepId(String stepId) {
        this.checkParams(stepId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(FlowStepMap.class, "recoverStepId", stepId);
        return this.queryRecordsList(FlowStepMap.class, conditionManager);
    }

    @Override
    public List<FlowStepMap> queryFlowStepMapByFlowId(String flowId) {
        this.checkParams(flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(FlowStepMap.class, "recoverFlowId", flowId);
        return this.queryRecordsList(FlowStepMap.class, conditionManager);
    }

    @Override
    public long getStepMapCountByStepId(String stepId) {
        this.checkParams(stepId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(FlowStepMap.class, "recoverStepId", stepId);
        return this.getRecordsCount(FlowStepMap.class, conditionManager);
    }

    @Override
    public long getStepMapCountByFlowId(String flowId) {
        this.checkParams(flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(FlowStepMap.class, "recoverFlowId", flowId);
        return this.getRecordsCount(FlowStepMap.class, conditionManager);
    }

    @Override
    public long getStepMapCountByFlowIdAndSiteId(String flowId, String siteId) {
        this.checkParams(flowId, siteId);
        StringBuilder hql = new StringBuilder();
        hql.append("select count(distinct a) from ").append(FlowStepMap.class.getSimpleName()).append(" a ");
        hql.append("join ").append(RecoverStep.class.getSimpleName()).append(" b ").append("on a.recoverStepId = b.id ");
        hql.append("join ").append(AppServiceInstance.class.getSimpleName()).append(" c ").append("on b.serviceInstanceId = c.id ");
        hql.append("where a.recoverFlowId =? and (c.pdSiteId =? or c.drSiteId =?)");
        LinkedList<Object> parameters = new LinkedList<Object>();
        parameters.add(flowId);
        parameters.add(siteId);
        parameters.add(siteId);
        return this.getRecordsCount(parameters, hql.toString());
    }

    @Override
    public long getStepMapCount(String flowId, String stepId) {
        this.checkParams(flowId, stepId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(FlowStepMap.class, "recoverFlowId", flowId);
        conditionManager.addNotNullQueryField(FlowStepMap.class, "recoverStepId", stepId);
        return this.getRecordsCount(FlowStepMap.class, conditionManager);
    }

    @Override
    public void deleteAllByStepId(String stepId) {
        this.checkParams(stepId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(FlowStepMap.class, "recoverStepId", stepId);
        this.deleteRecords(FlowStepMap.class, conditionManager);
    }
}

