/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.model.InstanceObjectQuery;
import com.huawei.csr.framework.dao.InstanceObjectDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.InstanceObject;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.OrderManager;
import java.util.Collection;
import java.util.List;

public class InstanceObjectDaoImpl
extends BaseDao<InstanceObject>
implements InstanceObjectDao {
    @Override
    public void removeInstanceObjectByServiceInstanceId(String serviceInstanceId) {
        ConditionManager conditionManager = new ConditionManager();
        AppServiceInstance serviceInstance = new AppServiceInstance();
        serviceInstance.setId(serviceInstanceId);
        conditionManager.addNotNullQueryField(InstanceObject.class, "serviceInstance", serviceInstance);
        this.deleteRecords(InstanceObject.class, conditionManager);
    }

    @Override
    public List<InstanceObject> queryInstanceObjects(InstanceObjectQuery instanceObjectQuery) {
        ConditionManager conditionManager = this.buildCondition(instanceObjectQuery);
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(InstanceObject.class, "createdAt", false);
        return this.queryRecordsList(InstanceObject.class, conditionManager, orderManager);
    }

    @Override
    public Long getInstanceObjectsCount(InstanceObjectQuery instanceObjectQuery) {
        ConditionManager conditionManager = this.buildCondition(instanceObjectQuery);
        return this.getRecordsCount(InstanceObject.class, conditionManager);
    }

    @Override
    public void removeInstanceObject(InstanceObject instanceObject) {
        this.checkParams(instanceObject);
        this.deleteRecord(instanceObject);
    }

    @Override
    public void updateInstanceObject(InstanceObject instanceObject) {
        this.checkParams(instanceObject);
        this.updateRecord(instanceObject);
    }

    private ConditionManager buildCondition(InstanceObjectQuery instanceObjectQuery) {
        this.checkParams(instanceObjectQuery);
        ConditionManager conditionManager = new ConditionManager(instanceObjectQuery);
        conditionManager.addQueryField(InstanceObject.class, "projectId", instanceObjectQuery.getProjectId());
        AppServiceInstance serviceInstance = new AppServiceInstance();
        serviceInstance.setId(instanceObjectQuery.getInstanceId());
        conditionManager.addQueryField(InstanceObject.class, "serviceInstance", serviceInstance);
        return conditionManager;
    }

    @Override
    public void saveInstanceObjects(Collection<InstanceObject> instanceObjects) {
        this.saveRecords(instanceObjects);
    }
}

