/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.dao.RecoverFlowChainDao;
import com.huawei.csr.framework.dao.model.RecoverFlowChain;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import java.util.List;

public class RecoverFlowChainDaoImpl
extends BaseDao<RecoverFlowChain>
implements RecoverFlowChainDao {
    @Override
    public void save(RecoverFlowChain recoverFlowChain) {
        this.checkParams(recoverFlowChain);
        this.saveRecord(recoverFlowChain);
    }

    @Override
    public void delete(RecoverFlowChain recoverFlowChain) {
        this.checkParams(recoverFlowChain);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "stageId", recoverFlowChain.getStageId());
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "preFlowId", recoverFlowChain.getPreFlowId());
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "nextFlowId", recoverFlowChain.getNextFlowId());
        this.deleteRecords(RecoverFlowChain.class, conditionManager);
    }

    @Override
    public void batchDeleteByStageId(String stageId) {
        this.checkParams(stageId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "stageId", stageId);
        this.deleteRecords(RecoverFlowChain.class, conditionManager);
    }

    @Override
    public void batchDeleteByFlowId(String flowId) {
        this.checkParams(flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "preFlowId", flowId);
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "nextFlowId", flowId);
        conditionManager.setQueryType(SqlSentence.OR.getValue());
        this.deleteRecords(RecoverFlowChain.class, conditionManager);
    }

    @Override
    public void update(RecoverFlowChain recoverFlowChain) {
        this.checkParams(recoverFlowChain);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "stageId", recoverFlowChain.getStageId());
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "preFlowId", recoverFlowChain.getPreFlowId());
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "nextFlowId", recoverFlowChain.getNextFlowId());
        UpdateManager updateManager = new UpdateManager();
        updateManager.addNotNullQueryField(RecoverFlowChain.class, "stageId", recoverFlowChain.getStageId());
        updateManager.addNotNullQueryField(RecoverFlowChain.class, "preFlowId", recoverFlowChain.getPreFlowId());
        updateManager.addNotNullQueryField(RecoverFlowChain.class, "nextFlowId", recoverFlowChain.getNextFlowId());
        this.updateRecord(RecoverFlowChain.class, updateManager, conditionManager);
    }

    @Override
    public RecoverFlowChain queryFlowChain(RecoverFlowChain recoverFlowChain) {
        this.checkParams(recoverFlowChain);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "stageId", recoverFlowChain.getStageId());
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "preFlowId", recoverFlowChain.getPreFlowId());
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "nextFlowId", recoverFlowChain.getNextFlowId());
        return this.queryRecord(RecoverFlowChain.class, conditionManager);
    }

    @Override
    public List<RecoverFlowChain> getPreFlowChainList(String stageId, String nextFlowId) {
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverFlowChain.class, "stageId", stageId);
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "nextFlowId", nextFlowId);
        return this.queryRecordsList(RecoverFlowChain.class, conditionManager);
    }

    @Override
    public List<RecoverFlowChain> getNextFlowChainList(String stageId, String preFlowId) {
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "stageId", stageId);
        conditionManager.addNotNullQueryField(RecoverFlowChain.class, "preFlowId", preFlowId);
        return this.queryRecordsList(RecoverFlowChain.class, conditionManager);
    }

    @Override
    public long getFlowChainCountByFlowId(String flowId) {
        this.checkParams(flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverFlowChain.class, "preFlowId", flowId);
        conditionManager.addQueryField(RecoverFlowChain.class, "nextFlowId", flowId);
        conditionManager.setQueryType(SqlSentence.OR.getValue());
        return this.getRecordsCount(RecoverFlowChain.class, conditionManager).intValue();
    }
}

