/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.model.RecoverFlowQuery;
import com.huawei.csr.framework.common.utils.CommonUtil;
import com.huawei.csr.framework.dao.RecoverFlowDao;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.JoinField;
import com.huawei.csr.framework.dao.support.JoinManager;
import com.huawei.csr.framework.dao.support.OrderManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;

public class RecoverFlowDaoImpl
extends BaseDao<RecoverFlow>
implements RecoverFlowDao {
    @Override
    public RecoverFlow getRecoverFlowById(String flowId) {
        this.checkParams(flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverFlow.class, "id", flowId);
        return this.queryRecord(RecoverFlow.class, conditionManager);
    }

    @Override
    public List<RecoverFlow> queryRecoverFlows(RecoverFlowQuery recoverFlowQuery) {
        ConditionManager conditionManager = new ConditionManager(recoverFlowQuery);
        JoinManager joinManager = new JoinManager();
        this.buildConditionManagerAndJoinManager(recoverFlowQuery, conditionManager, joinManager);
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(RecoverFlow.class, "createdAt", false);
        if (VerifyUtil.isEmpty(joinManager.getJoinFields())) {
            return this.queryRecordsList(RecoverFlow.class, conditionManager, orderManager);
        }
        return this.queryRecordsList(RecoverFlow.class, conditionManager, orderManager, joinManager, RecoverFlow.class);
    }

    @Override
    public int queryRecoverFlowsCount(RecoverFlowQuery recoverFlowQuery) {
        this.checkParams(recoverFlowQuery);
        ConditionManager conditionManager = new ConditionManager(recoverFlowQuery);
        JoinManager joinManager = new JoinManager();
        this.buildConditionManagerAndJoinManager(recoverFlowQuery, conditionManager, joinManager);
        return this.getRecordsCount(RecoverFlow.class, conditionManager, joinManager).intValue();
    }

    @Override
    public long getAllRecoverFlowCount() {
        return this.queryAllRecords(RecoverFlow.class).size();
    }

    @Override
    public void save(RecoverFlow recoverFlow) {
        this.checkParams(recoverFlow);
        this.saveRecord(recoverFlow);
    }

    @Override
    public void delete(String projectId, String flowId) {
        this.checkParams(flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverFlow.class, "id", flowId);
        conditionManager.addNotNullQueryField(RecoverFlow.class, "projectId", projectId);
        this.deleteRecords(RecoverFlow.class, conditionManager);
    }

    @Override
    public void update(RecoverFlow recoverFlow) {
        this.checkParams(recoverFlow.getId());
        UpdateManager updateManager = new UpdateManager();
        updateManager.addNotNullQueryField(RecoverFlow.class, "name", recoverFlow.getName());
        updateManager.addNotNullQueryField(RecoverFlow.class, "appId", recoverFlow.getAppId());
        updateManager.addNotNullQueryField(RecoverFlow.class, "type", recoverFlow.getType());
        updateManager.addNotNullQueryField(RecoverFlow.class, "status", recoverFlow.getStatus());
        updateManager.addNotNullQueryField(RecoverFlow.class, "lastExecuteTime", recoverFlow.getLastExecuteTime());
        updateManager.addNotNullQueryField(RecoverFlow.class, "lastExecuteDuration", recoverFlow.getLastExecuteDuration());
        updateManager.addNotNullQueryField(RecoverFlow.class, "averageExecuteDuration", recoverFlow.getAverageExecuteDuration());
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverFlow.class, "id", recoverFlow.getId());
        conditionManager.addNotNullQueryField(RecoverFlow.class, "projectId", recoverFlow.getProjectId());
        this.updateRecord(RecoverFlow.class, updateManager, conditionManager);
    }

    @Override
    public List<RecoverFlow> queryRecoverFlowsByAppId(String projectId, String applicationId) {
        this.checkParams(projectId, applicationId);
        ConditionManager condition = new ConditionManager();
        condition.addQueryField(RecoverFlow.class, "projectId", projectId);
        condition.addQueryField(RecoverFlow.class, "appId", applicationId);
        return this.queryRecordsList(RecoverFlow.class, condition);
    }

    private void buildConditionManagerAndJoinManager(RecoverFlowQuery recoverFlowQuery, ConditionManager conditionManager, JoinManager joinManager) {
        JoinField joinField;
        conditionManager.addNotNullQueryField(RecoverFlow.class, "appId", recoverFlowQuery.getAppId());
        conditionManager.addNotNullQueryField(RecoverFlow.class, "name", recoverFlowQuery.getFullFlowName());
        conditionManager.addNotNullQueryField(RecoverFlow.class, "projectId", recoverFlowQuery.getProjectId());
        conditionManager.addNotNullQueryField(RecoverFlow.class, "type", recoverFlowQuery.getType());
        if (!VerifyUtil.isEmpty((String)recoverFlowQuery.getStatus())) {
            conditionManager.addNotNullQueryField(RecoverFlow.class, "status", recoverFlowQuery.getStatus());
        }
        if (!VerifyUtil.isEmpty((String)recoverFlowQuery.getFlowName())) {
            String flowNameWithWildcard = ConverterUtil.convertString((String)recoverFlowQuery.getFlowName(), (boolean)true);
            conditionManager.addQueryField(RecoverFlow.class, "name", flowNameWithWildcard, SqlSentence.LIKE.getValue());
        }
        if (!VerifyUtil.isEmpty((String)recoverFlowQuery.getStageId())) {
            joinField = new JoinField(RecoverFlow.class, StageFlowMap.class, new JoinField.Pair("id", "flowId"));
            joinManager.addJoinField(joinField);
            conditionManager.addNotNullQueryField(StageFlowMap.class, "stageId", recoverFlowQuery.getStageId());
        }
        if (!VerifyUtil.isEmpty((String)recoverFlowQuery.getAppName())) {
            joinField = new JoinField(RecoverFlow.class, Application.class, new JoinField.Pair("appId", "id"));
            joinManager.addJoinField(joinField);
            String appNameWithWildcard = ConverterUtil.convertString((String)recoverFlowQuery.getAppName(), (boolean)true);
            conditionManager.addQueryField(Application.class, "name", appNameWithWildcard, SqlSentence.LIKE.getValue());
        }
        if (!VerifyUtil.isEmpty((String)recoverFlowQuery.getFlowPrePlanName()) || !VerifyUtil.isEmpty((String)recoverFlowQuery.getPrePlanId())) {
            JoinField flowJoinField = new JoinField(RecoverFlow.class, StageFlowMap.class, new JoinField.Pair("id", "flowId"));
            JoinField stageFlowMapJoinField = new JoinField(StageFlowMap.class, RecoverStage.class, new JoinField.Pair("stageId", "id"));
            JoinField prePlanJoinField = new JoinField(RecoverStage.class, RecoverPreplan.class, new JoinField.Pair("prePlanId", "id"));
            joinManager.addJoinField(flowJoinField);
            joinManager.addJoinField(stageFlowMapJoinField);
            joinManager.addJoinField(prePlanJoinField);
            if (!VerifyUtil.isEmpty((String)recoverFlowQuery.getFlowPrePlanName())) {
                String preplanNameWildcard = ConverterUtil.convertString((String)recoverFlowQuery.getFlowPrePlanName(), (boolean)true);
                conditionManager.addQueryField(RecoverPreplan.class, "name", preplanNameWildcard, SqlSentence.LIKE.getValue());
            }
            if (!VerifyUtil.isEmpty((String)recoverFlowQuery.getPrePlanId())) {
                conditionManager.addQueryField(RecoverPreplan.class, "id", recoverFlowQuery.getPrePlanId());
            }
        }
    }

    @Override
    public void changeStatusRunningToFailed() {
        List<RecoverFlow> recoverFlows = this.queryRecordsList(RecoverFlow.class, (ConditionManager)new ConditionManager().addQueryField(RecoverFlow.class, "status", CommonUtil.getRecoverStatusIng(), SqlSentence.IN.getValue()));
        recoverFlows.forEach(recoverFlow -> {
            if (CommonUtil.getRecoverStatusMap().containsKey(recoverFlow.getStatus())) {
                this.updateRecord(RecoverFlow.class, (UpdateManager)new UpdateManager().addQueryField(RecoverFlow.class, "status", CommonUtil.getRecoverStatusMap().get(recoverFlow.getStatus())), (ConditionManager)new ConditionManager().addQueryField(RecoverFlow.class, "id", recoverFlow.getId()));
            }
        });
    }
}

