/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.model.RecoverLogQuery;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.dao.RecoverLogDao;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.OrderManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RecoverLogDaoImpl
extends BaseDao<RecoverLog>
implements RecoverLogDao {
    @Override
    public void save(RecoverLog log) {
        this.checkParams(log);
        this.saveRecord(log);
    }

    @Override
    public void update(RecoverLog log) {
        this.checkParams(log);
        UpdateManager updateManager = new UpdateManager();
        updateManager.addNotNullQueryField(RecoverLog.class, "projectId", log.getProjectId());
        updateManager.addNotNullQueryField(RecoverLog.class, "resourceId", log.getResourceId());
        updateManager.addNotNullQueryField(RecoverLog.class, "resourceName", log.getResourceName());
        updateManager.addNotNullQueryField(RecoverLog.class, "parentId", log.getParentId());
        updateManager.addNotNullQueryField(RecoverLog.class, "process", log.getProcess());
        updateManager.addNotNullQueryField(RecoverLog.class, "resourceType", log.getResourceType());
        updateManager.addNotNullQueryField(RecoverLog.class, "startTime", log.getStartTime());
        updateManager.addNotNullQueryField(RecoverLog.class, "status", log.getStatus());
        updateManager.addNotNullQueryField(RecoverLog.class, "endTime", log.getEndTime());
        updateManager.addQueryField(RecoverLog.class, "errorCode", log.getErrorCode());
        updateManager.addNotNullQueryField(RecoverLog.class, "operationType", log.getOperationType());
        updateManager.addNotNullQueryField(RecoverLog.class, "errorMsg", log.getErrorMsg());
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverLog.class, "id", log.getId());
        conditionManager.addNotNullQueryField(RecoverLog.class, "projectId", log.getProjectId());
        this.updateRecord(RecoverLog.class, updateManager, conditionManager);
    }

    @Override
    public List<RecoverLog> queryRecoverLogs(RecoverLogQuery recoverLogQuery) {
        this.checkParams(recoverLogQuery);
        ConditionManager conditionManager = new ConditionManager(recoverLogQuery);
        this.buildConditionManager(recoverLogQuery, conditionManager);
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(RecoverLog.class, "startTime", recoverLogQuery.isStartTimeAsc());
        return this.queryRecordsList(RecoverLog.class, conditionManager, orderManager);
    }

    private void buildConditionManager(RecoverLogQuery recoverLogQuery, ConditionManager conditionManager) {
        conditionManager.addNotNullQueryField(RecoverLog.class, "projectId", recoverLogQuery.getProjectId());
        conditionManager.addNotNullQueryField(RecoverLog.class, "resourceType", recoverLogQuery.getResourceType());
        conditionManager.addNotNullQueryField(RecoverLog.class, "operationType", recoverLogQuery.getOperateType());
        conditionManager.addNotNullQueryField(RecoverLog.class, "siteId", recoverLogQuery.getSiteId());
        if (!VerifyUtil.isEmpty((String)recoverLogQuery.getResourceName())) {
            String resourceNameWithWildcard = ConverterUtil.convertString((String)recoverLogQuery.getResourceName(), (boolean)true);
            conditionManager.addQueryField(RecoverLog.class, "resourceName", resourceNameWithWildcard, SqlSentence.LIKE.getValue());
        }
        if (!VerifyUtil.isEmpty(recoverLogQuery.getStatus())) {
            conditionManager.addQueryField(RecoverLog.class, "status", recoverLogQuery.getStatus(), SqlSentence.IN.getValue());
        }
        if (!VerifyUtil.isEmpty(recoverLogQuery.getIds())) {
            conditionManager.addQueryField(RecoverLog.class, "id", recoverLogQuery.getIds(), SqlSentence.IN.getValue());
        }
        if (!VerifyUtil.isEmpty(recoverLogQuery.getResourceIds())) {
            conditionManager.addQueryField(RecoverLog.class, "resourceId", recoverLogQuery.getResourceIds(), SqlSentence.IN.getValue());
        }
        if (!VerifyUtil.isEmpty(recoverLogQuery.getParentIds())) {
            conditionManager.addQueryField(RecoverLog.class, "parentId", recoverLogQuery.getParentIds(), SqlSentence.IN.getValue());
        }
    }

    @Override
    public long getRecoverLogCount(RecoverLogQuery recoverLogQuery) {
        this.checkParams(recoverLogQuery);
        ConditionManager conditionManager = new ConditionManager();
        this.buildConditionManager(recoverLogQuery, conditionManager);
        return this.getRecordsCount(RecoverLog.class, conditionManager);
    }

    @Override
    public void deleteRevocerLogByResourceId(String projectId, String resourceId) {
        this.checkParams(projectId, resourceId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverLog.class, "projectId", projectId);
        conditionManager.addNotNullQueryField(RecoverLog.class, "resourceId", resourceId);
        this.deleteRecords(RecoverLog.class, conditionManager);
    }

    @Override
    public void deleteRevocerLogByParentId(String projectId, String parentId) {
        this.checkParams(projectId, parentId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverLog.class, "projectId", projectId);
        conditionManager.addNotNullQueryField(RecoverLog.class, "parentId", parentId);
        this.deleteRecords(RecoverLog.class, conditionManager);
    }

    @Override
    public RecoverLog getRecoverLogById(String logId) {
        this.checkParams(logId);
        this.getHibernateTemplate().clear();
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverLog.class, "id", logId);
        return this.queryRecord(RecoverLog.class, conditionManager);
    }

    @Override
    public void changeStatusRunningToFailed() {
        ArrayList<String> logStatusIng = new ArrayList<String>(Arrays.asList(RecoverLogStatus.RUNNING.getValue(), RecoverLogStatus.WAITING.getValue()));
        this.updateRecord(RecoverLog.class, (UpdateManager)new UpdateManager().addQueryField(RecoverLog.class, "status", RecoverLogStatus.FAILED.getValue()), (ConditionManager)new ConditionManager().addQueryField(RecoverLog.class, "status", logStatusIng, SqlSentence.IN.getValue()));
    }
}

