/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.model.RecoverPlanQuery;
import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.utils.CommonUtil;
import com.huawei.csr.framework.dao.RecoverPlanDao;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.FlowStepMap;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.SitePlanMap;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.JoinField;
import com.huawei.csr.framework.dao.support.JoinManager;
import com.huawei.csr.framework.dao.support.OrderManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class RecoverPlanDaoImpl
extends BaseDao<RecoverPlan>
implements RecoverPlanDao {
    @Override
    public RecoverPlan getRecoverPlanById(String id) {
        this.checkParams(id);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverPlan.class, "id", id);
        return this.queryRecord(RecoverPlan.class, conditionManager);
    }

    @Override
    public void savePlan(RecoverPlan plan) {
        this.checkParams(plan);
        this.saveRecord(plan);
    }

    @Override
    public void deletePlan(String projectId, String planId) {
        this.checkParams(planId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverPlan.class, "id", planId);
        conditionManager.addNotNullQueryField(RecoverPlan.class, "projectId", projectId);
        this.deleteRecords(RecoverPlan.class, conditionManager);
    }

    @Override
    public void updatePlanBasicInfo(RecoverPlan plan) {
        this.checkParams(plan);
        UpdateManager updateManager = new UpdateManager();
        updateManager.addQueryField(RecoverPlan.class, "name", plan.getName());
        updateManager.addQueryField(RecoverPlan.class, "description", plan.getDescription());
        updateManager.addNotNullQueryField(RecoverPlan.class, "status", plan.getStatus());
        updateManager.addNotNullQueryField(RecoverPlan.class, "lastExecuteTime", plan.getLastExecuteTime());
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverPlan.class, "id", plan.getId());
        conditionManager.addNotNullQueryField(RecoverPlan.class, "projectId", plan.getProjectId());
        this.updateRecord(RecoverPlan.class, updateManager, conditionManager);
    }

    @Override
    public List<RecoverPlan> queryPlans(RecoverPlanQuery recoverPlanQuery, Set<String> planIdsQueryBySiteNameSet) {
        this.checkParams(recoverPlanQuery);
        JoinManager joinManager = new JoinManager();
        ConditionManager conditionManager = new ConditionManager(recoverPlanQuery);
        this.buildConditionManagerAndJoinManager(recoverPlanQuery, conditionManager, joinManager, planIdsQueryBySiteNameSet);
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(RecoverPlan.class, "createdAt", false);
        if (VerifyUtil.isEmpty(joinManager.getJoinFields())) {
            return this.queryRecordsList(RecoverPlan.class, conditionManager, orderManager);
        }
        return this.queryRecordsList(RecoverPlan.class, conditionManager, orderManager, joinManager, RecoverPlan.class);
    }

    @Override
    public Optional<RecoverPlan> queryPlan(String projectId, String planId, String applicationId) {
        this.checkParams(projectId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverPlan.class, "projectId", projectId);
        if (VerifyUtil.isEmpty((String)applicationId)) {
            conditionManager.addQueryField(RecoverPlan.class, "id", planId);
            return Optional.ofNullable(this.queryRecord(RecoverPlan.class, conditionManager));
        }
        JoinManager joinManager = new JoinManager(new JoinField(RecoverPlan.class, Application.class, new JoinField.Pair("id", "recoverPlanId")));
        conditionManager.addQueryField(Application.class, "id", applicationId);
        List<RecoverPlan> resultList = this.queryRecordsList(RecoverPlan.class, conditionManager, null, null, joinManager, RecoverPlan.class);
        if (CollectionUtils.isEmpty(resultList)) {
            return Optional.empty();
        }
        return Optional.of(resultList.get(0));
    }

    @Override
    public int getRecoverPlanCountByRecoverPlanQuery(RecoverPlanQuery recoverPlanQuery, Set<String> planIdsQueryBySiteName) {
        this.checkParams(recoverPlanQuery);
        JoinManager joinManager = new JoinManager();
        ConditionManager conditionManager = new ConditionManager();
        this.buildConditionManagerAndJoinManager(recoverPlanQuery, conditionManager, joinManager, planIdsQueryBySiteName);
        return Optional.ofNullable(this.getRecordsCount(RecoverPlan.class, conditionManager, joinManager)).orElse(0L).intValue();
    }

    @Override
    public int getAllRecoverPlanCount() {
        ConditionManager condition = new ConditionManager();
        condition.addQueryField(RecoverPlan.class, "id", "null", SqlSentence.NOT_EQUAL.getValue());
        return this.getRecordsCount(RecoverPlan.class, condition).intValue();
    }

    @Override
    public void save(RecoverPlan recoverPlan) {
        this.checkParams(recoverPlan);
        this.saveRecord(recoverPlan);
    }

    @Override
    public List<RecoverPlan> getRecoverPlanOfStepStatus(RecoverStepQuery recoverStepQuery) {
        JoinManager joinManager = new JoinManager();
        JoinField recoverPlan2PrePlan = new JoinField(RecoverPlan.class, RecoverPreplan.class, new JoinField.Pair("id", "recoverPlanId"));
        JoinField prePlan2Stage = new JoinField(RecoverPreplan.class, RecoverStage.class, new JoinField.Pair("id", "prePlanId"));
        JoinField stage2StageFlowMap = new JoinField(RecoverStage.class, StageFlowMap.class, new JoinField.Pair("id", "stageId"));
        JoinField stageFlowMap2FlowStepMap = new JoinField(StageFlowMap.class, FlowStepMap.class, new JoinField.Pair("flowId", "recoverFlowId"));
        JoinField flowStepMap2Step = new JoinField(FlowStepMap.class, RecoverStep.class, new JoinField.Pair("recoverStepId", "id"));
        joinManager.addJoinField(recoverPlan2PrePlan);
        joinManager.addJoinField(prePlan2Stage);
        joinManager.addJoinField(stage2StageFlowMap);
        joinManager.addJoinField(stageFlowMap2FlowStepMap);
        joinManager.addJoinField(flowStepMap2Step);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverStep.class, "id", recoverStepQuery.getStepId());
        conditionManager.addNotNullQueryField(RecoverStep.class, "projectId", recoverStepQuery.getProjectId());
        conditionManager.addNotNullQueryField(RecoverPlan.class, "projectId", recoverStepQuery.getProjectId());
        return this.queryRecordsList(RecoverPlan.class, conditionManager, null, null, joinManager, RecoverPlan.class);
    }

    @Override
    public void changeStatusRunningToFailed() {
        List<RecoverPlan> recoverPlans = this.queryRecordsList(RecoverPlan.class, (ConditionManager)new ConditionManager().addQueryField(RecoverPlan.class, "status", CommonUtil.getRecoverStatusIng(), SqlSentence.IN.getValue()));
        recoverPlans.forEach(recoverPlan -> {
            if (CommonUtil.getRecoverStatusMap().containsKey(recoverPlan.getStatus())) {
                this.updateRecord(RecoverPlan.class, (UpdateManager)new UpdateManager().addQueryField(RecoverPlan.class, "status", CommonUtil.getRecoverStatusMap().get(recoverPlan.getStatus())), (ConditionManager)new ConditionManager().addQueryField(RecoverPlan.class, "id", recoverPlan.getId()));
            }
        });
    }

    @Override
    public Optional<RecoverPlan> getRecoverPlanByName(String planName) {
        this.checkParams(planName);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverPlan.class, "name", planName);
        return Optional.ofNullable(this.queryRecord(RecoverPlan.class, conditionManager));
    }

    private void buildConditionManagerAndJoinManager(RecoverPlanQuery recoverPlanQuery, ConditionManager conditionManager, JoinManager joinManager, Set<String> planIdsQueryBySiteName) {
        conditionManager.addNotNullQueryField(RecoverPlan.class, "projectId", recoverPlanQuery.getProjectId());
        conditionManager.addNotNullQueryField(RecoverPlan.class, "status", recoverPlanQuery.getStatus());
        if (!VerifyUtil.isEmpty((String)recoverPlanQuery.getPlanName())) {
            String planNameWithWildcard = ConverterUtil.convertString((String)recoverPlanQuery.getPlanName(), (boolean)true);
            conditionManager.addQueryField(RecoverPlan.class, "name", planNameWithWildcard, SqlSentence.LIKE.getValue());
        }
        if (!VerifyUtil.isEmpty((String)recoverPlanQuery.getSitePlanId())) {
            JoinField planJoinSitePlanMap = new JoinField(RecoverPlan.class, SitePlanMap.class, new JoinField.Pair("id", "recoverPlanId"));
            joinManager.addJoinField(planJoinSitePlanMap);
            conditionManager.addQueryField(SitePlanMap.class, "sitePlanId", recoverPlanQuery.getSitePlanId());
        }
        if (!VerifyUtil.isEmpty(planIdsQueryBySiteName)) {
            conditionManager.addQueryField(RecoverPlan.class, "id", planIdsQueryBySiteName, SqlSentence.IN.getValue());
        }
    }
}

