/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.utils.CommonUtil;
import com.huawei.csr.framework.dao.RecoverPreplanDao;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.JoinField;
import com.huawei.csr.framework.dao.support.JoinManager;
import com.huawei.csr.framework.dao.support.OrderManager;
import com.huawei.csr.framework.dao.support.SelectField;
import com.huawei.csr.framework.dao.support.SelectManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class RecoverPreplanDaoImpl
extends BaseDao<RecoverPreplan>
implements RecoverPreplanDao {
    private static final Log LOGGER = LogFactory.getInstance(RecoverPreplanDaoImpl.class);

    @Override
    public void save(RecoverPreplan preplan) {
        this.checkParams(preplan);
        this.saveRecord(preplan);
    }

    @Override
    public void update(RecoverPreplan preplan) {
        this.checkParams(preplan.getId());
        UpdateManager updateManager = new UpdateManager();
        updateManager.addNotNullQueryField(RecoverPreplan.class, "name", preplan.getName());
        updateManager.addQueryField(RecoverPreplan.class, "description", preplan.getDescription());
        updateManager.addNotNullQueryField(RecoverPreplan.class, "expectRTO", preplan.getExpectRTO());
        updateManager.addNotNullQueryField(RecoverPreplan.class, "status", preplan.getStatus());
        updateManager.addNotNullQueryField(RecoverPreplan.class, "lastExecuteTime", preplan.getLastExecuteTime());
        updateManager.addNotNullQueryField(RecoverPreplan.class, "lastExecuteDuration", preplan.getLastExecuteDuration());
        updateManager.addNotNullQueryField(RecoverPreplan.class, "averageExecuteDuration", preplan.getAverageExecuteDuration());
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverPreplan.class, "id", preplan.getId());
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "projectId", preplan.getProjectId());
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "recoverPlanId", preplan.getRecoverPlanId());
        this.updateRecord(RecoverPreplan.class, updateManager, conditionManager);
    }

    @Override
    public void delete(String projectId, String preplanId) {
        this.checkParams(preplanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverPreplan.class, "id", preplanId);
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "projectId", projectId);
        this.deleteRecords(RecoverPreplan.class, conditionManager);
    }

    @Override
    public Optional<RecoverPreplan> queryPreplanById(String preplanId) {
        this.checkParams(preplanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverPreplan.class, "id", preplanId);
        return Optional.ofNullable(this.queryRecord(RecoverPreplan.class, conditionManager));
    }

    @Override
    public Optional<RecoverPreplan> queryPreplanByStageId(String stageId) {
        this.checkParams(stageId);
        JoinManager joinManager = new JoinManager();
        JoinField joinField = new JoinField(RecoverPreplan.class, RecoverStage.class);
        joinField.addPair(new JoinField.Pair("id", "prePlanId"));
        joinManager.addJoinField(joinField);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverStage.class, "id", stageId);
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(RecoverPreplan.class, "createdAt", false);
        List<RecoverPreplan> preplanList = this.queryRecordsList(RecoverPreplan.class, conditionManager, orderManager, null, joinManager, RecoverPreplan.class);
        if (CollectionUtils.isEmpty(preplanList)) {
            LOGGER.debug((Object)"Query preplan by stageId empty,stageId is '%s'.", new Object[]{stageId});
            return Optional.empty();
        }
        return Optional.of(preplanList.get(0));
    }

    @Override
    public List<RecoverPreplan> queryPreplansListByFlowId(String flowId) {
        this.checkParams(flowId);
        JoinManager joinManager = new JoinManager();
        JoinField stageJoinField = new JoinField(RecoverPreplan.class, RecoverStage.class, new JoinField.Pair("id", "prePlanId"));
        JoinField stageFlowMapJoinField = new JoinField(RecoverStage.class, StageFlowMap.class, new JoinField.Pair("id", "stageId"));
        JoinField flowJoinField = new JoinField(StageFlowMap.class, RecoverFlow.class, new JoinField.Pair("flowId", "id"));
        joinManager.addJoinField(stageJoinField);
        joinManager.addJoinField(stageFlowMapJoinField);
        joinManager.addJoinField(flowJoinField);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverFlow.class, "id", flowId);
        return this.queryRecordsList(RecoverPreplan.class, conditionManager, joinManager, RecoverPreplan.class);
    }

    @Override
    public List<RecoverPreplan> queryPreplanListByRecoverPlanId(String recoverPlanId) {
        this.checkParams(recoverPlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "recoverPlanId", recoverPlanId);
        return this.queryRecordsList(RecoverPreplan.class, conditionManager);
    }

    @Override
    public long getPrePlanCountByRecoverPlanId(String recoverPlanId) {
        this.checkParams(recoverPlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "recoverPlanId", recoverPlanId);
        return this.getRecordsCount(RecoverPreplan.class, conditionManager);
    }

    @Override
    public long getPrePlanCountByRecoverPlanIdSet(Set<String> recoverPlanIdSet) {
        this.checkParams(recoverPlanIdSet);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "recoverPlanId", recoverPlanIdSet, SqlSentence.IN.getValue());
        return this.getRecordsCount(RecoverPreplan.class, conditionManager);
    }

    @Override
    public List<RecoverPreplan> queryPreplans(RecoverPreplanQuery recoverPreplanQuery) {
        ConditionManager conditionManager = new ConditionManager(recoverPreplanQuery);
        this.buildConditionManager(recoverPreplanQuery, conditionManager);
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(RecoverPreplan.class, "createdAt", false);
        return this.queryRecordsList(RecoverPreplan.class, conditionManager, orderManager);
    }

    @Override
    public int queryPreplansCount(RecoverPreplanQuery recoverPreplanQuery) {
        ConditionManager conditionManager = new ConditionManager(recoverPreplanQuery);
        this.buildConditionManager(recoverPreplanQuery, conditionManager);
        return this.getRecordsCount(RecoverPreplan.class, conditionManager).intValue();
    }

    @Override
    public long getAllRecoverPreplanCount() {
        return this.queryAllRecords(RecoverPreplan.class).size();
    }

    @Override
    public boolean isApplicationProtectedByPreplan(String applicationId, String preplanId) {
        this.checkParams(applicationId, preplanId);
        JoinManager joinManager = new JoinManager();
        JoinField prePlanJoinField = new JoinField(RecoverPreplan.class, RecoverStage.class, new JoinField.Pair("id", "prePlanId"));
        JoinField stageFlowMapJoinField = new JoinField(RecoverStage.class, StageFlowMap.class, new JoinField.Pair("id", "stageId"));
        JoinField flowJoinField = new JoinField(StageFlowMap.class, RecoverFlow.class, new JoinField.Pair("flowId", "id"));
        joinManager.addJoinField(prePlanJoinField);
        joinManager.addJoinField(stageFlowMapJoinField);
        joinManager.addJoinField(flowJoinField);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverPreplan.class, "id", preplanId);
        conditionManager.addQueryField(RecoverFlow.class, "appId", applicationId);
        List<RecoverPreplan> resultList = this.queryRecordsList(RecoverPreplan.class, conditionManager, joinManager, RecoverPreplan.class);
        return resultList.size() > 0;
    }

    private void buildConditionManager(RecoverPreplanQuery preplanQuery, ConditionManager conditionManager) {
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "projectId", preplanQuery.getProjectId());
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "recoverPlanId", preplanQuery.getPlanId());
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "id", preplanQuery.getRecoverPreplanId());
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "type", preplanQuery.getPreplanType());
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "status", preplanQuery.getStatus());
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "siteId", preplanQuery.getSiteId());
        conditionManager.addNotNullQueryField(RecoverPreplan.class, "name", preplanQuery.getFullPreplanName());
        if (!VerifyUtil.isEmpty((String)preplanQuery.getPreplanName())) {
            String planNameWithWildcard = ConverterUtil.convertString((String)preplanQuery.getPreplanName(), (boolean)true);
            conditionManager.addQueryField(RecoverPreplan.class, "name", planNameWithWildcard, SqlSentence.LIKE.getValue());
        }
        if (!VerifyUtil.isEmpty((String)preplanQuery.getSiteName())) {
            SelectManager selectManager = new SelectManager(new SelectField(SiteInfo.class, "siteId"));
            JoinManager siteInfoJoin = new JoinManager();
            JoinField siteInfoJoinField = new JoinField(RecoverPreplan.class, SiteInfo.class, new JoinField.Pair("siteId", "siteId"));
            siteInfoJoin.addJoinField(siteInfoJoinField);
            ConditionManager siteInfoCondition = new ConditionManager();
            siteInfoCondition.addQueryField(SiteInfo.class, "siteName", preplanQuery.getSiteName());
            HashSet<Object[]> siteIdSet = new HashSet<Object[]>(this.queryRecordsList(selectManager, RecoverPreplan.class, siteInfoCondition, siteInfoJoin));
            if (siteIdSet.size() > 0) {
                conditionManager.addQueryField(RecoverPreplan.class, "siteId", siteIdSet, SqlSentence.IN.getValue());
            }
        }
    }

    @Override
    public void changeStatusRunningToFailed() {
        List<RecoverPreplan> recoverPreplans = this.queryRecordsList(RecoverPreplan.class, (ConditionManager)new ConditionManager().addQueryField(RecoverPreplan.class, "status", CommonUtil.getRecoverStatusIng(), SqlSentence.IN.getValue()));
        recoverPreplans.forEach(recoverPreplan -> {
            if (CommonUtil.getRecoverStatusMap().containsKey(recoverPreplan.getStatus())) {
                this.updateRecord(RecoverPreplan.class, (UpdateManager)new UpdateManager().addQueryField(RecoverPreplan.class, "status", CommonUtil.getRecoverStatusMap().get(recoverPreplan.getStatus())), (ConditionManager)new ConditionManager().addQueryField(RecoverPreplan.class, "id", recoverPreplan.getId()));
            }
        });
    }
}

