/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.dao.RecoverStageDao;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.UpdateManager;
import java.util.List;

public class RecoverStageDaoImpl
extends BaseDao<RecoverStage>
implements RecoverStageDao {
    @Override
    public void save(RecoverStage recoverStage) {
        this.checkParams(recoverStage);
        this.saveRecord(recoverStage);
    }

    @Override
    public void delete(String stageId) {
        this.checkParams(stageId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverStage.class, "id", stageId);
        this.deleteRecords(RecoverStage.class, conditionManager);
    }

    @Override
    public void update(RecoverStage recoverStage) {
        this.checkParams(recoverStage.getId());
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverStage.class, "id", recoverStage.getId());
        UpdateManager updateManager = new UpdateManager();
        updateManager.addQueryField(RecoverStage.class, "name", recoverStage.getName());
        updateManager.addQueryField(RecoverStage.class, "preStageId", recoverStage.getPreStageId());
        updateManager.addQueryField(RecoverStage.class, "nextStageId", recoverStage.getNextStageId());
        this.updateRecord(RecoverStage.class, updateManager, conditionManager);
    }

    @Override
    public RecoverStage getRecoverStageById(String stageId) {
        this.checkParams(stageId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverStage.class, "id", stageId);
        return this.queryRecord(RecoverStage.class, conditionManager);
    }

    @Override
    public int getStageCountByName(String stageName, String preplanId) {
        this.checkParams(stageName, preplanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverStage.class, "name", stageName);
        conditionManager.addQueryField(RecoverStage.class, "prePlanId", preplanId);
        return this.getRecordsCount(RecoverStage.class, conditionManager).intValue();
    }

    @Override
    public List<RecoverStage> getRecoverStageListByPrePlan(String projectId, String prePlanId) {
        this.checkParams(prePlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverStage.class, "projectId", projectId);
        conditionManager.addQueryField(RecoverStage.class, "prePlanId", prePlanId);
        return this.queryRecordsList(RecoverStage.class, conditionManager);
    }

    @Override
    public int getRecoverStageCountByPrePlan(String projectId, String prePlanId) {
        this.checkParams(prePlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverStage.class, "projectId", projectId);
        conditionManager.addQueryField(RecoverStage.class, "prePlanId", prePlanId);
        return this.getRecordsCount(RecoverStage.class, conditionManager).intValue();
    }
}

