/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.model.RecoverStepChainQuery;
import com.huawei.csr.framework.dao.RecoverStepChainDao;
import com.huawei.csr.framework.dao.model.StepChain;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.UpdateManager;
import java.util.List;

public class RecoverStepChainDaoImpl
extends BaseDao<StepChain>
implements RecoverStepChainDao {
    @Override
    public void save(StepChain stepChain) {
        this.checkParams(stepChain);
        this.saveRecord(stepChain);
    }

    @Override
    public void delete(RecoverStepChainQuery query) {
        this.checkParams(query);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(StepChain.class, "recoverFlowId", query.getFlowId());
        conditionManager.addNotNullQueryField(StepChain.class, "prevStepId", query.getPrevStepId());
        conditionManager.addNotNullQueryField(StepChain.class, "nextStepId", query.getNextStepId());
        this.deleteRecords(StepChain.class, conditionManager);
    }

    @Override
    public void modify(StepChain stepChain) {
        this.checkParams(stepChain);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(StepChain.class, "recoverFlowId", stepChain.getRecoverFlowId());
        conditionManager.addNotNullQueryField(StepChain.class, "prevStepId", stepChain.getPrevStepId());
        conditionManager.addNotNullQueryField(StepChain.class, "nextStepId", stepChain.getNextStepId());
        UpdateManager updateManager = new UpdateManager();
        updateManager.addNotNullQueryField(StepChain.class, "recoverFlowId", stepChain.getRecoverFlowId());
        updateManager.addNotNullQueryField(StepChain.class, "prevStepId", stepChain.getPrevStepId());
        updateManager.addNotNullQueryField(StepChain.class, "nextStepId", stepChain.getNextStepId());
        this.updateRecord(StepChain.class, updateManager, conditionManager);
    }

    @Override
    public List<StepChain> queryPreStepList(String flowId, String stepId) {
        this.checkParams(stepId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(StepChain.class, "recoverFlowId", flowId);
        conditionManager.addNotNullQueryField(StepChain.class, "nextStepId", stepId);
        return this.queryRecordsList(StepChain.class, conditionManager);
    }

    @Override
    public List<StepChain> queryNextStepList(String flowId, String stepId) {
        this.checkParams(stepId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(StepChain.class, "recoverFlowId", flowId);
        conditionManager.addNotNullQueryField(StepChain.class, "prevStepId", stepId);
        return this.queryRecordsList(StepChain.class, conditionManager);
    }

    @Override
    public StepChain queryStepChain(RecoverStepChainQuery query) {
        this.checkParams(query);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(StepChain.class, "recoverFlowId", query.getFlowId());
        conditionManager.addNotNullQueryField(StepChain.class, "prevStepId", query.getPrevStepId());
        conditionManager.addNotNullQueryField(StepChain.class, "nextStepId", query.getNextStepId());
        return this.queryRecord(StepChain.class, conditionManager);
    }

    @Override
    public long getStepChainCount(RecoverStepChainQuery query) {
        this.checkParams(query);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(StepChain.class, "recoverFlowId", query.getFlowId());
        conditionManager.addNotNullQueryField(StepChain.class, "prevStepId", query.getPrevStepId());
        conditionManager.addNotNullQueryField(StepChain.class, "nextStepId", query.getNextStepId());
        return this.getRecordsCount(StepChain.class, conditionManager);
    }

    @Override
    public List<StepChain> queryAllPreStepId(String stepId) {
        this.checkParams(stepId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(StepChain.class, "nextStepId", stepId);
        return this.queryRecordsList(StepChain.class, conditionManager);
    }
}

