/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.utils.CommonUtil;
import com.huawei.csr.framework.dao.RecoverStepDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.FlowStepMap;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.JoinField;
import com.huawei.csr.framework.dao.support.JoinManager;
import com.huawei.csr.framework.dao.support.OrderManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class RecoverStepDaoImpl
extends BaseDao<RecoverStep>
implements RecoverStepDao {
    @Override
    public Set<RecoverStep> getNextSteps() {
        return Collections.emptySet();
    }

    private void generateListQuery(ConditionManager conditionManager, RecoverStepQuery recoverStepQuery) {
        conditionManager.addNotNullQueryField(RecoverStep.class, "projectId", recoverStepQuery.getProjectId());
        if (!VerifyUtil.isEmpty((String)recoverStepQuery.getStatus())) {
            conditionManager.addNotNullQueryField(RecoverStep.class, "status", recoverStepQuery.getStatus());
        }
        if (!VerifyUtil.isEmpty((String)recoverStepQuery.getServiceType())) {
            conditionManager.addQueryField(RecoverStep.class, "serviceType", recoverStepQuery.getServiceType());
        }
        if (!VerifyUtil.isEmpty((String)recoverStepQuery.getInstanceId())) {
            conditionManager.addNotNullQueryField(RecoverStep.class, "serviceInstanceId", recoverStepQuery.getInstanceId());
        }
        if (!VerifyUtil.isEmpty((String)recoverStepQuery.getStepName())) {
            String stepNameWithWildcard = ConverterUtil.convertString((String)recoverStepQuery.getStepName(), (boolean)true);
            conditionManager.addQueryField(RecoverStep.class, "name", stepNameWithWildcard, SqlSentence.LIKE.getValue());
        }
    }

    private void joinPrePlan2Step(JoinManager joinManager) {
        JoinField step2FlowStepMap = new JoinField(RecoverStep.class, FlowStepMap.class, new JoinField.Pair("id", "recoverStepId"));
        JoinField flowMap2StageFlowMap = new JoinField(FlowStepMap.class, StageFlowMap.class, new JoinField.Pair("recoverFlowId", "flowId"));
        JoinField stageFlowMap2Stage = new JoinField(StageFlowMap.class, RecoverStage.class, new JoinField.Pair("stageId", "id"));
        JoinField stage2Preplan = new JoinField(RecoverStage.class, RecoverPreplan.class, new JoinField.Pair("prePlanId", "id"));
        joinManager.addJoinField(step2FlowStepMap);
        joinManager.addJoinField(flowMap2StageFlowMap);
        joinManager.addJoinField(stageFlowMap2Stage);
        joinManager.addJoinField(stage2Preplan);
    }

    private void generateJoinQuery(JoinManager joinManager, ConditionManager conditionManager, RecoverStepQuery recoverStepQuery) {
        JoinField mapJoinField;
        if (!VerifyUtil.isEmpty((String)recoverStepQuery.getFlowId())) {
            mapJoinField = new JoinField(RecoverStep.class, FlowStepMap.class, new JoinField.Pair("id", "recoverStepId"));
            joinManager.addJoinField(mapJoinField);
            conditionManager.addNotNullQueryField(FlowStepMap.class, "recoverFlowId", recoverStepQuery.getFlowId());
        }
        if (!VerifyUtil.isEmpty((String)recoverStepQuery.getFlowName())) {
            mapJoinField = new JoinField(RecoverStep.class, FlowStepMap.class, new JoinField.Pair("id", "recoverStepId"));
            JoinField flowJoinField = new JoinField(FlowStepMap.class, RecoverFlow.class, new JoinField.Pair("recoverFlowId", "id"));
            joinManager.addJoinField(mapJoinField);
            joinManager.addJoinField(flowJoinField);
            String flowNameWithWildcard = ConverterUtil.convertString((String)recoverStepQuery.getFlowName(), (boolean)true);
            conditionManager.addQueryField(RecoverFlow.class, "name", flowNameWithWildcard, SqlSentence.LIKE.getValue());
        }
        if (!VerifyUtil.isEmpty((String)recoverStepQuery.getPreplanName())) {
            this.joinPrePlan2Step(joinManager);
            String preplanNameWithWildcard = ConverterUtil.convertString((String)recoverStepQuery.getPreplanName(), (boolean)true);
            conditionManager.addQueryField(RecoverPreplan.class, "name", preplanNameWithWildcard, SqlSentence.LIKE.getValue());
        }
        if (!VerifyUtil.isEmpty((String)recoverStepQuery.getInstanceName())) {
            this.joinInstance2Step(joinManager);
            String instanceNameWithWildcard = ConverterUtil.convertString((String)recoverStepQuery.getInstanceName(), (boolean)true);
            conditionManager.addQueryField(AppServiceInstance.class, "instanceName", instanceNameWithWildcard, SqlSentence.LIKE.getValue());
        }
    }

    private void joinInstance2Step(JoinManager joinManager) {
        JoinField instance2Step = new JoinField(RecoverStep.class, AppServiceInstance.class, new JoinField.Pair("serviceInstanceId", "id"));
        joinManager.addJoinField(instance2Step);
    }

    @Override
    public List<RecoverStep> queryRecoverStepList(RecoverStepQuery recoverStepQuery) {
        this.checkParams(recoverStepQuery);
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(RecoverStep.class, "createdAt", false);
        ConditionManager conditionManager = new ConditionManager(recoverStepQuery);
        this.generateListQuery(conditionManager, recoverStepQuery);
        if (!(VerifyUtil.isEmpty((String)recoverStepQuery.getFlowId()) && VerifyUtil.isEmpty((String)recoverStepQuery.getFlowName()) && VerifyUtil.isEmpty((String)recoverStepQuery.getPreplanName()) && VerifyUtil.isEmpty((String)recoverStepQuery.getInstanceName()))) {
            JoinManager joinManager = new JoinManager();
            this.generateJoinQuery(joinManager, conditionManager, recoverStepQuery);
            return this.queryRecordsList(RecoverStep.class, conditionManager, orderManager, null, joinManager, RecoverStep.class);
        }
        return this.queryRecordsList(RecoverStep.class, conditionManager, orderManager);
    }

    @Override
    public RecoverStep queryRecoverStep(RecoverStepQuery query) {
        this.checkParams(query);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverStep.class, "projectId", query.getProjectId());
        conditionManager.addNotNullQueryField(RecoverStep.class, "id", query.getStepId());
        conditionManager.addNotNullQueryField(RecoverStep.class, "serviceInstanceId", query.getInstanceId());
        conditionManager.addNotNullQueryField(RecoverStep.class, "serviceType", query.getServiceType());
        conditionManager.addNotNullQueryField(RecoverStep.class, "operationType", query.getOperationType());
        return this.queryRecord(RecoverStep.class, conditionManager);
    }

    @Override
    public long getRecoverStepCount(RecoverStepQuery recoverStepQuery) {
        this.checkParams(recoverStepQuery);
        recoverStepQuery.setPage(false);
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(RecoverStep.class, "createdAt", false);
        ConditionManager conditionManager = new ConditionManager(recoverStepQuery);
        this.generateListQuery(conditionManager, recoverStepQuery);
        if (!(VerifyUtil.isEmpty((String)recoverStepQuery.getFlowId()) && VerifyUtil.isEmpty((String)recoverStepQuery.getFlowName()) && VerifyUtil.isEmpty((String)recoverStepQuery.getPreplanName()))) {
            JoinManager joinManager = new JoinManager();
            this.generateJoinQuery(joinManager, conditionManager, recoverStepQuery);
            return this.queryRecordsList(RecoverStep.class, conditionManager, orderManager, null, joinManager, RecoverStep.class).size();
        }
        return this.queryRecordsList(RecoverStep.class, conditionManager).size();
    }

    @Override
    public void modify(RecoverStepQuery recoverStepQuery, RecoverStep recoverStep) {
        this.checkParams(recoverStepQuery, recoverStep);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverStep.class, "projectId", recoverStepQuery.getProjectId());
        conditionManager.addNotNullQueryField(RecoverStep.class, "id", recoverStepQuery.getStepId());
        UpdateManager updateManager = new UpdateManager();
        if (!VerifyUtil.isEmpty((String)recoverStep.getName())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "name", recoverStep.getName());
        }
        if (!VerifyUtil.isEmpty((Object)recoverStep.getPreDelayTime())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "preDelayTime", recoverStep.getPreDelayTime());
        }
        if (!VerifyUtil.isEmpty((Object)recoverStep.getAfterDelayTime())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "afterDelayTime", recoverStep.getAfterDelayTime());
        }
        if (!VerifyUtil.isEmpty((String)recoverStep.getServiceInstanceId())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "serviceInstanceId", recoverStep.getServiceInstanceId());
        }
        if (!VerifyUtil.isEmpty((String)recoverStep.getAction())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "action", recoverStep.getAction());
        }
        if (!VerifyUtil.isEmpty((Object)recoverStep.getExpectRTO())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "expectRTO", recoverStep.getExpectRTO());
        }
        if (!VerifyUtil.isEmpty((String)recoverStep.getServiceType())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "serviceType", recoverStep.getServiceType());
        }
        this.updateRecord(RecoverStep.class, updateManager, conditionManager);
    }

    @Override
    public void save(RecoverStep recoverStep) {
        this.checkParams(recoverStep);
        this.saveRecord(recoverStep);
    }

    @Override
    public void update(RecoverStep recoverStep) {
        this.checkParams(recoverStep);
        UpdateManager updateManager = new UpdateManager();
        updateManager.addNotNullQueryField(RecoverStep.class, "projectId", recoverStep.getProjectId());
        updateManager.addNotNullQueryField(RecoverStep.class, "name", recoverStep.getName());
        updateManager.addNotNullQueryField(RecoverStep.class, "serviceType", recoverStep.getServiceType());
        updateManager.addNotNullQueryField(RecoverStep.class, "action", recoverStep.getAction());
        updateManager.addNotNullQueryField(RecoverStep.class, "status", recoverStep.getStatus());
        updateManager.addNotNullQueryField(RecoverStep.class, "expectRTO", recoverStep.getExpectRTO());
        updateManager.addNotNullQueryField(RecoverStep.class, "serviceInstanceId", recoverStep.getServiceInstanceId());
        updateManager.addNotNullQueryField(RecoverStep.class, "isValid", recoverStep.getIsValid());
        updateManager.addNotNullQueryField(RecoverStep.class, "preDelayTime", recoverStep.getPreDelayTime());
        updateManager.addNotNullQueryField(RecoverStep.class, "afterDelayTime", recoverStep.getAfterDelayTime());
        updateManager.addNotNullQueryField(RecoverStep.class, "averageExecuteDuration", recoverStep.getAverageExecuteDuration());
        updateManager.addNotNullQueryField(RecoverStep.class, "lastExecuteDuration", recoverStep.getLastExecuteDuration());
        updateManager.addNotNullQueryField(RecoverStep.class, "lastExecuteTime", recoverStep.getLastExecuteTime());
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(RecoverStep.class, "id", recoverStep.getId());
        conditionManager.addNotNullQueryField(RecoverStep.class, "projectId", recoverStep.getProjectId());
        this.updateRecord(RecoverStep.class, updateManager, conditionManager);
    }

    @Override
    public void delete(RecoverStepQuery recoverStepQuery) {
        this.checkParams(recoverStepQuery);
        ConditionManager conditionManager = new ConditionManager(recoverStepQuery);
        conditionManager.addNotNullQueryField(RecoverStep.class, "id", recoverStepQuery.getStepId());
        conditionManager.addNotNullQueryField(RecoverStep.class, "serviceInstanceId", recoverStepQuery.getInstanceId());
        this.deleteRecords(RecoverStep.class, conditionManager);
    }

    @Override
    public long getAllRecoverStepCount() {
        return this.queryAllRecords(RecoverStep.class).size();
    }

    @Override
    public void modifyRelatedStep(RecoverStepQuery recoverStepQuery, RecoverStep recoverStep) {
        this.checkParams(recoverStepQuery, recoverStep);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverStep.class, "projectId", recoverStepQuery.getProjectId());
        conditionManager.addNotNullQueryField(RecoverStep.class, "id", recoverStepQuery.getStepId());
        UpdateManager updateManager = new UpdateManager();
        if (!VerifyUtil.isEmpty((String)recoverStep.getName())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "name", recoverStep.getName());
        }
        if (!VerifyUtil.isEmpty((Object)recoverStep.getExpectRTO())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "expectRTO", recoverStep.getExpectRTO());
        }
        if (!VerifyUtil.isEmpty((Object)recoverStep.getPreDelayTime())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "preDelayTime", recoverStep.getPreDelayTime());
        }
        if (!VerifyUtil.isEmpty((Object)recoverStep.getAfterDelayTime())) {
            updateManager.addNotNullQueryField(RecoverStep.class, "afterDelayTime", recoverStep.getAfterDelayTime());
        }
        this.updateRecord(RecoverStep.class, updateManager, conditionManager);
    }

    @Override
    public RecoverStep queryRecoverStepById(String stepId) {
        this.checkParams(stepId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverStep.class, "id", stepId);
        return this.queryRecord(RecoverStep.class, conditionManager);
    }

    @Override
    public RecoverStep queryRecoverStepByName(String projectId, String name) {
        this.checkParams(projectId, name);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverStep.class, "projectId", projectId);
        conditionManager.addNotNullQueryField(RecoverStep.class, "name", name);
        return this.queryRecord(RecoverStep.class, conditionManager);
    }

    @Override
    public long getRecoverStepCountByInstanceId(String serviceInstanceId) {
        this.checkParams(serviceInstanceId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(RecoverStep.class, "serviceInstanceId", serviceInstanceId);
        return this.getRecordsCount(RecoverStep.class, conditionManager);
    }

    @Override
    public void changeStatusRunningToFailed() {
        List<RecoverStep> recoverSteps = this.queryRecordsList(RecoverStep.class, (ConditionManager)new ConditionManager().addQueryField(RecoverStep.class, "status", CommonUtil.getRecoverStatusIng(), SqlSentence.IN.getValue()));
        recoverSteps.forEach(recoverStep -> {
            if (CommonUtil.getRecoverStatusMap().containsKey(recoverStep.getStatus())) {
                this.updateRecord(RecoverStep.class, (UpdateManager)new UpdateManager().addQueryField(RecoverStep.class, "status", CommonUtil.getRecoverStatusMap().get(recoverStep.getStatus())), (ConditionManager)new ConditionManager().addQueryField(RecoverStep.class, "id", recoverStep.getId()));
            }
        });
    }
}

