/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.ServiceInstanceQuery;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.FlowStepMap;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.JoinField;
import com.huawei.csr.framework.dao.support.JoinManager;
import com.huawei.csr.framework.dao.support.OrderManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.base.util.ConverterUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.hibernate.query.Query;

public class ServiceInstanceDaoImpl
extends BaseDao<AppServiceInstance>
implements ServiceInstanceDao {
    @Override
    public void updateServiceInstance(AppServiceInstance instance) {
        this.checkParams(instance);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(AppServiceInstance.class, "id", instance.getId());
        conditionManager.addQueryField(AppServiceInstance.class, "projectId", instance.getProjectId());
        UpdateManager updateManager = new UpdateManager();
        updateManager.addNotNullQueryField(AppServiceInstance.class, "instanceName", instance.getInstanceName());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "instanceAddress", instance.getInstanceAddress());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "status", instance.getStatus());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "pdSiteId", instance.getPdSiteId());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "pdSiteName", instance.getPdSiteName());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "drSiteId", instance.getDrSiteId());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "drSiteName", instance.getDrSiteName());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "pdRegionId", instance.getPdRegionId());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "pdRegionName", instance.getPdRegionName());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "pdAzId", instance.getPdAzId());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "pdAzName", instance.getPdAzName());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "drRegionId", instance.getDrRegionId());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "drRegionName", instance.getDrRegionName());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "drAzId", instance.getDrAzId());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "drAzName", instance.getDrAzName());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "replicaStatus", instance.getReplicaStatus());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "rpo", instance.getRpo());
        updateManager.addNotNullQueryField(AppServiceInstance.class, "instanceObjectCount", instance.getInstanceObjectCount());
        this.updateRecord(AppServiceInstance.class, updateManager, conditionManager);
    }

    @Override
    public long getServiceInstanceCountByAppId(String appId) {
        ConditionManager conditionManager = new ConditionManager();
        Application application = new Application();
        application.setId(appId);
        conditionManager.addQueryField(AppServiceInstance.class, "application", application);
        return this.getRecordsCount(AppServiceInstance.class, conditionManager);
    }

    @Override
    public AppServiceInstance getServiceInstanceById(String instanceId) {
        this.checkParams(instanceId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(AppServiceInstance.class, "id", instanceId);
        return this.queryRecord(AppServiceInstance.class, conditionManager);
    }

    @Override
    public void saveServiceInstances(Collection<AppServiceInstance> collection) {
        this.saveRecords(collection);
    }

    @Override
    public void removeServiceInstanceByInstanceId(String instanceId) {
        this.checkParams(instanceId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(AppServiceInstance.class, "id", instanceId);
        this.deleteRecords(AppServiceInstance.class, conditionManager);
    }

    @Override
    public List<AppServiceInstance> getServiceInstanceByAppId(String appId) {
        this.checkParams(appId);
        ConditionManager conditionManager = new ConditionManager();
        Application application = new Application();
        application.setId(appId);
        conditionManager.addQueryField(AppServiceInstance.class, "application", application);
        return this.queryRecordsList(AppServiceInstance.class, conditionManager);
    }

    @Override
    public List<AppServiceInstance> getServiceInstanceList(ServiceInstanceQuery serviceInstanceQuery) {
        this.checkParams(serviceInstanceQuery);
        ConditionManager conditionManager = this.buildConditionManager(serviceInstanceQuery);
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(AppServiceInstance.class, "createdAt", false);
        return this.queryRecordsList(AppServiceInstance.class, conditionManager, orderManager);
    }

    @Override
    public List<AppServiceInstance> getCanStepServiceInstanceList(ServiceInstanceQuery query) {
        this.checkParams(query);
        StringBuilder hql = new StringBuilder("select a ");
        LinkedList<Object> parameters = this.buildCanStepHql(query, hql);
        hql.append("order by a.createdAt desc");
        return Optional.ofNullable(this.getHibernateTemplate()).map(template -> {
            template.clear();
            return template;
        }).map(template -> (List)template.executeWithNativeSession(session -> {
            Query sessionQuery = session.createQuery(hql.toString(), AppServiceInstance.class);
            for (int i = 0; i < parameters.size(); ++i) {
                sessionQuery.setParameter(i, parameters.get(i));
            }
            if (query.isPage()) {
                sessionQuery.setFirstResult(query.getMarker());
                sessionQuery.setMaxResults(query.getLimit());
            }
            return sessionQuery.getResultList();
        })).orElse(null);
    }

    @Override
    public Integer getCanStepServiceInstanceCount(ServiceInstanceQuery query) {
        this.checkParams(query);
        StringBuilder hql = new StringBuilder(" select count(distinct a) ");
        LinkedList<Object> parameters = this.buildCanStepHql(query, hql);
        return Optional.ofNullable(this.getHibernateTemplate()).map(template -> {
            template.clear();
            return template;
        }).map(template -> (Integer)template.executeWithNativeSession(session -> {
            Query countQuery = session.createQuery(hql.toString(), Long.class);
            for (int i = 0; i < parameters.size(); ++i) {
                countQuery.setParameter(i, parameters.get(i));
            }
            return ((Long)countQuery.iterate().next()).intValue();
        })).orElse(0);
    }

    private LinkedList<Object> buildCanStepHql(ServiceInstanceQuery query, StringBuilder hql) {
        LinkedList<Object> parameters = new LinkedList<Object>();
        hql.append(" from AppServiceInstance a ");
        if (!VerifyUtil.isEmpty((String)query.getApplicationName())) {
            hql.append(" left join Application c").append(" on a.application.id = c.id ");
        }
        this.placeParamToHql(query, hql, parameters);
        return parameters;
    }

    private void placeParamToHql(ServiceInstanceQuery query, StringBuilder hql, LinkedList<Object> parameters) {
        String azId;
        hql.append(" where a.projectId =?");
        parameters.add(query.getProjectId());
        String regionId = query.getPdRegionId();
        if (!VerifyUtil.isEmpty((String)regionId)) {
            hql.append(" and ( a.pdRegionId =? or a.drRegionId =?) ");
            parameters.add(regionId);
            parameters.add(regionId);
        }
        if (!VerifyUtil.isEmpty((String)query.getServiceType())) {
            hql.append(" and a.serviceType =?");
            parameters.add(query.getServiceType());
        }
        if (!VerifyUtil.isEmpty((String)(azId = query.getPdAzId()))) {
            hql.append(" and ( a.pdAzId =? or a.drAzId =?) ");
            parameters.add(azId);
            parameters.add(azId);
        }
        if (!VerifyUtil.isEmpty((String)query.getInstanceName())) {
            String instanceName = ConverterUtil.convertString((String)query.getInstanceName(), (boolean)true);
            hql.append(" and a.instanceName like ?");
            parameters.add(instanceName);
        }
        if (!VerifyUtil.isEmpty((String)query.getInstanceId())) {
            hql.append(" and a.instanceId =?");
            parameters.add(query.getInstanceId());
        }
        if (!VerifyUtil.isEmpty((String)query.getId())) {
            hql.append(" and a.id =?");
            parameters.add(query.getId());
        }
        if (!VerifyUtil.isEmpty((String)query.getInstanceStatus())) {
            hql.append(" and a.status =?");
            parameters.add(query.getInstanceStatus());
        }
        String appName = query.getApplicationName();
        if (!VerifyUtil.isEmpty((String)query.getApplicationName())) {
            appName = ConverterUtil.convertString((String)appName, (boolean)true);
            hql.append(" and c.name like ?");
            parameters.add(appName);
        }
        if (!VerifyUtil.isEmpty((String)query.getStepId())) {
            hql.append(" and a.id != (select step.serviceInstanceId from RecoverStep step where step.id = ?) ");
            parameters.add(query.getStepId());
        }
    }

    @Override
    public Integer getServiceInstanceCount(ServiceInstanceQuery serviceInstanceQuery) {
        this.checkParams(serviceInstanceQuery);
        ConditionManager condition = this.buildConditionManager(serviceInstanceQuery);
        return this.getRecordsCount(AppServiceInstance.class, condition).intValue();
    }

    private ConditionManager buildConditionManager(ServiceInstanceQuery query) {
        ConditionManager condition = new ConditionManager(query);
        condition.addNotNullQueryField(AppServiceInstance.class, "projectId", query.getProjectId());
        Application app = null;
        if (query.getAppId() != null) {
            app = new Application();
            app.setId(query.getAppId());
        }
        condition.addNotNullQueryField(AppServiceInstance.class, "application", app);
        condition.addNotNullQueryField(AppServiceInstance.class, "drType", query.getDrType());
        condition.addNotNullQueryField(AppServiceInstance.class, "serviceType", query.getServiceType());
        condition.addNotNullQueryField(AppServiceInstance.class, "pdRegionId", query.getPdRegionId());
        condition.addNotNullQueryField(AppServiceInstance.class, "drRegionId", query.getDrRegionId());
        condition.addNotNullQueryField(AppServiceInstance.class, "pdAzId", query.getPdAzId());
        condition.addNotNullQueryField(AppServiceInstance.class, "drAzId", query.getDrAzId());
        if (!VerifyUtil.isEmpty((String)query.getInstanceName())) {
            String instanceNameWithWildcard = ConverterUtil.convertString((String)query.getInstanceName(), (boolean)true);
            condition.addNotNullQueryField(AppServiceInstance.class, "instanceName", instanceNameWithWildcard, SqlSentence.LIKE.getValue());
        }
        condition.addNotNullQueryField(AppServiceInstance.class, "status", query.getInstanceStatus());
        condition.addNotNullQueryField(AppServiceInstance.class, "instanceId", query.getInstanceId());
        condition.addNotNullQueryField(AppServiceInstance.class, "pdSiteId", query.getPdSiteId());
        condition.addNotNullQueryField(AppServiceInstance.class, "drSiteId", query.getDrSiteId());
        return condition;
    }

    @Override
    public void saveServiceInstance(AppServiceInstance serviceInstance) {
        this.checkParams(serviceInstance);
        this.saveRecord(serviceInstance);
    }

    @Override
    public AppServiceInstance getServiceInstanceByQuery(ServiceInstanceQuery query) {
        this.checkParams(query);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(AppServiceInstance.class, "projectId", query.getProjectId());
        conditionManager.addQueryField(AppServiceInstance.class, "id", query.getInstanceId());
        Application app = new Application();
        app.setId(query.getAppId());
        conditionManager.addQueryField(AppServiceInstance.class, "application", app);
        return this.queryRecord(AppServiceInstance.class, conditionManager);
    }

    @Override
    public long getTotal() {
        ConditionManager conditionManager = new ConditionManager();
        return this.getRecordsCount(AppServiceInstance.class, conditionManager);
    }

    @Override
    public List<AppServiceInstance> getServiceInstanceListByRegionAz(String pdRegionId, String pdAzId, String drRegionId, String drAzId) {
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(AppServiceInstance.class, "pdRegionId", pdRegionId);
        conditionManager.addNotNullQueryField(AppServiceInstance.class, "pdAzId", pdAzId);
        conditionManager.addNotNullQueryField(AppServiceInstance.class, "drRegionId", drRegionId);
        conditionManager.addNotNullQueryField(AppServiceInstance.class, "drAzId", drAzId);
        return this.queryRecordsList(AppServiceInstance.class, conditionManager);
    }

    @Override
    public List<RecoverStep> getRecoverStepByAppQuery(ServiceInstanceQuery query) {
        this.checkParams(query);
        ConditionManager conditionManager = new ConditionManager();
        Application app = new Application();
        app.setId(query.getAppId());
        conditionManager.addQueryField(AppServiceInstance.class, "application", app);
        conditionManager.addQueryField(AppServiceInstance.class, "projectId", query.getProjectId());
        JoinManager joinManager = new JoinManager();
        JoinField stepJoinField = new JoinField(AppServiceInstance.class, RecoverStep.class, new JoinField.Pair("id", "serviceInstanceId"));
        joinManager.addJoinField(stepJoinField);
        return this.queryRecordsList(AppServiceInstance.class, conditionManager, joinManager, RecoverStep.class);
    }

    @Override
    public List<AppServiceInstance> queryInstanceListInPreplan(String appId, String preplanId) {
        this.checkParams(appId, preplanId);
        JoinManager joinManager = new JoinManager();
        JoinField stepJoinField = new JoinField(AppServiceInstance.class, RecoverStep.class, new JoinField.Pair("id", "serviceInstanceId"));
        JoinField flowStepMapJoinField = new JoinField(RecoverStep.class, FlowStepMap.class, new JoinField.Pair("id", "recoverStepId"));
        JoinField flowJoinField = new JoinField(FlowStepMap.class, RecoverFlow.class, new JoinField.Pair("recoverFlowId", "id"));
        JoinField stageFlowMapJoinField = new JoinField(RecoverFlow.class, StageFlowMap.class, new JoinField.Pair("id", "flowId"));
        JoinField stageJoinField = new JoinField(StageFlowMap.class, RecoverStage.class, new JoinField.Pair("stageId", "id"));
        JoinField preplanJoinField = new JoinField(RecoverStage.class, RecoverPreplan.class, new JoinField.Pair("prePlanId", "id"));
        joinManager.addJoinField(stepJoinField);
        joinManager.addJoinField(flowStepMapJoinField);
        joinManager.addJoinField(flowJoinField);
        joinManager.addJoinField(stageFlowMapJoinField);
        joinManager.addJoinField(stageJoinField);
        joinManager.addJoinField(preplanJoinField);
        ConditionManager condition = new ConditionManager();
        condition.addQueryField(RecoverFlow.class, "appId", appId);
        condition.addQueryField(RecoverPreplan.class, "id", preplanId);
        condition.addQueryField(AppServiceInstance.class, "serviceType", ServiceType.ELB.getValue(), SqlSentence.NOT_EQUAL.getValue());
        return this.queryRecordsList(AppServiceInstance.class, condition, joinManager, AppServiceInstance.class);
    }

    @Override
    public List<AppServiceInstance> queryInstanceListInFlow(String flowId) {
        this.checkParams(flowId);
        JoinManager joinManager = new JoinManager();
        JoinField stepJoinField = new JoinField(AppServiceInstance.class, RecoverStep.class, new JoinField.Pair("id", "serviceInstanceId"));
        JoinField flowStepMapJoinField = new JoinField(RecoverStep.class, FlowStepMap.class, new JoinField.Pair("id", "recoverStepId"));
        JoinField flowJoinField = new JoinField(FlowStepMap.class, RecoverFlow.class, new JoinField.Pair("recoverFlowId", "id"));
        joinManager.addJoinField(stepJoinField);
        joinManager.addJoinField(flowStepMapJoinField);
        joinManager.addJoinField(flowJoinField);
        ConditionManager condition = new ConditionManager();
        condition.addQueryField(RecoverFlow.class, "id", flowId);
        condition.addQueryField(AppServiceInstance.class, "serviceType", ServiceType.ELB.getValue(), SqlSentence.NOT_EQUAL.getValue());
        return this.queryRecordsList(AppServiceInstance.class, condition, joinManager, AppServiceInstance.class);
    }

    @Override
    public int getAllServiceInstanceCount() {
        ConditionManager condition = new ConditionManager();
        condition.addQueryField(AppServiceInstance.class, "id", "null", SqlSentence.NOT_EQUAL.getValue());
        return this.getRecordsCount(AppServiceInstance.class, condition).intValue();
    }
}

