/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.dao.SiteInfoDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.query.Query;

public class SiteInfoDaoImpl
extends BaseDao<SiteInfo>
implements SiteInfoDao {
    @Override
    public List<SiteInfo> getSites() {
        return this.queryAllRecords(SiteInfo.class);
    }

    @Override
    public List<SiteInfo> getSites(String siteId) {
        this.checkParams(siteId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SiteInfo.class, "siteId", siteId);
        return this.queryRecordsList(SiteInfo.class, conditionManager);
    }

    @Override
    public void save(List<SiteInfo> siteList) {
        this.saveRecords(siteList);
    }

    @Override
    public void delete(List<SiteInfo> siteList) {
        for (SiteInfo siteInfo : siteList) {
            ConditionManager conditionManager = new ConditionManager();
            conditionManager.addNotNullQueryField(SiteInfo.class, "id", siteInfo.getId());
            this.deleteRecords(SiteInfo.class, conditionManager);
        }
    }

    @Override
    public List<SiteInfo> querySiteInfo(String siteId) {
        this.checkParams(siteId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SiteInfo.class, "siteId", siteId);
        return this.queryRecordsList(SiteInfo.class, conditionManager);
    }

    @Override
    public SiteInfo getSiteInfoByRegionAz(String regionId, String azId) {
        this.checkParams(regionId, azId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SiteInfo.class, "regionId", regionId);
        conditionManager.addNotNullQueryField(SiteInfo.class, "azId", azId);
        return this.queryRecord(SiteInfo.class, conditionManager);
    }

    @Override
    public List<SiteInfo> getSiteOfAppByRecoverPlanId(String projectId, String recoverPlanId) {
        this.checkParams(projectId, recoverPlanId);
        String siteInfoTableName = SiteInfo.class.getSimpleName();
        StringBuilder hqlBuilder = new StringBuilder();
        hqlBuilder.append("select ").append(siteInfoTableName).append(" from ").append(siteInfoTableName).append(SqlSentence.BLANK.getValue()).append(siteInfoTableName).append(" where siteId in (").append(this.buildQuerySiteIdHql("pdSiteId")).append(" ) or siteId in (").append(this.buildQuerySiteIdHql("drSiteId")).append(") ");
        return Optional.ofNullable(this.getHibernateTemplate()).map(template -> {
            template.clear();
            return template;
        }).map(template -> (Query)template.executeWithNativeSession(session -> {
            Query query = session.createQuery(hqlBuilder.toString());
            query.setParameter(0, (Object)recoverPlanId);
            query.setParameter(1, (Object)projectId);
            query.setParameter(2, (Object)recoverPlanId);
            query.setParameter(3, (Object)projectId);
            return query;
        })).map(query -> {
            List queryResults = query.list();
            return queryResults.stream().map(object -> {
                if (object == null) {
                    return null;
                }
                if (object instanceof SiteInfo) {
                    return (SiteInfo)object;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }).orElse(new ArrayList());
    }

    @Override
    public List<SiteInfo> querySiteInfoByRegionId(String regionId) {
        this.checkParams(regionId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SiteInfo.class, "regionId", regionId);
        return this.queryRecordsList(SiteInfo.class, conditionManager);
    }

    @Override
    public List<SiteInfo> querySiteInfoByAzId(String azId) {
        this.checkParams(azId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SiteInfo.class, "azId", azId);
        return this.queryRecordsList(SiteInfo.class, conditionManager);
    }

    private String buildQuerySiteIdHql(String siteIdFieldName) {
        StringBuilder hqlBuilder = new StringBuilder();
        String applicationTableName = Application.class.getSimpleName();
        String appServiceInstTableName = AppServiceInstance.class.getSimpleName();
        hqlBuilder.append(" select distinct ").append(appServiceInstTableName).append(".").append(siteIdFieldName).append(" from ").append(appServiceInstTableName).append(SqlSentence.BLANK.getValue()).append(appServiceInstTableName).append(" join ").append(applicationTableName).append(SqlSentence.BLANK.getValue()).append(applicationTableName).append(" on ").append(appServiceInstTableName).append(".application=").append(applicationTableName).append(".id").append(" where ").append(applicationTableName).append(".recoverPlanId=?").append(" and ").append(applicationTableName).append(".projectId=?");
        return hqlBuilder.toString();
    }
}

