/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.model.SitePlanQuery;
import com.huawei.csr.framework.common.statusopt.status.SitePlanStatus;
import com.huawei.csr.framework.common.utils.CommonUtil;
import com.huawei.csr.framework.dao.SitePlanDao;
import com.huawei.csr.framework.dao.model.SitePlan;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.OrderManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SitePlanDaoImpl
extends BaseDao<SitePlan>
implements SitePlanDao {
    @Override
    public List<SitePlan> querySitePlanListByProjectId(SitePlanQuery sitePlanQuery) {
        this.checkParams(sitePlanQuery);
        ConditionManager conditionManager = new ConditionManager(sitePlanQuery);
        conditionManager.addNotNullQueryField(SitePlan.class, "projectId", sitePlanQuery.getProjectId());
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(SitePlan.class, "createdAt", false);
        return this.queryRecordsList(SitePlan.class, conditionManager, orderManager);
    }

    @Override
    public SitePlan querySitePlan(String projectId, String sitePlanId) {
        this.checkParams(projectId, sitePlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlan.class, "projectId", projectId);
        conditionManager.addNotNullQueryField(SitePlan.class, "id", sitePlanId);
        return this.queryRecord(SitePlan.class, conditionManager);
    }

    @Override
    public long getSitePlanCountByProjectId(String projectId) {
        this.checkParams(projectId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlan.class, "projectId", projectId);
        return this.getRecordsCount(SitePlan.class, conditionManager);
    }

    @Override
    public void save(SitePlan sitePlan) {
        this.checkParams(sitePlan);
        this.saveRecord(sitePlan);
    }

    @Override
    public void delete(String siteId) {
        this.checkParams(siteId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlan.class, "siteId", siteId);
        this.deleteRecords(SitePlan.class, conditionManager);
    }

    @Override
    public List<SitePlan> querySitePlanListBySiteId(String siteId) {
        this.checkParams(siteId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlan.class, "siteId", siteId);
        return this.queryRecordsList(SitePlan.class, conditionManager);
    }

    @Override
    public SitePlan querySitePlanBySiteId(String projectId, String siteId) {
        this.checkParams(projectId, siteId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlan.class, "projectId", projectId);
        conditionManager.addNotNullQueryField(SitePlan.class, "siteId", siteId);
        return this.queryRecord(SitePlan.class, conditionManager);
    }

    @Override
    public void updateSitePlan(SitePlan sitePlan) {
        this.checkParams(sitePlan);
        UpdateManager updateManager = new UpdateManager();
        updateManager.addNotNullQueryField(SitePlan.class, "siteName", sitePlan.getSiteName());
        updateManager.addNotNullQueryField(SitePlan.class, "siteId", sitePlan.getSiteId());
        updateManager.addNotNullQueryField(SitePlan.class, "projectId", sitePlan.getProjectId());
        updateManager.addNotNullQueryField(SitePlan.class, "status", sitePlan.getStatus());
        updateManager.addNotNullQueryField(SitePlan.class, "lastExecuteTime", sitePlan.getLastExecuteTime());
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(SitePlan.class, "id", sitePlan.getId());
        this.updateRecord(SitePlan.class, updateManager, conditionManager);
    }

    @Override
    public void changeStatusRunningToFailed() {
        ArrayList<String> siteStatusIng = new ArrayList<String>(Arrays.asList(SitePlanStatus.DISASTER_RECOVERY_RUNNING.getValue(), SitePlanStatus.REPROTECT_RUNNING.getValue(), SitePlanStatus.SWITCHBACK_RUNNING.getValue()));
        List<SitePlan> sitePlans = this.queryRecordsList(SitePlan.class, (ConditionManager)new ConditionManager().addQueryField(SitePlan.class, "status", siteStatusIng, SqlSentence.IN.getValue()));
        sitePlans.forEach(sitePlan -> {
            if (CommonUtil.getRecoverStatusMap().containsKey(sitePlan.getStatus())) {
                this.updateRecord(SitePlan.class, (UpdateManager)new UpdateManager().addQueryField(SitePlan.class, "status", CommonUtil.getRecoverStatusMap().get(sitePlan.getStatus())), (ConditionManager)new ConditionManager().addQueryField(SitePlan.class, "id", sitePlan.getId()));
            }
        });
    }
}

