/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.common.model.SitePlanMapQuery;
import com.huawei.csr.framework.dao.SitePlanMapDao;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.dao.model.SitePlanMap;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.JoinField;
import com.huawei.csr.framework.dao.support.JoinManager;
import com.huawei.csr.framework.dao.support.OrderManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;

public class SitePlanMapDaoImpl
extends BaseDao<SitePlanMap>
implements SitePlanMapDao {
    @Override
    public void addPlanToSite(SitePlanMap sitePlanMap) {
        this.checkParams(sitePlanMap);
        this.saveRecord(sitePlanMap);
    }

    @Override
    public void removePlanToSite(String sitePlanId, String recoverPlanId) {
        this.checkParams(sitePlanId, recoverPlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlanMap.class, "sitePlanId", sitePlanId);
        conditionManager.addNotNullQueryField(SitePlanMap.class, "recoverPlanId", recoverPlanId);
        this.deleteRecords(SitePlanMap.class, conditionManager);
    }

    @Override
    public void modifyPlanPriority(String sitePlanId, String recoverPlanId, int priority) {
        this.checkParams(sitePlanId, recoverPlanId, priority);
        UpdateManager updateManager = new UpdateManager();
        updateManager.addQueryField(SitePlanMap.class, "priority", priority);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlanMap.class, "sitePlanId", sitePlanId);
        conditionManager.addNotNullQueryField(SitePlanMap.class, "recoverPlanId", recoverPlanId);
        this.updateRecord(SitePlanMap.class, updateManager, conditionManager);
    }

    @Override
    public long getRecoverPlanCountBySitePlanId(String sitePlanId) {
        this.checkParams(sitePlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlanMap.class, "sitePlanId", sitePlanId);
        return this.getRecordsCount(SitePlanMap.class, conditionManager);
    }

    @Override
    public List<SitePlanMap> querySitePlanMapByRecoverPlanId(String recoverPlanId) {
        this.checkParams(recoverPlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlanMap.class, "recoverPlanId", recoverPlanId);
        return this.queryRecordsList(SitePlanMap.class, conditionManager);
    }

    @Override
    public int queryRecoverPlanPriority(String sitePlanId, String recoverPlanId) {
        this.checkParams(sitePlanId, recoverPlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlanMap.class, "sitePlanId", sitePlanId);
        conditionManager.addNotNullQueryField(SitePlanMap.class, "recoverPlanId", recoverPlanId);
        SitePlanMap sitePlanMap = this.queryRecord(SitePlanMap.class, conditionManager);
        return sitePlanMap.getPriority();
    }

    @Override
    public List<SitePlanMap> queryPagedSitePlanMapBySitePlanId(SitePlanMapQuery sitePlanMapQuery) {
        this.checkParams(sitePlanMapQuery);
        OrderManager orderManager = new OrderManager();
        orderManager.addOrderField(SitePlanMap.class, "priority", true);
        ConditionManager conditionManager = new ConditionManager(sitePlanMapQuery);
        conditionManager.addNotNullQueryField(SitePlanMap.class, "sitePlanId", sitePlanMapQuery.getSitePlanId());
        if (!VerifyUtil.isEmpty((String)sitePlanMapQuery.getRecoverPlanName()) || !VerifyUtil.isEmpty((String)sitePlanMapQuery.getRecoverPlanStatus())) {
            JoinManager joinManager = new JoinManager();
            JoinField joinField = new JoinField(SitePlanMap.class, RecoverPlan.class, new JoinField.Pair("recoverPlanId", "id"));
            joinManager.addJoinField(joinField);
            if (!VerifyUtil.isEmpty((String)sitePlanMapQuery.getRecoverPlanName())) {
                String planWithWildcard = ConverterUtil.convertString((String)sitePlanMapQuery.getRecoverPlanName(), (boolean)true);
                conditionManager.addQueryField(RecoverPlan.class, "name", planWithWildcard, SqlSentence.LIKE.getValue());
            }
            if (!VerifyUtil.isEmpty((String)sitePlanMapQuery.getRecoverPlanStatus())) {
                conditionManager.addNotNullQueryField(RecoverPlan.class, "status", sitePlanMapQuery.getRecoverPlanStatus());
            }
            return this.queryRecordsList(SitePlanMap.class, conditionManager, orderManager, joinManager, SitePlanMap.class);
        }
        return this.queryRecordsList(SitePlanMap.class, conditionManager, orderManager);
    }

    @Override
    public long getSitePlanMapCount(String sitePlanId, String recoverPlanId) {
        this.checkParams(sitePlanId, recoverPlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlanMap.class, "sitePlanId", sitePlanId);
        conditionManager.addNotNullQueryField(SitePlanMap.class, "recoverPlanId", recoverPlanId);
        return this.getRecordsCount(SitePlanMap.class, conditionManager);
    }

    @Override
    public void removeMapBySitePlanId(String sitePlanId) {
        this.checkParams(sitePlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlanMap.class, "sitePlanId", sitePlanId);
        this.deleteRecords(SitePlanMap.class, conditionManager);
    }

    @Override
    public void removeMapByRecoverPlanId(String recoverPlanId) {
        this.checkParams(recoverPlanId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(SitePlanMap.class, "recoverPlanId", recoverPlanId);
        this.deleteRecords(SitePlanMap.class, conditionManager);
    }
}

