/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.impl;

import com.huawei.csr.framework.dao.StageFlowMapDao;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.csr.framework.dao.support.BaseDao;
import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.JoinField;
import com.huawei.csr.framework.dao.support.JoinManager;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class StageFlowMapDaoImpl
extends BaseDao<StageFlowMap>
implements StageFlowMapDao {
    private static final Log LOGGER = LogFactory.getInstance(StageFlowMapDaoImpl.class);

    @Override
    public void addFlowToStage(StageFlowMap stageFlowMap) {
        this.checkParams(stageFlowMap);
        this.saveRecord(stageFlowMap);
    }

    @Override
    public void removeFlowFromStage(String stageId, String flowId) {
        this.checkParams(stageId, flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(StageFlowMap.class, "stageId", stageId);
        conditionManager.addQueryField(StageFlowMap.class, "flowId", flowId);
        this.deleteRecords(StageFlowMap.class, conditionManager);
    }

    @Override
    public void batchRemoveFlowFromStageByStageId(String stageId) {
        this.checkParams(stageId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(StageFlowMap.class, "stageId", stageId);
        this.deleteRecords(StageFlowMap.class, conditionManager);
    }

    @Override
    public void batchRemoveFlowFromStageByFlowId(String flowId) {
        this.checkParams(flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(StageFlowMap.class, "flowId", flowId);
        this.deleteRecords(StageFlowMap.class, conditionManager);
    }

    @Override
    public long getStageFlowMapCount(String stageId, String flowId) {
        this.checkParams(stageId, flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(StageFlowMap.class, "flowId", flowId);
        conditionManager.addQueryField(StageFlowMap.class, "stageId", stageId);
        return this.getRecordsCount(StageFlowMap.class, conditionManager);
    }

    @Override
    public long getStageFlowMapCountByStageId(String stageId) {
        this.checkParams(stageId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(StageFlowMap.class, "stageId", stageId);
        return this.getRecordsCount(StageFlowMap.class, conditionManager);
    }

    @Override
    public long getStageFlowMapCountByFlowId(String flowId) {
        this.checkParams(flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(StageFlowMap.class, "flowId", flowId);
        return this.getRecordsCount(StageFlowMap.class, conditionManager);
    }

    @Override
    public List<StageFlowMap> queryStageFlowMapByStageId(String stageId) {
        this.checkParams(stageId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(StageFlowMap.class, "stageId", stageId);
        return this.queryRecordsList(StageFlowMap.class, conditionManager);
    }

    @Override
    public List<StageFlowMap> queryStageFlowMapByFlowId(String flowId) {
        this.checkParams(flowId);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addQueryField(StageFlowMap.class, "flowId", flowId);
        return this.queryRecordsList(StageFlowMap.class, conditionManager);
    }

    @Override
    public Optional<StageFlowMap> queryStageFlowMapByFlowIdAndPreplanId(String flowId, String preplanId) {
        this.checkParams(flowId, preplanId);
        JoinManager joinManager = new JoinManager();
        JoinField stageJoinField = new JoinField(StageFlowMap.class, RecoverStage.class, new JoinField.Pair("stageId", "id"));
        joinManager.addJoinField(stageJoinField);
        ConditionManager conditionManager = new ConditionManager();
        conditionManager.addNotNullQueryField(StageFlowMap.class, "flowId", flowId);
        conditionManager.addNotNullQueryField(RecoverStage.class, "prePlanId", preplanId);
        List<StageFlowMap> mapList = this.queryRecordsList(StageFlowMap.class, conditionManager, joinManager, StageFlowMap.class);
        if (CollectionUtils.isEmpty(mapList)) {
            LOGGER.debug((Object)"Query stageFlowMap by flowId and prePlanId empty,flowId is '%s',PreplanId is '%s'", new Object[]{flowId, preplanId});
            return Optional.empty();
        }
        return Optional.of(mapList.get(0));
    }
}

