/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.support;

import com.huawei.csr.framework.dao.support.ConditionManager;
import com.huawei.csr.framework.dao.support.GroupManager;
import com.huawei.csr.framework.dao.support.JoinManager;
import com.huawei.csr.framework.dao.support.OrderManager;
import com.huawei.csr.framework.dao.support.SelectManager;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.csr.framework.dao.support.UpdateManager;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;

public class BaseDao<T>
extends HibernateDaoSupportWrapper {
    private static final String HT_IS_NULL = "HibernateTemplate is null";

    public void saveOrUpdateRecord(T record) {
        this.checkParams(record);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        Object transaction = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            HibernateUtil.beginTransaction((Session)session);
            session.saveOrUpdate(record);
            HibernateUtil.commit((Session)session);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"SaveOrUpdateRecord failed.", (Throwable)e);
            throw e;
        }
    }

    public void saveRecord(T record) {
        this.checkParams(record);
        Session session = null;
        Object transaction = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            HibernateUtil.beginTransaction((Session)session);
            session.save(record);
            HibernateUtil.commit((Session)session);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"SaveRecord failed.", (Throwable)e);
            throw e;
        }
    }

    public void updateRecord(T record) {
        this.checkParams(record);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Object transaction = null;
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            HibernateUtil.beginTransaction((Session)session);
            session.update(record);
            HibernateUtil.commit((Session)session);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"UpdateRecord failed.", (Throwable)e);
            throw e;
        }
    }

    public void deleteRecord(T record) {
        this.checkParams(record);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        Object transaction = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            HibernateUtil.beginTransaction((Session)session);
            session.delete(record);
            HibernateUtil.commit((Session)session);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"DeleteRecord failed.", (Throwable)e);
            throw e;
        }
    }

    public void saveRecords(Collection<T> records) {
        this.checkParams(records);
        Session session = null;
        Object transaction = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            HibernateUtil.beginTransaction((Session)session);
            for (T record : records) {
                session.save(record);
            }
            HibernateUtil.commit((Session)session);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"SaveRecords failed.", (Throwable)e);
            throw e;
        }
    }

    public T getRecord(Class<T> recordCls, String pkId) {
        this.checkParams(recordCls, pkId);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        return (T)this.getHibernateTemplate().get(recordCls, (Serializable)((Object)pkId));
    }

    public void deleteRecords(Class<T> clazz, ConditionManager condition) {
        this.checkParams(clazz, condition);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            String hql = this.getBaseQuerySentence(clazz, OperaType.DELETE);
            hql = hql + condition.getQuerySentence();
            Query query = session.createQuery(hql);
            condition.setQueryParams(query);
            query.executeUpdate();
        }
        catch (DataAccessException e) {
            try {
                this.logger.error((Object)"DeleteRecords failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
    }

    public void deleteRecords(List<T> records) {
        this.checkParams(records);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        Object transaction = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            HibernateUtil.beginTransaction((Session)session);
            for (T record : records) {
                session.delete(record);
            }
            HibernateUtil.commit((Session)session);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"DeleteRecords failed.", (Throwable)e);
            throw e;
        }
    }

    public void updateRecord(Class<T> clazz, UpdateManager update, ConditionManager condition) {
        this.checkParams(clazz, update, condition);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            String hql = this.getBaseQuerySentence(clazz, OperaType.UPDATE);
            hql = hql + update.getQuerySentence() + condition.getQuerySentence();
            Query query = session.createQuery(hql);
            condition.setPositionIndex(update.setQueryParams(query));
            condition.setQueryParams(query);
            query.executeUpdate();
        }
        catch (DataAccessException e) {
            try {
                this.logger.error((Object)"UpdateRecord failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
    }

    public List<T> queryAllRecords(Class<T> clazz) {
        List list;
        this.checkParams(clazz);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        String hql = this.getBaseQuerySentence(clazz, OperaType.GET);
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Query query = session.createQuery(hql);
            list = query.list();
        }
        catch (DataAccessException e) {
            try {
                this.logger.error((Object)"QueryAllRecords failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }

    public List<T> queryRecordsList(Class<T> clazz, ConditionManager condition) {
        return this.queryRecordsList(clazz, condition, (OrderManager)null, null);
    }

    public List<T> queryRecordsList(Class<T> clazz, ConditionManager condition, OrderManager orderManager) {
        return this.queryRecordsList(clazz, condition, orderManager, null);
    }

    public List<T> queryRecordsList(Class<T> clazz, ConditionManager condition, GroupManager groupManager) {
        return this.queryRecordsList(clazz, condition, null, groupManager);
    }

    public List<T> queryRecordsList(Class<T> clazz, ConditionManager condition, OrderManager orderManager, GroupManager groupManager) {
        List list;
        this.checkParams(clazz, condition);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Query<?> query = this.buildQuery(session, null, clazz, condition, orderManager, groupManager, null);
            list = query.list();
        }
        catch (DataAccessException e) {
            try {
                this.logger.error((Object)"QueryRecordsList failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }

    public <K> List<K> queryRecordsList(Class<T> clazz, ConditionManager condition, JoinManager joinManager, Class<K> resultCls) {
        return this.queryRecordsList(clazz, condition, null, null, joinManager, resultCls);
    }

    public <K> List<K> queryRecordsList(Class<T> clazz, ConditionManager condition, OrderManager orderManager, JoinManager joinManager, Class<K> resultCls) {
        return this.queryRecordsList(clazz, condition, orderManager, null, joinManager, resultCls);
    }

    public <K> List<K> queryRecordsList(Class<T> clazz, ConditionManager condition, GroupManager groupManager, JoinManager joinManager, Class<K> resultCls) {
        return this.queryRecordsList(clazz, condition, null, groupManager, joinManager, resultCls);
    }

    public <K> List<K> queryRecordsList(Class<T> clazz, ConditionManager condition, OrderManager orderManager, GroupManager groupManager, JoinManager joinManager, Class<K> resultCls) {
        List<K> list;
        this.checkParams(clazz, condition, joinManager, resultCls);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Query<?> query = this.buildQuery(session, null, clazz, condition, orderManager, groupManager, joinManager);
            List queryResults = query.list();
            list = this.handleQueryObjectsResult(queryResults, resultCls);
        }
        catch (DataAccessException e) {
            try {
                this.logger.error((Object)"QueryRecordsList failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }

    private <K> List<K> handleQueryObjectsResult(List<Object[]> queryResults, Class<K> resultCls) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object[] queryResult : queryResults) {
            for (Object item : queryResult) {
                if (!resultCls.isInstance(item)) continue;
                results.add(item);
            }
        }
        return results;
    }

    public List<Object[]> queryRecordsList(Class<T> clazz, ConditionManager condition, OrderManager orderManager, GroupManager groupManager, JoinManager joinManager) {
        List list;
        this.checkParams(clazz, condition, joinManager);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Query<?> query = this.buildQuery(session, null, clazz, condition, orderManager, groupManager, joinManager);
            list = query.list();
        }
        catch (DataAccessException e) {
            try {
                this.logger.error((Object)"QueryRecordsList failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }

    public List<Object[]> queryRecordsList(SelectManager selectManager, Class<T> clazz, ConditionManager condition) {
        return this.queryRecordsList(selectManager, clazz, condition, null, null, null);
    }

    public List<Object[]> queryRecordsList(SelectManager selectManager, Class<T> clazz, ConditionManager condition, OrderManager orderManager) {
        return this.queryRecordsList(selectManager, clazz, condition, orderManager, null, null);
    }

    public List<Object[]> queryRecordsList(SelectManager selectManager, Class<T> clazz, ConditionManager condition, GroupManager groupManager) {
        return this.queryRecordsList(selectManager, clazz, condition, null, groupManager, null);
    }

    public List<Object[]> queryRecordsList(SelectManager selectManager, Class<T> clazz, ConditionManager condition, JoinManager joinManager) {
        return this.queryRecordsList(selectManager, clazz, condition, null, null, joinManager);
    }

    public List<Object[]> queryRecordsList(SelectManager selectManager, Class<T> clazz, ConditionManager condition, OrderManager orderManager, GroupManager groupManager, JoinManager joinManager) {
        List list;
        this.checkParams(selectManager, clazz, condition);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Query<?> query = this.buildQuery(session, selectManager, clazz, condition, orderManager, groupManager, joinManager);
            list = query.list();
        }
        catch (DataAccessException e) {
            try {
                this.logger.error((Object)"QueryRecordsList failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }

    public Query<?> buildQuery(Session session, SelectManager selectManager, Class<T> clazz, ConditionManager condition, OrderManager orderManager, GroupManager groupManager, JoinManager joinManager) {
        this.checkParams(condition, clazz);
        StringBuilder hql = new StringBuilder();
        if (selectManager != null) {
            hql.append(selectManager.getSelect()).append(SqlSentence.BLANK.getValue());
        }
        hql.append(this.getBaseQuerySentence(clazz, OperaType.GET));
        if (joinManager != null) {
            hql.append(joinManager.getJoin());
        }
        hql.append(condition.getQuerySentence());
        if (groupManager != null) {
            hql.append(groupManager.getGroupBy());
        }
        if (orderManager != null) {
            hql.append(orderManager.getOrderBy());
        }
        Query query = session.createQuery(hql.toString());
        condition.setQueryParams(query);
        if (condition.isPage()) {
            query.setFirstResult(condition.getMarker());
            query.setMaxResults(condition.getLimit());
        }
        return query;
    }

    public T queryRecord(Class<T> clazz, ConditionManager condition) {
        Object object;
        this.checkParams(clazz, condition);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            String hql = this.getBaseQuerySentence(clazz, OperaType.GET);
            hql = hql + condition.getQuerySentence();
            Query query = session.createQuery(hql);
            condition.setQueryParams(query);
            object = query.uniqueResult();
        }
        catch (DataAccessException e) {
            try {
                this.logger.error((Object)"QueryRecord failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return (T)object;
    }

    public Long getRecordsCount(Class<T> clazz, ConditionManager condition) {
        return this.getRecordsCount(clazz, condition, null);
    }

    public Long getRecordsCount(Class<T> clazz, ConditionManager condition, JoinManager joinManager) {
        Long l;
        this.checkParams(clazz, condition);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            String hql = String.format(Locale.ENGLISH, this.getBaseQuerySentence(clazz, OperaType.SELECT), "count(1)");
            if (joinManager != null) {
                hql = hql + joinManager.getJoin();
            }
            hql = hql + condition.getQuerySentence();
            Query query = session.createQuery(hql);
            condition.setQueryParams(query);
            l = (Long)query.iterate().next();
        }
        catch (DataAccessException e) {
            try {
                this.logger.error((Object)"GetRecordsCount failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return l;
    }

    public Long getRecordsCount(LinkedList<Object> param, String hql) {
        Long l;
        this.checkParams(param, hql);
        Assert.notNull((Object)this.getHibernateTemplate(), (String)HT_IS_NULL);
        Session session = null;
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Query query = session.createQuery(hql);
            for (int i = 0; i < param.size(); ++i) {
                query.setParameter(i, param.get(i));
            }
            l = (Long)query.iterate().next();
        }
        catch (DataAccessException e) {
            try {
                this.logger.error((Object)"GetRecordsCount failed.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return l;
    }

    private String getBaseQuerySentence(Class<T> clazz, OperaType operaType) {
        return operaType.getValue() + clazz.getSimpleName() + SqlSentence.BLANK.getValue() + clazz.getSimpleName();
    }

    @SafeVarargs
    protected final <K> void checkParams(K ... params) {
        for (K param : params) {
            if (!VerifyUtil.isEmpty(param)) continue;
            throw new LegoCheckedException("param is null.");
        }
    }

    public static enum OperaType {
        GET("FROM "),
        UPDATE("UPDATE "),
        DELETE("DELETE FROM "),
        SELECT("SELECT %s FROM ");

        private final String value;

        private OperaType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

