/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.support;

import com.huawei.csr.framework.common.model.PageQuery;
import com.huawei.csr.framework.dao.support.QueryField;
import com.huawei.csr.framework.dao.support.SqlSentence;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.query.Query;

public class ConditionManager {
    private boolean isPage;
    private int marker;
    private int limit;
    private List<QueryField<?, ?>> fieldList;
    private int positionIndex;
    private String queryKey = SqlSentence.WHERE.getValue();
    private String queryType = SqlSentence.AND.getValue();

    public ConditionManager() {
        this(0, null);
    }

    public <T extends PageQuery> ConditionManager(T pageQuery) {
        this(0, pageQuery);
    }

    public <T extends PageQuery> ConditionManager(int index, T pageQuery) {
        this.fieldList = new ArrayList();
        this.positionIndex = index;
        if (pageQuery == null) {
            return;
        }
        this.isPage = pageQuery.isPage();
        if (this.isPage) {
            this.marker = pageQuery.getMarker();
            this.limit = pageQuery.getLimit();
        }
    }

    public <K, T, R extends ConditionManager> R addQueryField(Class<K> dbCls, String dbFieldName, T dbFieldValue) {
        this.fieldList.add(new QueryField<K, T>(dbCls, dbFieldName, dbFieldValue));
        return (R)this;
    }

    public <K, T, R extends ConditionManager> R addQueryField(Class<K> dbCls, String dbFieldName, T dbFieldValue, String relationType) {
        this.fieldList.add(new QueryField<K, T>(dbCls, dbFieldName, dbFieldValue, relationType));
        return (R)this;
    }

    public <K, T, R extends ConditionManager> R addQueryField(QueryField<K, T> queryField) {
        this.fieldList.add(queryField);
        return (R)this;
    }

    public <K, T, R extends ConditionManager> R addNotNullQueryField(Class<K> dbCls, String dbFieldName, T dbFieldValue) {
        if (dbFieldValue != null) {
            this.fieldList.add(new QueryField<K, T>(dbCls, dbFieldName, dbFieldValue));
        }
        return (R)this;
    }

    public <K, T, R extends ConditionManager> R addNotNullQueryField(Class<K> dbCls, String dbFieldName, T dbFieldValue, String relationType) {
        if (dbFieldValue != null) {
            this.fieldList.add(new QueryField<K, T>(dbCls, dbFieldName, dbFieldValue, relationType));
        }
        return (R)this;
    }

    public <K, T, R extends ConditionManager> R addNotNullQueryField(QueryField<K, T> queryField) {
        if (queryField.getDbFieldValue() != null) {
            this.fieldList.add(queryField);
        }
        return (R)this;
    }

    public String getQuerySentence() {
        return this.getQuerySentence(this.queryKey, this.queryType);
    }

    public String getQuerySentence(String qtype) {
        return this.getQuerySentence(this.queryKey, qtype);
    }

    public String getQuerySentence(String qkey, String qtype) {
        if (StringUtils.isEmpty((CharSequence)qkey) || StringUtils.isEmpty((CharSequence)qtype) || VerifyUtil.isEmpty(this.fieldList)) {
            return "";
        }
        String queryTypeStr = qtype;
        if (SqlSentence.AND.getValue().equals(qtype) || SqlSentence.OR.getValue().equals(qtype)) {
            queryTypeStr = this.addBlank(qtype);
        }
        StringBuilder queryConditionSt = new StringBuilder();
        for (QueryField<?, ?> field : this.fieldList) {
            String quesValue = this.getPlaceholderStr();
            if (queryConditionSt.length() > 0) {
                if (field.getQueryType() != null) {
                    queryConditionSt.append(this.addBlank(field.getQueryType()));
                } else {
                    queryConditionSt.append(queryTypeStr);
                }
            }
            queryConditionSt.append(field.getDbCls().getSimpleName()).append(".").append(field.getDbFieldName()).append(field.getRelationTypeWithBlank()).append(quesValue);
        }
        return queryConditionSt.insert(0, this.addBlank(qkey)).toString();
    }

    private String getPlaceholderStr() {
        return SqlSentence.QUES.getValue();
    }

    public int setQueryParams(Query<?> query) {
        for (QueryField<?, ?> field : this.fieldList) {
            query.setParameter(this.positionIndex, field.getDbFieldValue());
            ++this.positionIndex;
        }
        return this.positionIndex;
    }

    private String addBlank(String st) {
        return SqlSentence.BLANK.getValue() + st + SqlSentence.BLANK.getValue();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true, (boolean)true);
    }

    public boolean isPage() {
        return this.isPage;
    }

    public void setPage(boolean page) {
        this.isPage = page;
    }

    public int getMarker() {
        return this.marker;
    }

    public void setMarker(int marker) {
        this.marker = marker;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getPositionIndex() {
        return this.positionIndex;
    }

    public void setPositionIndex(int positionIndex) {
        this.positionIndex = positionIndex;
    }

    public String getQueryKey() {
        return this.queryKey;
    }

    public void setQueryKey(String queryKey) {
        this.queryKey = queryKey;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }
}

