/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.support;

import com.huawei.csr.framework.dao.support.SqlSentence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class JoinField {
    private static final String DEFAULT_TYPE = " " + SqlSentence.JOIN.getValue() + " ";
    private Class<?> joinTable;
    private Class<?> joinedTable;
    private List<Pair> pairs = new ArrayList<Pair>();
    private String joinType;

    public JoinField(Class<?> joinTable, Class<?> joinedTable) {
        this(joinTable, joinedTable, new ArrayList<Pair>(), DEFAULT_TYPE);
    }

    public JoinField(Class<?> joinTable, Class<?> joinedTable, String joinType) {
        this(joinTable, joinedTable, new ArrayList<Pair>(), joinType);
    }

    public JoinField(Class<?> joinTable, Class<?> joinedTable, Pair pair) {
        this(joinTable, joinedTable, new ArrayList<Pair>(Collections.singletonList(pair)), DEFAULT_TYPE);
    }

    public JoinField(Class<?> joinTable, Class<?> joinedTable, Pair pair, String joinType) {
        this(joinTable, joinedTable, new ArrayList<Pair>(Collections.singletonList(pair)), joinType);
    }

    public JoinField(Class<?> joinTable, Class<?> joinedTable, List<Pair> pairs) {
        this(joinTable, joinedTable, pairs, DEFAULT_TYPE);
    }

    public JoinField(Class<?> joinTable, Class<?> joinedTable, List<Pair> pairs, String joinType) {
        this.joinTable = joinTable;
        this.joinedTable = joinedTable;
        this.pairs = pairs;
        this.joinType = joinType;
    }

    public JoinField addPair(Pair pair) {
        this.pairs.add(pair);
        return this;
    }

    public List<Pair> getPairs() {
        return this.pairs;
    }

    public void setPairs(List<Pair> pairs) {
        this.pairs = pairs;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true, (boolean)true);
    }

    public Class<?> getJoinTable() {
        return this.joinTable;
    }

    public void setJoinTable(Class<?> joinTable) {
        this.joinTable = joinTable;
    }

    public Class<?> getJoinedTable() {
        return this.joinedTable;
    }

    public void setJoinedTable(Class<?> joinedTable) {
        this.joinedTable = joinedTable;
    }

    public String getJoinType() {
        return this.joinType;
    }

    public void setJoinType(String joinType) {
        this.joinType = joinType;
    }

    public static class Pair {
        private String joinFieldName;
        private String joinedFieldName;

        public Pair(String joinFieldName, String joinedFieldName) {
            this.joinFieldName = joinFieldName;
            this.joinedFieldName = joinedFieldName;
        }

        public String toString() {
            return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true, (boolean)true);
        }

        public String getJoinFieldName() {
            return this.joinFieldName;
        }

        public void setJoinFieldName(String joinFieldName) {
            this.joinFieldName = joinFieldName;
        }

        public String getJoinedFieldName() {
            return this.joinedFieldName;
        }

        public void setJoinedFieldName(String joinedFieldName) {
            this.joinedFieldName = joinedFieldName;
        }
    }
}

