/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.support;

import com.huawei.csr.framework.dao.support.JoinField;
import com.huawei.csr.framework.dao.support.SqlSentence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class JoinManager {
    private List<JoinField> joinFields = new ArrayList<JoinField>();

    public JoinManager() {
        this(new ArrayList<JoinField>());
    }

    public JoinManager(JoinField joinField) {
        this(new ArrayList<JoinField>(Collections.singletonList(joinField)));
    }

    public JoinManager(List<JoinField> joinFields) {
        this.joinFields = joinFields;
    }

    public JoinManager addJoinField(JoinField joinField) {
        this.joinFields.add(joinField);
        return this;
    }

    public String getJoin() {
        if (this.joinFields.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (JoinField joinField : this.joinFields) {
            builder.append(joinField.getJoinType()).append(joinField.getJoinedTable().getSimpleName()).append(SqlSentence.BLANK.getValue()).append(joinField.getJoinedTable().getSimpleName()).append(SqlSentence.BLANK.getValue()).append(SqlSentence.ON.getValue()).append(SqlSentence.BLANK.getValue());
            for (int index = 0; index < joinField.getPairs().size(); ++index) {
                if (index != 0) {
                    builder.append(SqlSentence.BLANK.getValue()).append(SqlSentence.AND.getValue()).append(SqlSentence.BLANK.getValue());
                }
                builder.append(joinField.getJoinTable().getSimpleName()).append('.').append(joinField.getPairs().get(index).getJoinFieldName()).append(SqlSentence.EQUAL.getValue()).append(joinField.getJoinedTable().getSimpleName()).append('.').append(joinField.getPairs().get(index).getJoinedFieldName());
            }
        }
        return builder.toString();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true, (boolean)true);
    }

    public List<JoinField> getJoinFields() {
        return this.joinFields;
    }

    public void setJoinFields(List<JoinField> joinFields) {
        this.joinFields = joinFields;
    }
}

