/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.dao.support;

import com.huawei.csr.framework.dao.support.QueryField;
import com.huawei.csr.framework.dao.support.SqlSentence;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class OrderManager {
    private final List<QueryField<?, ?>> orderFields;

    public OrderManager() {
        this(new ArrayList());
    }

    public OrderManager(List<QueryField<?, ?>> fieldList) {
        this.orderFields = fieldList;
    }

    public String getOrderBy() {
        if (this.orderFields.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(SqlSentence.BLANK.getValue()).append(SqlSentence.ORDER_BY.getValue()).append(SqlSentence.BLANK.getValue());
        for (int index = 0; index < this.orderFields.size(); ++index) {
            QueryField<?, ?> field = this.orderFields.get(index);
            builder.append(field.getDbCls().getSimpleName()).append(".").append(field.getDbFieldName()).append(SqlSentence.BLANK.getValue()).append(field.getDbFieldValue());
            if (index >= this.orderFields.size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)true, (boolean)true);
    }

    public <K> OrderManager addOrderField(Class<K> dbCls, String dbFieldName, boolean isAsc) {
        this.orderFields.add(new QueryField<K, String>(dbCls, dbFieldName, isAsc ? "ASC" : "DESC"));
        return this;
    }

    public <K> OrderManager addOrderField(Class<K> dbCls, String dbFieldName) {
        this.addOrderField(dbCls, dbFieldName, false);
        return this;
    }
}

