/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.license;

import com.huawei.csr.framework.core.event.entity.AppEventEntity;
import com.huawei.csr.framework.core.event.listener.BaseEventListener;
import com.huawei.csr.framework.core.event.objects.AppEvent;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.license.BaseLicenseCheck;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class LicenseAppCreateListener
extends BaseLicenseCheck
implements BaseEventListener<AppEvent> {
    private static final Log logger = LogFactory.getInstance(LicenseAppCreateListener.class);

    @Override
    public boolean supportEvent(AppEvent event) {
        return AppEvent.EventType.CREATE_APP.equals((Object)event.getEventType());
    }

    @Override
    public void onBefore(AppEvent event) {
        AppEventEntity eventEntity = (AppEventEntity)event.getSource();
        if (VerifyUtil.isEmpty((Object)eventEntity)) {
            logger.info((Object)"EventEntity is null.");
            return;
        }
        Application application = eventEntity.getApplication();
        int serviceNum = application.getServiceInstances().size();
        this.getLicenseCheckService().calcLicense("LSTQARK", serviceNum);
    }

    @Override
    public void onException(AppEvent event) {
        this.getLicenseCheckService().noticeTaskError();
    }

    @Override
    public void onFinal(AppEvent event) {
        this.getLicenseCheckService().noticeTaskSuccess();
    }
}

