/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.meter;

import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.meter.service.MeterBuilder;
import com.huawei.om.meter.service.model.ResourceMeterData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class ApplicationMeterBuilder
implements MeterBuilder {
    private static final Log logger = LogFactory.getInstance(ApplicationMeterBuilder.class);
    public static final String METER_DATE_FORMAT = "yyyyMMddHHmmss";
    private final Application application;

    public ApplicationMeterBuilder(Application application) {
        this.application = application;
    }

    public ResourceMeterData build() {
        logger.debug((Object)"Start build resourceMeterData.");
        ResourceMeterData meterData = new ResourceMeterData();
        meterData.setProjectId(this.application.getProjectId());
        meterData.setResourceType("ark");
        meterData.setResourceId(this.application.getId());
        meterData.setResourceName(this.application.getName());
        meterData.setRecordTime(this.getReportTime());
        Map<String, Double> valueMap = this.buildInstanceCountValue();
        ArrayList<ResourceMeterData.ResourceMeterValue> meterValueList = new ArrayList<ResourceMeterData.ResourceMeterValue>();
        for (Map.Entry<String, Double> entry : valueMap.entrySet()) {
            ResourceMeterData.ResourceMeterValue instanceCountValue = new ResourceMeterData.ResourceMeterValue();
            instanceCountValue.setRegionId(entry.getKey());
            instanceCountValue.setType("ark.ins");
            instanceCountValue.setValue(entry.getValue());
            meterValueList.add(instanceCountValue);
            ResourceMeterData.ResourceMeterValue appCountValue = new ResourceMeterData.ResourceMeterValue();
            appCountValue.setRegionId(entry.getKey());
            appCountValue.setType("ark.app");
            appCountValue.setValue(Double.valueOf(1.0));
            meterValueList.add(appCountValue);
        }
        meterData.setMeterValueList(meterValueList);
        return meterData;
    }

    private Map<String, Double> buildInstanceCountValue() {
        HashMap<String, Double> valueMap = new HashMap<String, Double>();
        for (AppServiceInstance serviceInstance : this.application.getServiceInstances()) {
            String drRegionId;
            String pdRegionId = serviceInstance.getPdRegionId();
            if (!VerifyUtil.isEmpty((String)pdRegionId)) {
                Double value = valueMap.containsKey(pdRegionId) ? (Double)valueMap.get(pdRegionId) + 1.0 : 1.0;
                valueMap.put(pdRegionId, value);
            }
            if (VerifyUtil.isEmpty((String)(drRegionId = serviceInstance.getDrRegionId())) || drRegionId.equals(pdRegionId)) continue;
            Double value = valueMap.containsKey(drRegionId) ? (Double)valueMap.get(drRegionId) + 1.0 : 1.0;
            valueMap.put(drRegionId, value);
        }
        return valueMap;
    }

    private String getReportTime() {
        Calendar cal = Calendar.getInstance();
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        cal.add(14, -(zoneOffset + dstOffset));
        return new SimpleDateFormat(METER_DATE_FORMAT).format(cal.getTime());
    }
}

