/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.meter;

import com.huawei.csr.framework.core.event.entity.AppEventEntity;
import com.huawei.csr.framework.core.event.listener.BaseEventListener;
import com.huawei.csr.framework.core.event.objects.AppEvent;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.meter.ApplicationMeterBuilder;
import com.huawei.csr.framework.service.AppService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.om.meter.service.MeterBuilder;
import com.huawei.om.meter.service.MeterService;
import java.util.HashMap;
import java.util.Map;

public class MeterUpdateAppListener
implements BaseEventListener<AppEvent> {
    private static final Log logger = LogFactory.getInstance(MeterUpdateAppListener.class);
    private static final Map<AppEvent.EventType, String> EVENT_RECORD_MAP = new HashMap<AppEvent.EventType, String>();

    @Override
    public boolean supportEvent(AppEvent event) {
        return event.getEventType().equals((Object)AppEvent.EventType.ADD_INSTANCES) || event.getEventType().equals((Object)AppEvent.EventType.REMOVE_INSTANCES) || event.getEventType().equals((Object)AppEvent.EventType.CREATE_APP) || event.getEventType().equals((Object)AppEvent.EventType.REFRESH_APP);
    }

    @Override
    public void onAfter(AppEvent event) {
        logger.debug((Object)"Start meter updateApp.");
        AppEventEntity eventEntity = (AppEventEntity)event.getSource();
        Application application = eventEntity.getApplication();
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        Application applicationInDB = appService.getApplicationById(application.getId());
        MeterService meterService = (MeterService)ServiceLocator.getInstance().getService(MeterService.class);
        meterService.recordMeterInfo((MeterBuilder)new ApplicationMeterBuilder(applicationInDB), EVENT_RECORD_MAP.get((Object)event.getEventType()));
    }

    static {
        EVENT_RECORD_MAP.put(AppEvent.EventType.CREATE_APP, "meter_create");
        EVENT_RECORD_MAP.put(AppEvent.EventType.ADD_INSTANCES, "meter_update");
        EVENT_RECORD_MAP.put(AppEvent.EventType.REMOVE_INSTANCES, "meter_update");
        EVENT_RECORD_MAP.put(AppEvent.EventType.REFRESH_APP, "meter_update");
    }
}

