/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.service.impl;

import com.huawei.csr.framework.checker.AppChecker;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.ApplicationBo;
import com.huawei.csr.framework.common.model.ApplicationQuery;
import com.huawei.csr.framework.common.model.InstanceObjectQuery;
import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.model.ServiceInstanceQuery;
import com.huawei.csr.framework.common.model.TopoLinkQuery;
import com.huawei.csr.framework.common.model.TopoNodeQuery;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.common.operationtask.OperationTaskManager;
import com.huawei.csr.framework.common.operationtask.app.AddServiceInstancesTask;
import com.huawei.csr.framework.common.operationtask.app.CreateAppTask;
import com.huawei.csr.framework.common.operationtask.app.DeleteAppTask;
import com.huawei.csr.framework.common.operationtask.app.RefreshAppTask;
import com.huawei.csr.framework.common.operationtask.app.RemoveServiceInstancesTask;
import com.huawei.csr.framework.common.statusopt.status.AppStatus;
import com.huawei.csr.framework.common.utils.AppServiceUtil;
import com.huawei.csr.framework.common.utils.CollectionHelper;
import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.common.utils.ResourceClearUtil;
import com.huawei.csr.framework.core.context.RequestContext;
import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AppPluginManager;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.InstanceObjectDao;
import com.huawei.csr.framework.dao.RecoverFlowDao;
import com.huawei.csr.framework.dao.RecoverStepDao;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.TopoLinkDao;
import com.huawei.csr.framework.dao.TopoNodeDao;
import com.huawei.csr.framework.dao.model.AbstractEntity;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.InstanceObject;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.dao.model.TopoLink;
import com.huawei.csr.framework.dao.model.TopoNode;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.ConfigService;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.topo.build.TopoSourceType;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service(Name="com.huawei.csr.framework.service.AppService", Interface=AppService.class, Desc="")
public class AppServiceImpl
extends BaseService
implements AppService {
    private static final Log logger = LogFactory.getInstance(AppServiceImpl.class);
    private static final Set<String> USER_TOPO_LINK_CONSTRAINT = new HashSet<String>();
    private ApplicationDao applicationDao;
    private ServiceInstanceDao serviceInstanceDao;
    private InstanceObjectDao instanceObjectDao;
    private RecoverFlowDao recoverFlowDao;
    private TopoLinkDao topoLinkDao;
    private TopoNodeDao topoNodeDao;
    private RecoverStepDao recoverStepDao;

    @Override
    public String createApp(String subId, RequestContext context, Application application) {
        logger.debug((Object)"Start create app(%s).", new Object[]{application.getName()});
        BackTask backTaskModel = AppServiceUtil.buildBackupTaskModel(context.getProjectId(), application.getName(), "operation.task.create.app");
        Credential credential = new Credential(context.getProjectId(), context.getAuthToken(), null);
        CreateAppTask createAppTask = new CreateAppTask(backTaskModel, subId, application, credential);
        long taskId = OperationTaskManager.submitTask(createAppTask);
        logger.debug((Object)"Submit create app(%s) success,taskId(%s).", new Object[]{application.getName(), taskId});
        return String.valueOf(taskId);
    }

    @Override
    public Pair<List<AppServiceInstance>, Integer> queryUnprotectedInstanceList(RequestContext context, ServiceInstanceFilter instanceFilter) {
        Pair pair;
        String endpoint = null;
        try {
            endpoint = EndpointUtil.getEndpoint(instanceFilter.getServiceType().getValue(), instanceFilter.getPdRegionId());
        }
        catch (Exception err) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)err));
            return Pair.of(Collections.emptyList(), (Object)0);
        }
        Credential credential = new Credential(context.getProjectId(), context.getAuthToken(), endpoint);
        try {
            List<AppServiceInstance> serviceInstances = AppPluginManager.getInstance().getAppManager(new AppIdentifier(instanceFilter.getServiceType().getValue())).canProtectServiceInstances(instanceFilter, credential);
            List filteredServiceInstances = serviceInstances.stream().filter(serviceInstance -> {
                ServiceInstanceQuery query = new ServiceInstanceQuery();
                query.setProjectId(context.getProjectId());
                query.setInstanceId(serviceInstance.getInstanceId());
                long count = this.getServiceInstanceCount(query);
                return count == 0L;
            }).collect(Collectors.toList());
            int size = filteredServiceInstances.size();
            pair = Pair.of(filteredServiceInstances, (Object)size);
        }
        catch (Exception err) {
            logger.error((Object)"Query service(%s) instances failed, err msg: %s", new Object[]{instanceFilter.getServiceType(), ExceptionUtil.getErrorMessage((Throwable)err)});
            throw new LegoCheckedException(1073952007L, new String[]{instanceFilter.getInstanceName()});
        }
        return pair;
    }

    @Override
    public String refreshApp(RequestContext context, String appId) {
        logger.debug((Object)"Start refresh app(%s).", new Object[]{appId});
        Application app = this.getApplicationById(appId);
        AppChecker.checkAppCanRefresh(app);
        BackTask backTaskModel = AppServiceUtil.buildBackupTaskModel(context.getProjectId(), app.getName(), "operation.task.refresh.app");
        Credential credential = new Credential(context.getProjectId(), context.getAuthToken(), null);
        RefreshAppTask refreshAppTask = new RefreshAppTask(backTaskModel, app, credential);
        long taskId = OperationTaskManager.submitTask(refreshAppTask);
        logger.debug((Object)"End refresh app(%s), taskId(%s).", new Object[]{appId, taskId});
        return String.valueOf(taskId);
    }

    @Override
    public Integer getAppCountByName(String name) {
        if (VerifyUtil.isEmpty((String)name)) {
            return 0;
        }
        ApplicationQuery query = new ApplicationQuery();
        query.setName(name);
        return this.applicationDao.getAppCountByName(query);
    }

    @Override
    public String addServiceInstances(String subId, RequestContext context, Set<AppServiceInstance> serviceInstances, String appId) {
        logger.debug((Object)"Start addServiceInstances, appId(%s).", new Object[]{appId});
        Application app = this.getApplicationById(appId);
        BackTask backTaskModel = AppServiceUtil.buildBackupTaskModel(context.getProjectId(), app.getName(), "operation.task.app.add.instances");
        Credential credential = new Credential(context.getProjectId(), context.getAuthToken(), null);
        AddServiceInstancesTask addServiceInstancesTask = new AddServiceInstancesTask(backTaskModel, serviceInstances, credential, app, subId);
        long taskId = OperationTaskManager.submitTask(addServiceInstancesTask);
        logger.debug((Object)"End addServiceInstances, appId(%s), taskId(%s).", new Object[]{appId, taskId});
        return String.valueOf(taskId);
    }

    @Override
    public String removeServiceInstances(String subId, RequestContext context, Set<String> serviceInstanceIds, String appId) {
        logger.debug((Object)"Start removeServiceInstances, appId(%s).", new Object[]{appId});
        Application application = this.getApplicationById(appId);
        BackTask backTaskModel = AppServiceUtil.buildBackupTaskModel(context.getProjectId(), application.getName(), "operation.task.app.del.instances");
        Credential credential = new Credential(context.getProjectId(), context.getAuthToken(), null);
        RemoveServiceInstancesTask removeServiceInstancesTask = new RemoveServiceInstancesTask(backTaskModel, serviceInstanceIds, application, subId, credential);
        long taskId = OperationTaskManager.submitTask(removeServiceInstancesTask);
        logger.debug((Object)"End removeServiceInstances, appId(%s), taskId(%s).", new Object[]{appId, taskId});
        return String.valueOf(taskId);
    }

    @Override
    public String deleteApp(String subId, RequestContext context, String appId) {
        logger.debug((Object)"Start deleteApp, appId(%s).", new Object[]{appId});
        Application application = this.getApplicationById(appId);
        BackTask backTaskModel = AppServiceUtil.buildBackupTaskModel(context.getProjectId(), application.getName(), "operation.task.delete.app");
        Credential credential = new Credential(context.getProjectId(), context.getAuthToken(), null);
        DeleteAppTask deleteAppTask = new DeleteAppTask(backTaskModel, appId, subId, credential);
        String taskId = String.valueOf(OperationTaskManager.submitTask(deleteAppTask));
        logger.debug((Object)"End removeServiceInstances, appId(%s), taskId(%s).", new Object[]{appId, taskId});
        return taskId;
    }

    @Override
    public long getAppCountByRecoverPlanAndSiteId(String projectId, String recoverPlanId, String siteId) {
        if (VerifyUtil.isEmpty((String)recoverPlanId)) {
            throw new LegoCheckedException(1073952400L);
        }
        List<Application> appList = this.applicationDao.getAppListByRecoverPlanId(projectId, recoverPlanId);
        long count = 0L;
        block0: for (Application app : appList) {
            for (AppServiceInstance instance : app.getServiceInstances()) {
                if (VerifyUtil.isEmpty((Object)instance) || !siteId.equals(instance.getPdSiteId()) && !siteId.equals(instance.getDrSiteId())) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    @Override
    public List<Application> getApplicationListByPlanId(String projectId, String recoverPlanId) {
        if (VerifyUtil.isEmpty((String)recoverPlanId) || VerifyUtil.isEmpty((String)projectId)) {
            throw new LegoCheckedException(1073952400L);
        }
        return this.applicationDao.getAppByRecoverPlanId(projectId, recoverPlanId);
    }

    @Override
    public Application getApplicationById(String id) {
        if (VerifyUtil.isEmpty((String)id)) {
            throw new LegoCheckedException(1073952400L);
        }
        return this.applicationDao.getApp(id);
    }

    @Override
    public long getServiceInstanceCount(ServiceInstanceQuery query) {
        return this.serviceInstanceDao.getServiceInstanceCount(query).intValue();
    }

    @Override
    public long getServiceInstanceCountByAppId(String appId) {
        return this.serviceInstanceDao.getServiceInstanceCountByAppId(appId);
    }

    @Override
    public Pair<List<ApplicationBo>, Integer> queryApps(ApplicationQuery appQuery) {
        if (VerifyUtil.isEmpty((String)appQuery.getProjectId())) {
            throw new LegoCheckedException(1073952400L);
        }
        List<Application> appList = this.applicationDao.getAppList(appQuery);
        int totalCount = this.applicationDao.getAppCountByQuery(appQuery);
        List<ApplicationBo> rstList = appList.stream().map(this::convertAppToAppBo).collect(Collectors.toList());
        this.adjustAppList(rstList, appQuery.getFlowId(), appQuery.getMarker());
        if (!VerifyUtil.isEmpty((String)appQuery.getFlowId())) {
            ++totalCount;
        }
        return Pair.of(rstList, (Object)totalCount);
    }

    private void adjustAppList(List<ApplicationBo> rstList, String flowId, int marker) {
        if (VerifyUtil.isEmpty((String)flowId) || marker != 0) {
            return;
        }
        RecoverFlow recoverFlow = this.recoverFlowDao.getRecoverFlowById(flowId);
        if (VerifyUtil.isEmpty((Object)recoverFlow)) {
            logger.error((Object)"Query recoverFlow(%s) is null.", new Object[]{flowId});
            return;
        }
        String appId = recoverFlow.getAppId();
        Application applicationById = this.getApplicationById(appId);
        rstList.add(0, this.convertAppToAppBo(applicationById));
    }

    @Override
    public List<ApplicationBo> queryNotInPreplanApplicationList(ApplicationQuery query) {
        if (VerifyUtil.isEmpty((Object)query) || VerifyUtil.isEmpty((String)query.getPrePlanId())) {
            logger.error((Object)"applicationQuery or preplanId is empty or null.");
            throw new LegoCheckedException(1073952400L);
        }
        List<Application> allAppList = this.applicationDao.getAppList(query);
        if (query.getBelongPreplan() != null) {
            List<Application> existAppList = this.applicationDao.queryAppListInPreplan(query.getPrePlanId());
            allAppList = query.getBelongPreplan() != false ? CollectionHelper.of(allAppList).intersect(existAppList).keyProvider(AbstractEntity::getId).collect(Collectors.toList()) : CollectionHelper.of(allAppList).subtract(existAppList).keyProvider(AbstractEntity::getId).collect(Collectors.toList());
        }
        ArrayList<ApplicationBo> rstList = new ArrayList<ApplicationBo>();
        for (Application app : allAppList) {
            ApplicationBo bo = this.convertAppToAppBo(app);
            rstList.add(bo);
        }
        return rstList;
    }

    private ApplicationBo convertAppToAppBo(Application app) {
        ApplicationBo bo = new ApplicationBo(app.getProjectId(), app.getId());
        bo.setCreatedAt(app.getCreatedAt());
        bo.setUpdatedAt(app.getUpdatedAt());
        bo.setDeletedAt(app.getDeletedAt());
        bo.setCreateType(app.getCreateType());
        bo.setStatus(app.getStatus());
        bo.setRecoverPlanId(app.getRecoverPlanId());
        bo.setApplicationName(app.getName());
        bo.setApplicationDesc(app.getDescription());
        bo.setServiceInstances(app.getServiceInstances());
        bo.setSiteInfoList(this.getSiteInfoList(app));
        return bo;
    }

    private List<SiteInfo> getSiteInfoList(Application app) {
        if (VerifyUtil.isEmpty(app.getServiceInstances())) {
            return Collections.emptyList();
        }
        return app.getServiceInstances().stream().sorted(Comparator.comparing(AbstractEntity::getCreatedAt).reversed()).flatMap(instance -> this.getSiteInfoList((AppServiceInstance)instance).stream()).distinct().collect(Collectors.toList());
    }

    private List<SiteInfo> getSiteInfoList(AppServiceInstance serviceInstance) {
        if (VerifyUtil.isEmpty((Object)serviceInstance)) {
            logger.error((Object)"ServiceInstance(null) getSiteInfoList failed.");
            return Collections.emptyList();
        }
        ConfigService configService = (ConfigService)ServiceLocator.getInstance().getService(ConfigService.class);
        SiteInfo pdSiteInfo = null;
        if (!VerifyUtil.isEmpty((String)serviceInstance.getPdSiteId())) {
            pdSiteInfo = configService.getSiteInfoByRegionAz(serviceInstance.getPdRegionId(), serviceInstance.getPdAzId());
        }
        SiteInfo drSiteInfo = null;
        if (!VerifyUtil.isEmpty((String)serviceInstance.getDrSiteId())) {
            drSiteInfo = configService.getSiteInfoByRegionAz(serviceInstance.getDrRegionId(), serviceInstance.getDrAzId());
        }
        ArrayList<SiteInfo> siteInfoList = new ArrayList<SiteInfo>();
        if (!VerifyUtil.isEmpty((Object)pdSiteInfo)) {
            siteInfoList.add(pdSiteInfo);
        }
        if (!VerifyUtil.isEmpty((Object)drSiteInfo)) {
            siteInfoList.add(drSiteInfo);
        }
        return siteInfoList;
    }

    @Override
    public List<AppServiceInstance> queryNotInPreplanInstanceList(String appId, String preplanId, String siteId) {
        if (VerifyUtil.isEmpty((String)appId) || VerifyUtil.isEmpty((String)preplanId) || VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)"AppId or preplanId or siteId is empty or null.");
            throw new LegoCheckedException(1073952400L);
        }
        List<AppServiceInstance> allInstanceList = this.serviceInstanceDao.getServiceInstanceByAppId(appId);
        allInstanceList.removeIf(instance -> !siteId.equals(instance.getPdSiteId()) && !siteId.equals(instance.getDrSiteId()));
        List<AppServiceInstance> existInstanceList = this.serviceInstanceDao.queryInstanceListInPreplan(appId, preplanId);
        return CollectionHelper.of(allInstanceList).subtract(existInstanceList).keyProvider(AbstractEntity::getId).collect(Collectors.toList());
    }

    @Override
    public List<AppServiceInstance> queryNotInFlowInstanceList(ServiceInstanceQuery instanceQuery) {
        if (VerifyUtil.isEmpty((Object)instanceQuery) || VerifyUtil.isEmpty((String)instanceQuery.getFlowId()) || VerifyUtil.isEmpty((String)instanceQuery.getProjectId())) {
            logger.error((Object)"InstanceQuery or flowId or projectId is empty or null.");
            throw new LegoCheckedException(1073952400L);
        }
        RecoverFlow recoverFlow = ((RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class)).getRecoverFlowById(instanceQuery.getFlowId());
        instanceQuery.setAppId(recoverFlow.getAppId());
        List<AppServiceInstance> allInstanceList = this.serviceInstanceDao.getServiceInstanceList(instanceQuery);
        allInstanceList.removeIf(instance -> ServiceType.ELB.getValue().equals(instance.getServiceType()));
        Set<String> siteIdSet = ((RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class)).queryPreplansSiteByFlowId(instanceQuery.getFlowId());
        if (siteIdSet.size() > 0) {
            allInstanceList.removeIf(instance -> !siteIdSet.contains(instance.getPdSiteId()) && !siteIdSet.contains(instance.getDrSiteId()));
        }
        List<AppServiceInstance> existInstanceList = this.serviceInstanceDao.queryInstanceListInFlow(instanceQuery.getFlowId());
        return CollectionHelper.of(allInstanceList).subtract(existInstanceList).keyProvider(AbstractEntity::getId).collect(Collectors.toList());
    }

    @Override
    public ApplicationBo queryApp(String appId, String projectId) {
        if (VerifyUtil.isEmpty((String)appId) || VerifyUtil.isEmpty((String)projectId)) {
            throw new LegoCheckedException(1073952400L);
        }
        return this.convertAppToAppBo(this.applicationDao.getApp(appId, projectId));
    }

    @Override
    public Pair<List<AppServiceInstance>, Integer> queryProtectedInstances(ServiceInstanceQuery serviceInstanceQuery) {
        if (VerifyUtil.isEmpty((String)serviceInstanceQuery.getAppId()) || VerifyUtil.isEmpty((String)serviceInstanceQuery.getProjectId())) {
            throw new LegoCheckedException(1073952400L);
        }
        return Pair.of(this.serviceInstanceDao.getServiceInstanceList(serviceInstanceQuery), (Object)this.serviceInstanceDao.getServiceInstanceCount(serviceInstanceQuery));
    }

    @Override
    public Pair<List<InstanceObject>, Long> queryProtectedObjects(InstanceObjectQuery instanceObjectQuery) {
        if (VerifyUtil.isEmpty((String)instanceObjectQuery.getInstanceId()) || VerifyUtil.isEmpty((String)instanceObjectQuery.getAppId())) {
            throw new LegoCheckedException(1073952400L);
        }
        return Pair.of(this.instanceObjectDao.queryInstanceObjects(instanceObjectQuery), (Object)this.instanceObjectDao.getInstanceObjectsCount(instanceObjectQuery));
    }

    @Override
    public AppServiceInstance queryProtectedInstance(ServiceInstanceQuery query) {
        if (VerifyUtil.isEmpty((String)query.getInstanceId()) || VerifyUtil.isEmpty((String)query.getAppId()) || VerifyUtil.isEmpty((String)query.getProjectId())) {
            throw new LegoCheckedException(1073952400L);
        }
        return this.serviceInstanceDao.getServiceInstanceByQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Application updateApp(ApplicationBo bo) {
        AppChecker.checkUpdateApp(bo);
        String status = this.getApplicationById(bo.getApplicationId()).getStatus();
        try {
            this.applicationDao.updateAppStatus(bo.getApplicationId(), AppStatus.LOCKED.getValue());
            Application app = new Application();
            app.setProjectId(bo.getProjectId());
            app.setName(bo.getApplicationName());
            app.setId(bo.getApplicationId());
            app.setDescription(bo.getApplicationDesc());
            this.applicationDao.updateAppInfo(app);
            Application application = app;
            return application;
        }
        finally {
            this.applicationDao.updateAppStatus(bo.getApplicationId(), status);
        }
    }

    @Override
    public List<TopoLink> queryTopoLinks(TopoLinkQuery query) {
        return this.topoLinkDao.queryTopoLinks(query);
    }

    @Override
    public boolean createTopoLink(TopoLink topoLink) {
        if (this.queryExistLink(topoLink).isPresent()) {
            return false;
        }
        String sourceType = this.queryTopoNode(topoLink.getSourceId()).getNodeType();
        String targetType = this.queryTopoNode(topoLink.getTargetId()).getNodeType();
        if (topoLink.isUserOpt() && !USER_TOPO_LINK_CONSTRAINT.contains(sourceType + targetType) && !USER_TOPO_LINK_CONSTRAINT.contains(targetType + sourceType)) {
            return false;
        }
        this.topoLinkDao.createTopoLink(topoLink);
        return true;
    }

    @Override
    public boolean deleteTopoLink(TopoLink topoLink) {
        Optional<TopoLink> optional = this.queryExistLink(topoLink);
        optional.ifPresent(this.topoLinkDao::deleteTopoLink);
        return optional.isPresent();
    }

    @Override
    public List<Application> getAllApplications() {
        return this.applicationDao.getAllApplications();
    }

    @Override
    public List<AppServiceInstance> getServiceInstanceListByRegionAz(String pdRegionId, String pdAzId, String drRegionId, String drAzId) {
        return this.serviceInstanceDao.getServiceInstanceListByRegionAz(pdRegionId, pdAzId, drRegionId, drAzId);
    }

    @Override
    public Pair<List<AppServiceInstance>, Integer> queryCanStepProtectedInstances(ServiceInstanceQuery query) {
        if (VerifyUtil.isEmpty((String)query.getProjectId())) {
            throw new LegoCheckedException(1073952400L);
        }
        RecoverStep recoverStep = null;
        if (!VerifyUtil.isEmpty((String)query.getStepId())) {
            recoverStep = this.recoverStepDao.queryRecoverStepById(query.getStepId());
        }
        this.adjustMarkerAndLimit(query, recoverStep);
        List<AppServiceInstance> serviceInstances = this.serviceInstanceDao.getCanStepServiceInstanceList(query);
        int totalCount = this.serviceInstanceDao.getCanStepServiceInstanceCount(query);
        if (!VerifyUtil.isEmpty((String)query.getStepId()) && VerifyUtil.isEmpty(serviceInstances)) {
            serviceInstances = new ArrayList<AppServiceInstance>();
        }
        totalCount = this.adjustTotalCount(query, recoverStep, totalCount);
        this.adjustInstanceList(serviceInstances, query, recoverStep);
        return Pair.of(serviceInstances, (Object)totalCount);
    }

    private void adjustMarkerAndLimit(ServiceInstanceQuery query, RecoverStep recoverStep) {
        if (VerifyUtil.isEmpty((Object)recoverStep)) {
            return;
        }
        if (!VerifyUtil.isEmpty((String)query.getServiceType()) && !query.getServiceType().equals(recoverStep.getServiceType())) {
            return;
        }
        int marker = query.getMarker();
        int limit = query.getLimit();
        if (marker == 0) {
            query.setLimit(limit - 1);
        } else {
            query.setMarker(marker - 1);
        }
    }

    private int adjustTotalCount(ServiceInstanceQuery query, RecoverStep recoverStep, int totalCount) {
        if (VerifyUtil.isEmpty((Object)recoverStep)) {
            return totalCount;
        }
        if (!VerifyUtil.isEmpty((String)query.getServiceType()) && !query.getServiceType().equals(recoverStep.getServiceType())) {
            return totalCount;
        }
        return totalCount + 1;
    }

    private void adjustInstanceList(List<AppServiceInstance> serviceInstances, ServiceInstanceQuery query, RecoverStep recoverStep) {
        if (VerifyUtil.isEmpty((String)query.getStepId()) || query.getMarker() != 0) {
            return;
        }
        if (VerifyUtil.isEmpty((Object)recoverStep)) {
            logger.error((Object)"Query recoverStep(%s) is null.", new Object[]{query.getStepId()});
            return;
        }
        AppServiceInstance serviceInstanceById = this.serviceInstanceDao.getServiceInstanceById(recoverStep.getServiceInstanceId());
        if (!VerifyUtil.isEmpty((String)query.getServiceType()) && !query.getServiceType().equals(serviceInstanceById.getServiceType())) {
            return;
        }
        serviceInstances.add(0, serviceInstanceById);
    }

    private Optional<TopoLink> queryExistLink(TopoLink topoLink) {
        TopoLinkQuery query = new TopoLinkQuery();
        query.setProjectId(topoLink.getProjectId());
        query.setApplicationId(topoLink.getApplicationId());
        query.setSourceId(topoLink.getSourceId());
        query.setTargetId(topoLink.getTargetId());
        List<TopoLink> topoLinkList = this.queryTopoLinks(query);
        if (topoLinkList.size() > 0) {
            return Optional.of(topoLinkList.get(0));
        }
        query.setSourceId(topoLink.getTargetId());
        query.setTargetId(topoLink.getSourceId());
        topoLinkList = this.queryTopoLinks(query);
        if (topoLinkList.size() > 0) {
            return Optional.of(topoLinkList.get(0));
        }
        return Optional.empty();
    }

    @Override
    public List<TopoNode> queryTopoNodes(TopoNodeQuery query) {
        return this.topoNodeDao.queryTopoNodes(query);
    }

    @Override
    public TopoNode queryTopoNode(String nodeId) {
        return this.topoNodeDao.queryTopoNode(nodeId);
    }

    @Override
    public void createTopoNode(TopoNode topoNode) {
        this.topoNodeDao.createTopoNode(topoNode);
    }

    @Override
    public void clearAppTopoValue(String appId) {
        this.topoNodeDao.clearAppTopoNode(appId);
        this.topoLinkDao.clearAppTopoLink(appId);
    }

    @Override
    public void removeRelateSteps(final String projectId, final String id) {
        TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                RecoverStepQuery query = new RecoverStepQuery();
                query.setProjectId(projectId);
                query.setInstanceId(id);
                List<RecoverStep> recoverSteps = AppServiceImpl.this.recoverStepDao.queryRecoverStepList(query);
                if (!VerifyUtil.isEmpty(recoverSteps)) {
                    ResourceClearUtil.removeRecoverStepCascade(projectId, recoverSteps);
                }
            }
        });
    }

    @Override
    public int getAllAppCount() {
        return this.applicationDao.getAllAppCount();
    }

    @Override
    public int getAllServiceInstanceCount() {
        return this.serviceInstanceDao.getAllServiceInstanceCount();
    }

    public ApplicationDao getApplicationDao() {
        return this.applicationDao;
    }

    public void setApplicationDao(ApplicationDao applicationDao) {
        this.applicationDao = applicationDao;
    }

    public ServiceInstanceDao getServiceInstanceDao() {
        return this.serviceInstanceDao;
    }

    public void setServiceInstanceDao(ServiceInstanceDao serviceInstanceDao) {
        this.serviceInstanceDao = serviceInstanceDao;
    }

    public void setInstanceObjectDao(InstanceObjectDao instanceObjectDao) {
        this.instanceObjectDao = instanceObjectDao;
    }

    public void setTopoLinkDao(TopoLinkDao topoLinkDao) {
        this.topoLinkDao = topoLinkDao;
    }

    public void setTopoNodeDao(TopoNodeDao topoNodeDao) {
        this.topoNodeDao = topoNodeDao;
    }

    public RecoverStepDao getRecoverStepDao() {
        return this.recoverStepDao;
    }

    public void setRecoverStepDao(RecoverStepDao recoverStepDao) {
        this.recoverStepDao = recoverStepDao;
    }

    public void setRecoverFlowDao(RecoverFlowDao recoverFlowDao) {
        this.recoverFlowDao = recoverFlowDao;
    }

    static {
        USER_TOPO_LINK_CONSTRAINT.add(TopoSourceType.VM.getValue() + TopoSourceType.CCE.getValue());
        USER_TOPO_LINK_CONSTRAINT.add(TopoSourceType.VM.getValue() + TopoSourceType.ECS.getValue());
        USER_TOPO_LINK_CONSTRAINT.add(TopoSourceType.VM.getValue() + TopoSourceType.DCS.getValue());
        USER_TOPO_LINK_CONSTRAINT.add(TopoSourceType.VM.getValue() + TopoSourceType.RDS.getValue());
    }
}

