/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.service.impl;

import com.huawei.csr.framework.checker.ConfigChecker;
import com.huawei.csr.framework.dao.ServiceInfoDao;
import com.huawei.csr.framework.dao.SiteInfoDao;
import com.huawei.csr.framework.dao.SitePlanDao;
import com.huawei.csr.framework.dao.SitePlanMapDao;
import com.huawei.csr.framework.dao.impl.ServiceInfoDaoImpl;
import com.huawei.csr.framework.dao.impl.SiteInfoDaoImpl;
import com.huawei.csr.framework.dao.impl.SitePlanDaoImpl;
import com.huawei.csr.framework.dao.impl.SitePlanMapDaoImpl;
import com.huawei.csr.framework.dao.model.ServiceInfo;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.dao.model.SitePlan;
import com.huawei.csr.framework.dao.model.SitePlanMap;
import com.huawei.csr.framework.service.ConfigService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service(Name="com.huawei.csr.framework.service.ConfigService", Interface=ConfigService.class, Desc="")
public class ConfigServiceImpl
extends BaseService
implements ConfigService {
    private static final Log logger = LogFactory.getInstance(ConfigServiceImpl.class);
    private SiteInfoDao siteDao;
    private ServiceInfoDao serviceDao;
    private SitePlanMapDao sitePlanMapDao;
    private SitePlanDao sitePlanDao;

    @Override
    public void createSiteInfo(String siteName, List<SiteInfo> siteList) {
        logger.debug((Object)"Start create site(%s).", new Object[]{siteName});
        String siteId = UUIDGenerator.getUUID();
        siteList.forEach(site -> {
            site.setSiteName(siteName);
            site.setSiteId(siteId);
        });
        ConfigChecker.checkCreateSite(siteName, siteList);
        this.siteDao.save(siteList);
        logger.debug((Object)"End create site(%s).", new Object[]{siteName});
    }

    @Override
    public void addSiteRegionAzs(String siteId, List<SiteInfo> siteList) {
        logger.debug((Object)"Start addSiteRegionAzs, siteId(%s).", new Object[]{siteId});
        List<SiteInfo> dbSiteList = this.siteDao.getSites(siteId);
        ConfigChecker.checkSiteNotEmpty(dbSiteList);
        siteList.forEach(site -> {
            site.setSiteId(((SiteInfo)dbSiteList.get(0)).getSiteId());
            site.setSiteName(((SiteInfo)dbSiteList.get(0)).getSiteName());
        });
        ConfigChecker.checkAddSiteRegionAzs(siteId, siteList);
        this.siteDao.save(siteList);
        logger.debug((Object)"End addSiteRegionAzs, siteId(%s).", new Object[]{siteId});
    }

    @Override
    public void removeSiteRegionAzs(String siteId, List<SiteInfo> siteList) {
        this.siteDao.delete(ConfigChecker.checkAndGetRemoveSitesByRegionAzs(siteId, siteList));
    }

    @Override
    public void deleteSiteInfo(String siteId) {
        logger.debug((Object)"Start deleteSiteInfo, siteId(%s).", new Object[]{siteId});
        List<SiteInfo> siteList = this.getSiteInfos(siteId);
        ConfigChecker.checkRemoveSites(siteList);
        ConfigChecker.checkSiteUsedByApp(siteId);
        this.siteDao.delete(siteList);
        List<SitePlan> sitePlanList = this.sitePlanDao.querySitePlanListBySiteId(siteId);
        this.sitePlanDao.delete(siteId);
        sitePlanList.forEach(sitePlan -> this.sitePlanMapDao.removeMapBySitePlanId(sitePlan.getId()));
        logger.debug((Object)"End deleteSiteInfo, siteId(%s).", new Object[]{siteId});
    }

    @Override
    public List<SiteInfo> getSiteInfos(String siteId) {
        return this.siteDao.getSites(siteId);
    }

    @Override
    public List<SiteInfo> getSiteInfos() {
        return this.siteDao.getSites();
    }

    @Override
    public void createServiceInfos(List<ServiceInfo> srvInfoList) {
        ConfigChecker.checkCreateServiceInfos(srvInfoList);
        this.serviceDao.save(srvInfoList);
    }

    @Override
    public List<SiteInfo> getSiteInfosByRecoverPlanId(String projectId, String recoverPlanId) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)recoverPlanId)) {
            logger.error((Object)"param is empty");
            throw new LegoCheckedException(1073952400L);
        }
        List<SitePlanMap> sitePlanMapList = this.sitePlanMapDao.querySitePlanMapByRecoverPlanId(recoverPlanId);
        if (sitePlanMapList.size() == 0) {
            return new ArrayList<SiteInfo>();
        }
        ArrayList<SiteInfo> duplicatedSiteInfoList = new ArrayList<SiteInfo>();
        for (SitePlanMap sitePlanMap : sitePlanMapList) {
            SitePlan sitePlan = this.sitePlanDao.querySitePlan(projectId, sitePlanMap.getSitePlanId());
            if (sitePlan == null) {
                logger.error((Object)"querySitePlan empty");
                throw new LegoCheckedException(1073952205L);
            }
            List<SiteInfo> siteInfoList = this.siteDao.querySiteInfo(sitePlan.getSiteId());
            duplicatedSiteInfoList.addAll(siteInfoList);
        }
        return this.deDuplicateSiteInfoListByName(duplicatedSiteInfoList);
    }

    private List<SiteInfo> deDuplicateSiteInfoListByName(List<SiteInfo> duplicatedSiteInfoList) {
        ArrayList<SiteInfo> siteInfoList = new ArrayList<SiteInfo>();
        for (SiteInfo siteInfoToAdd : duplicatedSiteInfoList) {
            if (siteInfoToAdd.getSiteName() == null) continue;
            boolean needAdd = true;
            for (SiteInfo siteInfo : siteInfoList) {
                if (!Objects.equals(siteInfoToAdd.getSiteName(), siteInfo.getSiteName())) continue;
                needAdd = false;
                break;
            }
            if (!needAdd) continue;
            siteInfoList.add(siteInfoToAdd);
        }
        return siteInfoList;
    }

    @Override
    public void updateServiceRegionAz(ServiceInfo serviceInfo) {
        ConfigChecker.checkUpdateRegionAz(serviceInfo);
        this.serviceDao.updateRegionAz(serviceInfo);
    }

    @Override
    public void deleteServiceInfos(List<String> serviceIdList) {
        this.serviceDao.delete(ConfigChecker.checkAndGetServiceByIds(serviceIdList));
    }

    @Override
    public List<SiteInfo> getSiteInfosForChecker() {
        return this.siteDao.getSites();
    }

    @Override
    public SiteInfo getSiteInfoByRegionAz(String regionId, String azId) {
        return this.siteDao.getSiteInfoByRegionAz(regionId, azId);
    }

    @Override
    public List<ServiceInfo> getServiceInfos() {
        List<ServiceInfo> serviceInfoList = this.serviceDao.getServicesInfos();
        serviceInfoList.sort((o1, o2) -> (int)(o2.getCreatedAt().getTime() - o1.getCreatedAt().getTime()));
        return serviceInfoList;
    }

    @Override
    public ServiceInfo getServiceInfoById(String id) {
        return this.serviceDao.getServiceInfoById(id);
    }

    public SiteInfoDao getSiteInfoDao() {
        return this.siteDao;
    }

    public ServiceInfoDao getServiceInfoDao() {
        return this.serviceDao;
    }

    public SitePlanMapDao getSitePlanMapDao() {
        return this.sitePlanMapDao;
    }

    public SitePlanDao getSitePlanDao() {
        return this.sitePlanDao;
    }

    public void setSiteInfoDao(SiteInfoDaoImpl siteInfoDao) {
        this.siteDao = siteInfoDao;
    }

    public void setServiceInfoDao(ServiceInfoDaoImpl serviceInfoDao) {
        this.serviceDao = serviceInfoDao;
    }

    public void setSitePlanMapDao(SitePlanMapDaoImpl sitePlanMapDao) {
        this.sitePlanMapDao = sitePlanMapDao;
    }

    public void setSitePlanDao(SitePlanDaoImpl sitePlanDao) {
        this.sitePlanDao = sitePlanDao;
    }
}

