/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.service.impl;

import com.huawei.csr.framework.checker.LicenseChecker;
import com.huawei.csr.framework.checker.PlanChecker;
import com.huawei.csr.framework.common.constants.RecoverExecuteAction;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.model.RecoverExecuteBo;
import com.huawei.csr.framework.common.model.RecoverLogQuery;
import com.huawei.csr.framework.common.model.RecoverPlanQuery;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.model.RevocerPlanBo;
import com.huawei.csr.framework.common.model.SitePlanExecuteBo;
import com.huawei.csr.framework.common.model.SitePlanMapQuery;
import com.huawei.csr.framework.common.model.SitePlanQuery;
import com.huawei.csr.framework.common.statusopt.StatusOptChecker;
import com.huawei.csr.framework.common.statusopt.opt.SitePlanOpt;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.common.statusopt.status.SitePlanStatus;
import com.huawei.csr.framework.common.utils.LockUtil;
import com.huawei.csr.framework.common.utils.PlanExecuteUtil;
import com.huawei.csr.framework.common.utils.ResourceClearUtil;
import com.huawei.csr.framework.core.context.RequestContext;
import com.huawei.csr.framework.core.task.recover.RecoverContext;
import com.huawei.csr.framework.core.task.recover.RecoverPlanTask;
import com.huawei.csr.framework.core.task.recover.RecoverTaskExecuteThreadPool;
import com.huawei.csr.framework.core.task.recover.SitePlanTask;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.RecoverFlowDao;
import com.huawei.csr.framework.dao.RecoverLogDao;
import com.huawei.csr.framework.dao.RecoverPreplanDao;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.SiteInfoDao;
import com.huawei.csr.framework.dao.SitePlanDao;
import com.huawei.csr.framework.dao.SitePlanMapDao;
import com.huawei.csr.framework.dao.impl.RecoverLogDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPlanDaoImpl;
import com.huawei.csr.framework.dao.model.AbstractEntity;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.dao.model.SitePlan;
import com.huawei.csr.framework.dao.model.SitePlanMap;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.csr.framework.service.PlanService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service(Name="com.huawei.csr.framework.service.PlanService", Interface=PlanService.class, Desc="")
public class PlanServiceImpl
extends BaseService
implements PlanService {
    private static final Log LOG = LogFactory.getInstance(PlanServiceImpl.class);
    private SitePlanMapDao sitePlanMapDao;
    private SitePlanDao sitePlanDao;
    private SiteInfoDao siteInfoDao;
    private RecoverPlanDaoImpl recoverPlanDao;
    private RecoverLogDao recoverLogDao;
    private ApplicationDao applicationDao;
    private RecoverPreplanDao recoverPreplanDao;
    private RecoverFlowDao recoverFlowDao;
    private ServiceInstanceDao serviceInstanceDao;

    @Override
    public long getRecoverPlanCountBySitePlanId(String sitePlanId) {
        if (VerifyUtil.isEmpty((String)sitePlanId)) {
            LOG.error((Object)"SitePlanId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.sitePlanMapDao.getRecoverPlanCountBySitePlanId(sitePlanId);
    }

    private void createDefaultSitePlan(List<SiteInfo> siteInfoList, List<SitePlan> sitePlanList, String projectId) {
        siteInfoList.stream().filter(siteInfo -> sitePlanList.stream().noneMatch(sitePlan -> sitePlan.getSiteId().equals(siteInfo.getSiteId()))).collect(Collectors.toList()).forEach(siteInfo -> {
            SitePlan sitePlan = new SitePlan();
            sitePlan.setSiteId(siteInfo.getSiteId());
            sitePlan.setSiteName(siteInfo.getSiteName());
            sitePlan.setProjectId(projectId);
            sitePlan.setStatus(SitePlanStatus.NORMAL.getValue());
            this.sitePlanDao.save(sitePlan);
        });
    }

    private List<SiteInfo> filterSiteInfoList(List<SiteInfo> siteInfoList) {
        return siteInfoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SiteInfo>(Comparator.comparing(SiteInfo::getSiteId))), ArrayList::new));
    }

    @Override
    public List<SitePlan> querySitePlans(SitePlanQuery sitePlanQuery) {
        if (VerifyUtil.isEmpty((Object)sitePlanQuery)) {
            LOG.error((Object)"SitePlanQuery is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        List<SiteInfo> siteInfoList = this.siteInfoDao.getSites();
        List<SiteInfo> uniqueSiteInfoList = this.filterSiteInfoList(siteInfoList);
        List<SitePlan> sitePlanList = this.sitePlanDao.querySitePlanListByProjectId(sitePlanQuery);
        if (uniqueSiteInfoList.size() != sitePlanList.size()) {
            this.createDefaultSitePlan(uniqueSiteInfoList, sitePlanList, sitePlanQuery.getProjectId());
            return this.sitePlanDao.querySitePlanListByProjectId(sitePlanQuery);
        }
        return sitePlanList;
    }

    @Override
    public long getSitePlanCountByProjectId(String projectId) {
        if (VerifyUtil.isEmpty((String)projectId)) {
            LOG.error((Object)"ProjectId is empty in function getSitePlanCountByProjectId.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.sitePlanDao.getSitePlanCountByProjectId(projectId);
    }

    @Override
    public SitePlan querySitePlan(String projectId, String sitePlanId) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)sitePlanId)) {
            LOG.error((Object)"ProjectId or SitePlanId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        SitePlan sitePlan = this.sitePlanDao.querySitePlan(projectId, sitePlanId);
        if (VerifyUtil.isEmpty((Object)sitePlan)) {
            LOG.error((Object)"SitePlan %s is empty.", new Object[]{sitePlanId});
            throw new LegoCheckedException(1073952205L);
        }
        return sitePlan;
    }

    @Override
    public List<SiteInfo> addPlanToSite(String projectId, String sitePlanId, Map<String, Integer> planPriorityMap) {
        PlanChecker.checkParamsForPriority(projectId, sitePlanId, planPriorityMap);
        SitePlan sitePlan = this.sitePlanDao.querySitePlan(projectId, sitePlanId);
        if (VerifyUtil.isEmpty((Object)sitePlan)) {
            LOG.error((Object)"QuerySitePlan empty.The sitePlanId is '%s'.", new Object[]{sitePlanId});
            throw new LegoCheckedException(1073952205L);
        }
        PlanChecker.checkSitePlanCount(sitePlanId, sitePlan.getSiteName(), planPriorityMap.entrySet().size());
        StatusOptChecker.checkSitePlanStatusOpt(SitePlanStatus.from(sitePlan.getStatus()).getIndex(), SitePlanOpt.ADD_PLAN.getIndex(), 1073952403L);
        for (Map.Entry<String, Integer> entry : planPriorityMap.entrySet()) {
            PlanChecker.checkSitePlanMapExist(sitePlanId, sitePlan.getSiteName(), entry.getKey());
            PlanChecker.checkRecoverPlanAppSite(projectId, entry.getKey(), sitePlan);
            PlanChecker.checkRecoverPlanStatus(entry.getKey());
        }
        for (Map.Entry<String, Integer> entry : planPriorityMap.entrySet()) {
            SitePlanMap sitePlanMap = new SitePlanMap();
            sitePlanMap.setSitePlanId(sitePlanId);
            sitePlanMap.setRecoverPlanId(entry.getKey());
            sitePlanMap.setPriority(entry.getValue());
            this.sitePlanMapDao.addPlanToSite(sitePlanMap);
        }
        List<SiteInfo> siteInfoList = this.siteInfoDao.querySiteInfo(sitePlan.getSiteId());
        if (siteInfoList.size() == 0) {
            LOG.error((Object)"SitePlan %s is empty.", new Object[]{sitePlanId});
            throw new LegoCheckedException(1073952204L);
        }
        return siteInfoList;
    }

    @Override
    public List<SiteInfo> removePlanToSite(String projectId, String sitePlanId, List<String> planList) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)sitePlanId) || VerifyUtil.isEmpty(planList)) {
            LOG.error((Object)"ProjectId or SitePlanId or PlanList is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        if (planList.size() == 0) {
            LOG.error((Object)"PlanList is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        SitePlan sitePlan = this.sitePlanDao.querySitePlan(projectId, sitePlanId);
        if (VerifyUtil.isEmpty((Object)sitePlan)) {
            LOG.error((Object)"QuerySitePlan empty.The sitePlanId is '%s'", new Object[]{sitePlanId});
            throw new LegoCheckedException(1073952205L);
        }
        StatusOptChecker.checkSitePlanStatusOpt(SitePlanStatus.from(sitePlan.getStatus()).getIndex(), SitePlanOpt.REMOVE_PLAN.getIndex(), 1073952403L);
        planList.forEach(recoverPlanId -> PlanChecker.checkSitePlanMapNotExist(sitePlanId, sitePlan.getSiteName(), recoverPlanId));
        planList.forEach(recoverPlanId -> this.sitePlanMapDao.removePlanToSite(sitePlanId, (String)recoverPlanId));
        this.updateSitePlanStatusToNormal(sitePlanId);
        List<SiteInfo> siteInfoList = this.siteInfoDao.querySiteInfo(sitePlan.getSiteId());
        if (siteInfoList.size() == 0) {
            LOG.error((Object)"QuerySitePlan empty.The sitePlanId is '%s'", new Object[]{sitePlanId});
            throw new LegoCheckedException(1073952204L);
        }
        return siteInfoList;
    }

    @Override
    public List<SiteInfo> modifyPlanPriority(String projectId, String sitePlanId, Map<String, Integer> planPriorityMap) {
        PlanChecker.checkParamsForPriority(projectId, sitePlanId, planPriorityMap);
        SitePlan sitePlan = this.sitePlanDao.querySitePlan(projectId, sitePlanId);
        if (sitePlan == null) {
            LOG.error((Object)"SitePlan %s is empty", new Object[]{sitePlanId});
            throw new LegoCheckedException(1073952205L);
        }
        StatusOptChecker.checkSitePlanStatusOpt(SitePlanStatus.from(sitePlan.getStatus()).getIndex(), SitePlanOpt.MODIFY_PRIORITY.getIndex(), 1073952403L);
        for (Map.Entry<String, Integer> entry : planPriorityMap.entrySet()) {
            PlanChecker.checkSitePlanMapNotExist(sitePlanId, sitePlan.getSiteName(), entry.getKey());
        }
        for (Map.Entry<String, Integer> entry : planPriorityMap.entrySet()) {
            this.sitePlanMapDao.modifyPlanPriority(sitePlanId, entry.getKey(), entry.getValue());
        }
        List<SiteInfo> siteInfoList = this.siteInfoDao.querySiteInfo(sitePlan.getSiteId());
        if (siteInfoList.size() == 0) {
            LOG.error((Object)"QuerySiteInfo empty.");
            throw new LegoCheckedException(1073952204L);
        }
        return siteInfoList;
    }

    @Override
    public long getPreplanCountByRecoverPlan(String recoverPlanId) {
        return this.recoverPreplanDao.getPrePlanCountByRecoverPlanId(recoverPlanId);
    }

    @Override
    public int queryRecoverPlanPriority(String sitePlanId, String recoverPlanId) {
        if (VerifyUtil.isEmpty((String)sitePlanId) || VerifyUtil.isEmpty((String)recoverPlanId)) {
            LOG.error((Object)"SitePlanId or RecoverPlanId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.sitePlanMapDao.queryRecoverPlanPriority(sitePlanId, recoverPlanId);
    }

    @Override
    public List<SitePlanMap> queryPagedSitePlanMapBySitePlanId(SitePlanMapQuery sitePlanMapQuery) {
        if (VerifyUtil.isEmpty((String)sitePlanMapQuery.getSitePlanId())) {
            LOG.error((Object)"SitePlanId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.sitePlanMapDao.queryPagedSitePlanMapBySitePlanId(sitePlanMapQuery);
    }

    @Override
    public Pair<List<RecoverPlan>, Integer> queryRecoverPlansFromSite(String projectId, SitePlanMapQuery sitePlanMapQuery) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((Object)sitePlanMapQuery)) {
            LOG.error((Object)"ProjectId or SitePlanMapQuery is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        SitePlan sitePlan = this.sitePlanDao.querySitePlan(projectId, sitePlanMapQuery.getSitePlanId());
        if (sitePlan == null) {
            LOG.error((Object)"SitePlan %s is empty", new Object[]{sitePlanMapQuery.getSitePlanId()});
            throw new LegoCheckedException(1073952205L);
        }
        List<SitePlanMap> sitePlanMapList = this.sitePlanMapDao.queryPagedSitePlanMapBySitePlanId(sitePlanMapQuery);
        sitePlanMapQuery.setPage(false);
        int count = this.sitePlanMapDao.queryPagedSitePlanMapBySitePlanId(sitePlanMapQuery).size();
        ArrayList recoverPlanList = new ArrayList();
        sitePlanMapList.stream().sorted(Comparator.comparing(SitePlanMap::getPriority)).forEach(sitePlanMap -> recoverPlanList.add(this.recoverPlanDao.getRecoverPlanById(sitePlanMap.getRecoverPlanId())));
        return Pair.of(recoverPlanList, (Object)count);
    }

    @Override
    public List<RecoverLog> getRecoverLogList(RecoverLogQuery recoverLogQuery) {
        if (VerifyUtil.isEmpty((String)recoverLogQuery.getProjectId())) {
            LOG.error((Object)"ProjectId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.recoverLogDao.queryRecoverLogs(recoverLogQuery);
    }

    @Override
    public long getRecoverLogCount(RecoverLogQuery recoverLogQuery) {
        if (VerifyUtil.isEmpty((Object)recoverLogQuery)) {
            LOG.error((Object)"RecoverLogQuery is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.recoverLogDao.getRecoverLogCount(recoverLogQuery);
    }

    @Override
    public long getSitePlanMapCount(String sitePlanId, String recoverPlanId) {
        if (VerifyUtil.isEmpty((String)sitePlanId) || VerifyUtil.isEmpty((String)recoverPlanId)) {
            LOG.error((Object)"SitePlanId or recoverPlanId is empty");
            throw new LegoCheckedException(1073952400L);
        }
        return this.sitePlanMapDao.getSitePlanMapCount(sitePlanId, recoverPlanId);
    }

    @Override
    public Pair<List<RecoverPlan>, Integer> queryRecoverPlansForSitePlan(RecoverPlanQuery query, String sitePlanId) {
        SitePlan sitePlan = this.sitePlanDao.querySitePlan(query.getProjectId(), sitePlanId);
        if (VerifyUtil.isEmpty((Object)sitePlan)) {
            LOG.error((Object)"SitePlan: %s does not exist", new Object[]{query.getSitePlanId()});
            throw new LegoCheckedException(1073952205L);
        }
        List<RecoverPlan> recoverPlanList = this.recoverPlanDao.queryPlans(query, this.getPlanIdsBySiteName(query.getSiteName()));
        recoverPlanList.removeIf(recoverPlan -> !RecoverStatus.NORMAL.getValue().equals(recoverPlan.getStatus()));
        recoverPlanList.removeIf(recoverPlan -> this.isRecoverPlanAlreadyMapped(sitePlan.getId(), recoverPlan.getId()));
        recoverPlanList = recoverPlanList.stream().filter(recoverPlan -> this.isRecoverPlanAppsRelatedToSite(query.getProjectId(), recoverPlan.getId(), sitePlan.getSiteId())).collect(Collectors.toList());
        ArrayList<RecoverPlan> page = new ArrayList<RecoverPlan>(recoverPlanList.subList(Math.min(query.getMarker(), recoverPlanList.size()), Math.min(query.getMarker() + query.getLimit(), recoverPlanList.size())));
        int totalCount = recoverPlanList.size();
        return Pair.of(page, (Object)totalCount);
    }

    private boolean isRecoverPlanAlreadyMapped(String sitePlanId, String recoverPlanId) {
        return this.sitePlanMapDao.getSitePlanMapCount(sitePlanId, recoverPlanId) > 0L;
    }

    private boolean isRecoverPlanAppsRelatedToSite(String projectId, String recoverPlanId, String siteId) {
        List<Application> appList = this.applicationDao.getAppByRecoverPlanId(projectId, recoverPlanId);
        if (VerifyUtil.isEmpty(appList)) {
            LOG.error((Object)"Apps of recover plan %s is empty.", new Object[]{recoverPlanId});
            return false;
        }
        for (Application app : appList) {
            for (AppServiceInstance instance : app.getServiceInstances()) {
                if (!siteId.equals(instance.getPdSiteId()) && !siteId.equals(instance.getDrSiteId())) continue;
                LOG.error((Object)"App: %s instances does not contains site %s.", new Object[]{app.getId(), siteId});
                return true;
            }
        }
        LOG.info((Object)"Recover plan %s apps does not contains site %s.", new Object[]{recoverPlanId, siteId});
        return false;
    }

    @Override
    public RecoverPlan createPlan(final RevocerPlanBo parameters) {
        PlanChecker.checkCreatePlan(parameters);
        final RecoverPlan recoverPlan = new RecoverPlan();
        recoverPlan.setName(parameters.getName());
        recoverPlan.setDescription(parameters.getDescription());
        recoverPlan.setProjectId(parameters.getProjectId());
        recoverPlan.setStatus(RecoverStatus.NORMAL.getValue());
        try {
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    PlanServiceImpl.this.recoverPlanDao.savePlan(recoverPlan);
                    parameters.getApplicationIds().forEach(applicationId -> PlanServiceImpl.this.applicationDao.updateAppRecoverPlanId(parameters.getProjectId(), (String)applicationId, recoverPlan.getId()));
                }
            });
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"Creating recovery plan failed,error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw exception;
        }
        catch (Exception e) {
            LOG.error((Object)"Creating recovery plan failed,error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
        return recoverPlan;
    }

    @Override
    public void deletePlan(final String projectId, final String planId) {
        PlanChecker.checkDeletePlan(projectId, planId);
        try {
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    List<Application> applications = PlanServiceImpl.this.applicationDao.getAppByRecoverPlanId(projectId, planId);
                    applications.forEach(app -> PlanServiceImpl.this.applicationDao.updateAppRecoverPlanId(projectId, app.getId(), null));
                    List<SitePlanMap> sitePlanMaps = PlanServiceImpl.this.sitePlanMapDao.querySitePlanMapByRecoverPlanId(planId);
                    PlanServiceImpl.this.recoverPlanDao.deletePlan(projectId, planId);
                    PlanServiceImpl.this.sitePlanMapDao.removeMapByRecoverPlanId(planId);
                    sitePlanMaps.forEach(sitePlanMap -> PlanServiceImpl.this.updateSitePlanStatusToNormal(sitePlanMap.getSitePlanId()));
                    RecoverLogQuery recoverLogQuery = new RecoverLogQuery();
                    recoverLogQuery.setResourceIds(Collections.singletonList(planId));
                    recoverLogQuery.setProjectId(projectId);
                    List<RecoverLog> recoverLogs = PlanServiceImpl.this.recoverLogDao.queryRecoverLogs(recoverLogQuery);
                    if (VerifyUtil.isEmpty(recoverLogs)) {
                        LOG.warn((Object)"There is no recoverLog of recovery plan[%s].", new Object[]{planId});
                        return;
                    }
                    PlanServiceImpl.this.recoverLogDao.deleteRevocerLogByResourceId(projectId, planId);
                    PlanServiceImpl.this.deleteRecoverLogsByParentIdsUseRecursion(projectId, recoverLogs.stream().map(AbstractEntity::getId).collect(Collectors.toList()));
                }
            });
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"Delete recovery plan[%s] failed,error:%s.", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw exception;
        }
        catch (Exception e) {
            LOG.error((Object)"Delete recovery plan[%s] failed,error:%s.", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
    }

    private void deleteRecoverLogsByParentIdsUseRecursion(String projectId, List<String> recoverLogParentIds) {
        if (VerifyUtil.isEmpty(recoverLogParentIds)) {
            return;
        }
        List<String> revocerLogIds = recoverLogParentIds.stream().distinct().flatMap(parentId -> {
            RecoverLogQuery recoverLogQuery = new RecoverLogQuery();
            recoverLogQuery.setParentIds(Collections.singletonList(parentId));
            recoverLogQuery.setProjectId(projectId);
            List<RecoverLog> nextLevelLogList = this.recoverLogDao.queryRecoverLogs(recoverLogQuery);
            if (VerifyUtil.isEmpty(nextLevelLogList)) {
                LOG.warn((Object)"Recover log list is empty,when parentId is %s", new Object[]{parentId});
                return Stream.empty();
            }
            this.recoverLogDao.deleteRevocerLogByParentId(projectId, (String)parentId);
            return nextLevelLogList.stream().map(AbstractEntity::getId);
        }).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(revocerLogIds)) {
            return;
        }
        this.deleteRecoverLogsByParentIdsUseRecursion(projectId, revocerLogIds);
    }

    @Override
    public RecoverPlan updatePlan(RevocerPlanBo params) {
        PlanChecker.checkUpdatePlan(params);
        RecoverPlan plan = new RecoverPlan();
        plan.setProjectId(params.getProjectId());
        plan.setDescription(params.getDescription());
        plan.setName(params.getName());
        plan.setId(params.getPlanId());
        this.recoverPlanDao.updatePlanBasicInfo(plan);
        return plan;
    }

    @Override
    public Pair<List<RecoverPlan>, Integer> queryPlans(RecoverPlanQuery recoverPlanQuery) {
        if (VerifyUtil.isEmpty((Object)recoverPlanQuery)) {
            LOG.error((Object)"RecoverPlanQuery is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        String siteName = recoverPlanQuery.getSiteName();
        return Pair.of(this.recoverPlanDao.queryPlans(recoverPlanQuery, this.getPlanIdsBySiteName(siteName)), (Object)this.recoverPlanDao.getRecoverPlanCountByRecoverPlanQuery(recoverPlanQuery, this.getPlanIdsBySiteName(siteName)));
    }

    private Set<String> getPlanIdsBySiteName(String siteName) {
        HashSet<String> planIdsQueryBySiteNameSet = new HashSet<String>();
        if (VerifyUtil.isEmpty((String)siteName)) {
            return planIdsQueryBySiteNameSet;
        }
        planIdsQueryBySiteNameSet.addAll(this.applicationDao.getPlanIdsBySiteName("pdSiteName", siteName));
        planIdsQueryBySiteNameSet.addAll(this.applicationDao.getPlanIdsBySiteName("drSiteName", siteName));
        return planIdsQueryBySiteNameSet;
    }

    @Override
    public RecoverPlan queryPlan(String projectId, String planId, String applicationId) {
        if (VerifyUtil.isEmpty((String)projectId)) {
            LOG.error((Object)"ProjectId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        if (VerifyUtil.isEmpty((String)planId) && VerifyUtil.isEmpty((String)applicationId)) {
            LOG.error((Object)"planId and applicationId can not be empty at the same time.");
            throw new LegoCheckedException(1073952400L);
        }
        Optional<RecoverPlan> recoverPlanOptional = this.recoverPlanDao.queryPlan(projectId, planId, applicationId);
        if (!recoverPlanOptional.isPresent()) {
            LOG.error((Object)"Recover plan is not exists. The planId is '%s',applicationId is '%s'", new Object[]{planId, applicationId});
            throw new LegoCheckedException(1073952109L);
        }
        return recoverPlanOptional.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeSitePlan(RequestContext requestContext, SitePlanExecuteBo executeBo) {
        LicenseChecker.checkLicense();
        if (RecoverOperateType.PLANNED_MIGRATION.equals((Object)executeBo.getOperationType())) {
            LOG.error((Object)"SitePlan: %s can not execute planned migration.", new Object[]{executeBo.getSitePlanId()});
            throw new LegoCheckedException(1073952403L);
        }
        SitePlan sitePlan = this.sitePlanDao.querySitePlan(executeBo.getProjectId(), executeBo.getSitePlanId());
        if (VerifyUtil.isEmpty((Object)sitePlan)) {
            LOG.error((Object)"Site plan: %s does not exist.", new Object[]{executeBo.getSitePlanId()});
            throw new LegoCheckedException(1073952205L);
        }
        if (!LockUtil.tryLock(RecoverResourceType.SITE_PLAN.getValue() + executeBo.getSitePlanId())) {
            LOG.error((Object)"Site plan: %s is executing.", new Object[]{sitePlan.getId()});
            throw new LegoCheckedException(1073952219L);
        }
        try {
            StatusOptChecker.checkSitePlanStatusOpt(SitePlanStatus.from(sitePlan.getStatus()).getIndex(), SitePlanOpt.from(executeBo.getOperationType().getValue()).getIndex(), 1073952403L);
            RecoverLogQuery recoverLogQuery = new RecoverLogQuery();
            recoverLogQuery.setProjectId(executeBo.getProjectId());
            recoverLogQuery.setResourceIds(Collections.singletonList(sitePlan.getId()));
            recoverLogQuery.setLimit(1);
            List<RecoverLog> recoverLogs = this.getRecoverLogList(recoverLogQuery);
            if (RecoverExecuteAction.EXECUTE.equals((Object)executeBo.getAction())) {
                String string = this.submitSitePlanTask(requestContext, executeBo, recoverLogs, sitePlan);
                return string;
            }
            String string = this.suspendOrStopSitePlan(executeBo, recoverLogs, sitePlan);
            return string;
        }
        finally {
            LockUtil.unLock(RecoverResourceType.SITE_PLAN.getValue() + sitePlan.getId());
        }
    }

    private String suspendOrStopSitePlan(SitePlanExecuteBo executeBo, List<RecoverLog> recoverLogs, SitePlan sitePlan) {
        if (VerifyUtil.isEmpty(recoverLogs) || recoverLogs.get(0).getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
            LOG.error((Object)"The task has finished, cannot %s it.", new Object[]{executeBo.getAction().getValue()});
            throw new LegoCheckedException(1073952404L);
        }
        RecoverLog recoverLog = recoverLogs.get(0);
        LOG.info((Object)"Start %s the site plan(%s) log(%s)", new Object[]{executeBo.getAction().getValue(), sitePlan.getId(), recoverLog.getId()});
        PlanExecuteUtil.updateSiteTaskResource(executeBo, recoverLog);
        return recoverLog.getId();
    }

    @Override
    public Map<String, Set<String>> getSourceToTargetSiteInfoMap(String projectId, String recoverPlanId) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)recoverPlanId)) {
            LOG.error((Object)"ProjectId or recoverPlanId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        HashMap<String, Set<String>> source2TargetSiteInfoMap = new HashMap<String, Set<String>>();
        List<Application> appList = this.applicationDao.getAppListByRecoverPlanId(projectId, recoverPlanId);
        if (VerifyUtil.isEmpty(appList)) {
            LOG.warn((Object)"Application list is empty,return empty map! recoverPlanId:%s", new Object[]{recoverPlanId});
            return source2TargetSiteInfoMap;
        }
        List serverInstanceList = appList.stream().flatMap(app -> {
            List<AppServiceInstance> serverInstances = this.serviceInstanceDao.getServiceInstanceByAppId(app.getId());
            return Optional.ofNullable(serverInstances).orElse(Lists.newArrayList()).stream();
        }).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(serverInstanceList)) {
            LOG.warn((Object)"ServiceInstance list is empty,return empty map! recoverPlanId:%s", new Object[]{recoverPlanId});
            return source2TargetSiteInfoMap;
        }
        serverInstanceList.stream().flatMap(serverInstance -> Stream.of(serverInstance.getPdSiteId(), serverInstance.getDrSiteId())).filter(siteId -> !VerifyUtil.isEmpty((String)siteId)).distinct().forEach(siteId -> source2TargetSiteInfoMap.put((String)siteId, this.findTargetSiteIds((String)siteId, serverInstanceList.stream().filter(serverInstance -> siteId.equals(serverInstance.getPdSiteId()) || siteId.equals(serverInstance.getDrSiteId())).collect(Collectors.toList()))));
        return source2TargetSiteInfoMap;
    }

    private Set<String> findTargetSiteIds(String sourceSiteId, List<AppServiceInstance> serverInstanceList) {
        List containsTargetSiteServiceList = serverInstanceList.stream().filter(serverInstance -> !VerifyUtil.isEmpty((String)serverInstance.getPdSiteId()) && !VerifyUtil.isEmpty((String)serverInstance.getDrSiteId())).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(containsTargetSiteServiceList)) {
            HashSet<String> targetSiteIds = new HashSet<String>();
            targetSiteIds.add(sourceSiteId);
            return targetSiteIds;
        }
        boolean isRegionServiceExists = containsTargetSiteServiceList.size() != serverInstanceList.size();
        List siteIdList = serverInstanceList.stream().flatMap(serverInstance -> Stream.of(serverInstance.getPdSiteId(), serverInstance.getDrSiteId())).collect(Collectors.toList());
        if (isRegionServiceExists) {
            return siteIdList.stream().filter(siteId -> !VerifyUtil.isEmpty((String)siteId)).collect(Collectors.toSet());
        }
        return siteIdList.stream().filter(siteId -> !sourceSiteId.equals(siteId) && !VerifyUtil.isEmpty((String)siteId)).collect(Collectors.toSet());
    }

    private String submitSitePlanTask(RequestContext requestContext, SitePlanExecuteBo executeBo, List<RecoverLog> recoverLogs, SitePlan sitePlan) {
        String taskId;
        SitePlanTask sitePlanTask = new SitePlanTask(new RecoverContext(requestContext).setResourceId(sitePlan.getId()).setResourceName(sitePlan.getSiteName()).setResourceType(RecoverResourceType.SITE_PLAN.getValue()).setSiteId(sitePlan.getSiteId()).setFailCallback(() -> PlanExecuteUtil.updateCallBack(sitePlan.getId(), RecoverLogStatus.FAILED)).setSuspendCallBack(() -> PlanExecuteUtil.updateCallBack(sitePlan.getId(), RecoverLogStatus.SUSPENDED)).setRecoverOperateType(executeBo.getOperationType()), sitePlan, executeBo.getContinuePlanId());
        if (!(VerifyUtil.isEmpty(recoverLogs) || recoverLogs.get(0).getStatus().equals(RecoverLogStatus.SUCCESS.getValue()) || sitePlan.getStatus().equals(SitePlanStatus.NORMAL.getValue()))) {
            LOG.info((Object)"The site plan(%s) task log(%s) has existed, so continue execute.", new Object[]{sitePlan.getId(), recoverLogs.get(0).getId()});
            sitePlanTask.getRecoverContext().setRecoverLog(recoverLogs.get(0));
            taskId = recoverLogs.get(0).getId();
            RecoverTaskExecuteThreadPool.submit(sitePlanTask);
        } else {
            LOG.info((Object)"Start execute new site plan %s task", new Object[]{sitePlan.getId()});
            taskId = RecoverTaskExecuteThreadPool.submitWithTaskId(sitePlanTask);
        }
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executePlan(RequestContext context, RecoverExecuteBo executeBo) {
        LOG.debug((Object)"Start executePlan, projectId: %s, planId: %s, recoverPreplanId: %s", new Object[]{executeBo.getProjectId(), executeBo.getPlanId(), executeBo.getRecoverPreplanId()});
        LicenseChecker.checkLicense();
        RecoverPlan recoverPlan = this.getRecoverPlan(executeBo);
        RecoverPreplan recoverPreplan = this.getRecoverPreplan(executeBo);
        if (!LockUtil.tryLock(RecoverResourceType.RECOVER_PLAN.getValue() + recoverPlan.getId())) {
            LOG.error((Object)"The recovery plan is executing. PlanId: %s", new Object[]{recoverPlan.getId()});
            throw new LegoCheckedException(1073952805L, new String[]{recoverPreplan.getName()});
        }
        try {
            PlanChecker.checkExecutePlan(executeBo, recoverPreplan, recoverPlan);
            RecoverLogQuery recoverLogQuery = new RecoverLogQuery();
            recoverLogQuery.setProjectId(context.getProjectId());
            recoverLogQuery.setResourceIds(Collections.singletonList(recoverPlan.getId()));
            recoverLogQuery.setLimit(1);
            List<RecoverLog> recoverLogs = this.getRecoverLogList(recoverLogQuery);
            if (RecoverExecuteAction.EXECUTE.equals((Object)executeBo.getAction())) {
                String string = this.submitTask(recoverPlan, recoverPreplan, context, recoverLogs);
                return string;
            }
            if (VerifyUtil.isEmpty(recoverLogs) || recoverLogs.get(0).getStatus().equals(RecoverLogStatus.SUCCESS.getValue())) {
                LOG.error((Object)"The task has finished, cannot %s it.", new Object[]{executeBo.getAction().getValue()});
                throw new LegoCheckedException(1073952404L);
            }
            RecoverLog recoverLog = recoverLogs.get(0);
            LOG.info((Object)"Start %s the recover plan(%s) log(%s)", new Object[]{executeBo.getAction().getValue(), recoverPlan.getId(), recoverLog.getId()});
            if (RecoverExecuteAction.SUSPEND.equals((Object)executeBo.getAction())) {
                recoverLog.setErrorCode(-1000L);
            } else {
                recoverLog.setErrorCode(1073952114L);
            }
            ((RecoverLogDaoImpl)ServiceLocator.getInstance().getService(RecoverLogDaoImpl.class)).update(recoverLog);
            String string = recoverLog.getId();
            return string;
        }
        finally {
            LockUtil.unLock(RecoverResourceType.RECOVER_PLAN.getValue() + recoverPlan.getId());
        }
    }

    private String submitTask(RecoverPlan recoverPlan, RecoverPreplan recoverPreplan, RequestContext context, List<RecoverLog> recoverLogs) {
        RecoverPlanTask recoverPlanTask = new RecoverPlanTask(new RecoverContext(context).setResourceId(recoverPlan.getId()).setResourceName(recoverPlan.getName()).setResourceType(RecoverResourceType.RECOVER_PLAN.getValue()).setSiteId(recoverPreplan.getSiteId()).setRecoverOperateType(RecoverOperateType.from(recoverPreplan.getType())), recoverPlan, recoverPreplan);
        String taskId = "";
        if (!(VerifyUtil.isEmpty(recoverLogs) || recoverLogs.get(0).getStatus().equals(RecoverLogStatus.SUCCESS.getValue()) || recoverPlan.getStatus().equals(RecoverStatus.NORMAL.getValue()))) {
            LOG.info((Object)"The recover plan(%s) task log(%s) has existed, so continue execute.", new Object[]{recoverPlan.getId(), recoverLogs.get(0).getId()});
            recoverPlanTask.getRecoverContext().setRecoverLog(recoverLogs.get(0));
            taskId = recoverLogs.get(0).getId();
            RecoverTaskExecuteThreadPool.submit(recoverPlanTask, "recover-plan-execute");
        } else {
            LOG.info((Object)"Start execute a new recover plan(%s) task", new Object[]{recoverPlan.getId()});
            taskId = RecoverTaskExecuteThreadPool.submitWithTaskId(recoverPlanTask, "recover-plan-execute");
        }
        return taskId;
    }

    private RecoverPlan getRecoverPlan(RecoverExecuteBo executeBo) {
        String planId;
        PlanService planService = (PlanService)ServiceLocator.getInstance().getService(PlanService.class);
        RecoverPlan recoverPlan = planService.getRecoverPlanById(planId = executeBo.getPlanId());
        if (recoverPlan == null) {
            LOG.error((Object)"RecoverPlan %s does not exist.", new Object[]{planId});
            throw new LegoCheckedException(1073952109L);
        }
        return recoverPlan;
    }

    private RecoverPreplan getRecoverPreplan(RecoverExecuteBo executeBo) {
        RecoverPreplanService recoverPreplanService = (RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class);
        return recoverPreplanService.queryPreplanById(executeBo.getRecoverPreplanId());
    }

    @Override
    public void addAppToPlan(String projectId, String planId, List<String> applications) {
        LOG.debug((Object)"Start addAppToPlan, projectId: %s, planId: %s.", new Object[]{projectId, planId});
        PlanChecker.checkAddAppToPlan(projectId, planId, applications);
        applications.forEach(applicationId -> this.applicationDao.updateAppRecoverPlanId(projectId, (String)applicationId, planId));
    }

    @Override
    public void removeAppFromPlan(final String projectId, final String planId, final List<String> applications) {
        LOG.debug((Object)"Start removeAppFromPlan, projectId: %s, planId: %s.", new Object[]{projectId, planId});
        PlanChecker.checkRemoveAppFromPlan(projectId, planId, applications);
        try {
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    applications.forEach(applicationId -> {
                        List<SiteInfo> beforeRemoveAppsiteList = PlanServiceImpl.this.getSiteOfAppByRecoverPlanId(projectId, planId);
                        List<String> flowIds = PlanServiceImpl.this.recoverFlowDao.queryRecoverFlowsByAppId(projectId, (String)applicationId).stream().map(AbstractEntity::getId).collect(Collectors.toList());
                        List<String> stageIds = ResourceClearUtil.deleteFlows(projectId, flowIds);
                        List<String> prePlanIds = ResourceClearUtil.deleteStages(projectId, stageIds);
                        ResourceClearUtil.deletePrePlans(projectId, prePlanIds);
                        PlanServiceImpl.this.applicationDao.updateAppRecoverPlanId(projectId, (String)applicationId, null);
                        PlanServiceImpl.this.deleteEmptyPrePlanAndSitePlanMap(beforeRemoveAppsiteList, projectId, planId);
                    });
                }
            });
        }
        catch (LegoCheckedException exception) {
            LOG.error((Object)"Remove app from recovery plan[%s] failed,error:%s.", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)exception)});
            throw exception;
        }
        catch (Exception e) {
            LOG.error((Object)"Remove app from recovery plan[%s] failed,error:%s.", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
    }

    private void deleteEmptyPrePlanAndSitePlanMap(List<SiteInfo> beforeRemoveAppsiteList, String projectId, String planId) {
        List afterRemoveAppSiteList = this.getSiteOfAppByRecoverPlanId(projectId, planId).stream().map(SiteInfo::getSiteId).collect(Collectors.toList());
        List removedSiteIds = beforeRemoveAppsiteList.stream().filter(site -> !afterRemoveAppSiteList.contains(site.getSiteId())).collect(Collectors.toList());
        removedSiteIds.stream().flatMap(site -> {
            RecoverPreplanQuery prePlanQuery = new RecoverPreplanQuery();
            prePlanQuery.setPage(false);
            prePlanQuery.setPlanId(planId);
            prePlanQuery.setSiteId(site.getSiteId());
            return this.recoverPreplanDao.queryPreplans(prePlanQuery).stream();
        }).forEach(prePlan -> ((RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class)).deletePreplan(projectId, prePlan.getId()));
        removedSiteIds.stream().map(site -> this.sitePlanDao.querySitePlanBySiteId(projectId, site.getSiteId())).filter(Objects::nonNull).forEach(sitePlan -> {
            if (!this.isRecoverPlanAlreadyMapped(sitePlan.getId(), planId)) {
                LOG.warn((Object)"There is no relation between sitePlan '%s' and recoverPlan '%s', return.", new Object[]{sitePlan.getId(), planId});
                return;
            }
            this.sitePlanMapDao.removePlanToSite(sitePlan.getId(), planId);
            this.updateSitePlanStatusToNormal(sitePlan.getId());
        });
    }

    @Override
    public int getAllRecoverPlanCount() {
        return this.recoverPlanDao.getAllRecoverPlanCount();
    }

    @Override
    public Application getApp(String applicationId) {
        return this.applicationDao.getApp(applicationId);
    }

    @Override
    public RecoverPlan getRecoverPlanById(String id) {
        return this.recoverPlanDao.getRecoverPlanById(id);
    }

    @Override
    public List<Application> getAppByRecoverPlanId(String projectId, String recoverPlanId) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)recoverPlanId)) {
            LOG.error((Object)"ProjectId or recoverPlanId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.applicationDao.getAppByRecoverPlanId(projectId, recoverPlanId);
    }

    @Override
    public List<RecoverPlan> getRecoverPlanOfStepStatus(RecoverStepQuery recoverStepQuery) {
        if (VerifyUtil.isEmpty((String)recoverStepQuery.getProjectId()) || VerifyUtil.isEmpty((String)recoverStepQuery.getStepId())) {
            LOG.error((Object)"ProjectId or stepId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.recoverPlanDao.getRecoverPlanOfStepStatus(recoverStepQuery);
    }

    @Override
    public List<SiteInfo> getSiteOfAppByRecoverPlanId(String projectId, String recoverPlanId) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)recoverPlanId)) {
            LOG.error((Object)"ProjectId or recoverPlanId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        List<Application> appList = this.applicationDao.getAppListByRecoverPlanId(projectId, recoverPlanId);
        if (VerifyUtil.isEmpty(appList)) {
            LOG.warn((Object)"Application list is empty,return empty list! recoverPlanId:%s", new Object[]{recoverPlanId});
            return Lists.newArrayList();
        }
        HashMap siteInfoMap = new HashMap();
        appList.stream().flatMap(app -> {
            List<AppServiceInstance> serverInstances = this.serviceInstanceDao.getServiceInstanceByAppId(app.getId());
            return Optional.ofNullable(serverInstances).orElse(Lists.newArrayList()).stream();
        }).forEach(instance -> {
            String drSitekey = String.format(Locale.ENGLISH, "%s_%s_%s", instance.getDrSiteId(), instance.getDrRegionId(), instance.getDrAzId());
            String pdSitekey = String.format(Locale.ENGLISH, "%s_%s_%s", instance.getPdSiteId(), instance.getPdRegionId(), instance.getPdAzId());
            if (!VerifyUtil.isEmpty((String)instance.getDrSiteId()) && !siteInfoMap.containsKey(drSitekey)) {
                SiteInfo drSiteInfo = new SiteInfo();
                drSiteInfo.setSiteId(instance.getDrSiteId());
                drSiteInfo.setSiteName(instance.getDrSiteName());
                drSiteInfo.setRegionId(instance.getDrRegionId());
                drSiteInfo.setRegionName(instance.getDrRegionName());
                drSiteInfo.setAzId(instance.getDrAzId());
                drSiteInfo.setAzName(instance.getDrAzName());
                siteInfoMap.put(drSitekey, drSiteInfo);
            }
            if (!VerifyUtil.isEmpty((String)instance.getPdSiteId()) && !siteInfoMap.containsKey(pdSitekey)) {
                SiteInfo pdSiteInfo = new SiteInfo();
                pdSiteInfo.setSiteId(instance.getPdSiteId());
                pdSiteInfo.setSiteName(instance.getPdSiteName());
                pdSiteInfo.setRegionId(instance.getPdRegionId());
                pdSiteInfo.setRegionName(instance.getPdRegionName());
                pdSiteInfo.setAzId(instance.getPdAzId());
                pdSiteInfo.setAzName(instance.getPdAzName());
                siteInfoMap.put(pdSitekey, pdSiteInfo);
            }
        });
        return new ArrayList<SiteInfo>(siteInfoMap.values());
    }

    @Override
    public SitePlan querySitePlanBySiteId(String projectId, String siteId) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)siteId)) {
            LOG.error((Object)"ProjectId or siteId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        SitePlanQuery query = new SitePlanQuery();
        query.setProjectId(projectId);
        List<SitePlan> sitePlanList = this.querySitePlans(query);
        return sitePlanList.stream().filter(sitePlan -> sitePlan.getSiteId().equals(siteId)).findAny().orElse(null);
    }

    @Override
    public long getPreplanCountByRecoverPlanAndSiteId(String recoverPlanId, String siteId) {
        RecoverPreplanQuery query = new RecoverPreplanQuery();
        query.setPlanId(recoverPlanId);
        query.setSiteId(siteId);
        List<RecoverPreplan> preplanList = this.recoverPreplanDao.queryPreplans(query);
        preplanList.removeIf(preplan -> RecoverOperateType.PLANNED_MIGRATION.getValue().equals(preplan.getType()));
        return preplanList.size();
    }

    public SitePlanMapDao getSitePlanMapDao() {
        return this.sitePlanMapDao;
    }

    public void setSitePlanMapDao(SitePlanMapDao sitePlanMapDao) {
        this.sitePlanMapDao = sitePlanMapDao;
    }

    public SitePlanDao getSitePlanDao() {
        return this.sitePlanDao;
    }

    public void setSitePlanDao(SitePlanDao sitePlanDao) {
        this.sitePlanDao = sitePlanDao;
    }

    public SiteInfoDao getSiteInfoDao() {
        return this.siteInfoDao;
    }

    public void setSiteInfoDao(SiteInfoDao siteInfoDao) {
        this.siteInfoDao = siteInfoDao;
    }

    public RecoverPlanDaoImpl getRecoverPlanDao() {
        return this.recoverPlanDao;
    }

    public void setRecoverPlanDao(RecoverPlanDaoImpl recoverPlanDao) {
        this.recoverPlanDao = recoverPlanDao;
    }

    public RecoverLogDao getRecoverLogDao() {
        return this.recoverLogDao;
    }

    public void setRecoverLogDao(RecoverLogDao recoverLogDao) {
        this.recoverLogDao = recoverLogDao;
    }

    public ApplicationDao getApplicationDao() {
        return this.applicationDao;
    }

    public void setApplicationDao(ApplicationDao applicationDao) {
        this.applicationDao = applicationDao;
    }

    public RecoverPreplanDao getRecoverPreplanDao() {
        return this.recoverPreplanDao;
    }

    public void setRecoverPreplanDao(RecoverPreplanDao recoverPreplanDao) {
        this.recoverPreplanDao = recoverPreplanDao;
    }

    @Override
    public RecoverPlan getRecoverPlanByRecoverPlanId(String recoverPlanId) {
        if (VerifyUtil.isEmpty((String)recoverPlanId) || VerifyUtil.isEmpty((String)recoverPlanId)) {
            LOG.error((Object)"ProjectId or SitePlanId is empty");
            throw new LegoCheckedException(1073952400L);
        }
        return this.recoverPlanDao.getRecoverPlanById(recoverPlanId);
    }

    public RecoverFlowDao getRecoverFlowDao() {
        return this.recoverFlowDao;
    }

    public void setRecoverFlowDao(RecoverFlowDao recoverFlowDao) {
        this.recoverFlowDao = recoverFlowDao;
    }

    public ServiceInstanceDao getServiceInstanceDao() {
        return this.serviceInstanceDao;
    }

    public void setServiceInstanceDao(ServiceInstanceDao serviceInstanceDao) {
        this.serviceInstanceDao = serviceInstanceDao;
    }

    private void updateSitePlanStatusToNormal(String sitePlanId) {
        SitePlanMapQuery sitePlanMapQuery = new SitePlanMapQuery();
        sitePlanMapQuery.setSitePlanId(sitePlanId);
        sitePlanMapQuery.setPage(false);
        List<SitePlanMap> sitePlanMaps = this.sitePlanMapDao.queryPagedSitePlanMapBySitePlanId(sitePlanMapQuery);
        if (!VerifyUtil.isEmpty(sitePlanMaps) && this.recoverPreplanDao.getPrePlanCountByRecoverPlanIdSet(sitePlanMaps.stream().map(SitePlanMap::getRecoverPlanId).filter(Objects::nonNull).collect(Collectors.toSet())) > 0L) {
            LOG.warn((Object)"Preplan num of Siteplan '%s' is large than 0, do not update status.", new Object[]{sitePlanId});
            return;
        }
        SitePlan sitePlan = new SitePlan();
        sitePlan.setId(sitePlanId);
        sitePlan.setStatus(SitePlanStatus.NORMAL.getValue());
        this.sitePlanDao.updateSitePlan(sitePlan);
        LOG.info((Object)"Update status of SitePlan '%s' to normal.", new Object[]{sitePlanId});
    }
}

