/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.service.impl;

import com.huawei.csr.framework.checker.AppChecker;
import com.huawei.csr.framework.checker.LicenseChecker;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.service.QuotaService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Map;
import java.util.stream.Collectors;

@Service(Name="com.huawei.csr.framework.service.QuotaService", Interface=QuotaService.class, Desc="")
public class QuotaServiceImpl
extends BaseService
implements QuotaService {
    public static final String RESOURCE = "resource";
    public static final String USED = "used";
    private ApplicationDao applicationDao;

    @Override
    public JSONObject getAddInstancesServiceQuotaUsed(String projectId, Application application) {
        LicenseChecker.checkLicenseWithCount(application.getServiceInstances().size());
        AppChecker.checkAddServiceInstances(application.getServiceInstances(), projectId, application.getId());
        Map<String, Long> quotaNums = application.getServiceInstances().stream().collect(Collectors.groupingBy(AppServiceInstance::getServiceType, Collectors.counting()));
        JSONObject quotaApp = new JSONObject();
        quotaApp.put((Object)RESOURCE, (Object)"ark.instance.num");
        quotaApp.put((Object)USED, (Object)0.0);
        JSONArray quotaResourceList = new JSONArray();
        quotaResourceList.add((Object)quotaApp);
        return this.getQuotaObject(projectId, quotaNums, quotaResourceList);
    }

    @Override
    public JSONObject getAddApplicationQuotaUsed(String projectId, Application application) {
        LicenseChecker.checkLicenseWithCount(application.getServiceInstances().size());
        AppChecker.checkCreateApp(application);
        Map<String, Long> quotaNums = application.getServiceInstances().stream().collect(Collectors.groupingBy(AppServiceInstance::getServiceType, Collectors.counting()));
        JSONObject quotaApp = new JSONObject();
        quotaApp.put((Object)RESOURCE, (Object)"ark.app.num");
        quotaApp.put((Object)USED, (Object)1.0);
        JSONArray quotaResourceList = new JSONArray();
        quotaResourceList.add((Object)quotaApp);
        return this.getQuotaObject(projectId, quotaNums, quotaResourceList);
    }

    @Override
    public JSONObject checkCanRemoveInstance(String projectId, String applicationId) {
        Application application = this.applicationDao.getApp(applicationId, projectId);
        AppChecker.checkAppCanRemoveInstances(application);
        return this.getDeleteQuotaJsonObject(projectId);
    }

    @Override
    public JSONObject checkCanDeleteApplication(String projectId, String applicationId) {
        Application application = this.applicationDao.getApp(applicationId, projectId);
        AppChecker.checkDeleteApp(application);
        return this.getDeleteQuotaJsonObject(projectId);
    }

    private JSONObject getDeleteQuotaJsonObject(String projectId) {
        JSONObject quota = new JSONObject();
        JSONArray usagesList = new JSONArray();
        quota.put((Object)"project_id", (Object)projectId);
        quota.put((Object)"usages", (Object)usagesList);
        JSONArray quotas = new JSONArray();
        quotas.add((Object)quota);
        JSONObject returnJson = new JSONObject();
        returnJson.put((Object)"quotas", (Object)quotas);
        return returnJson;
    }

    private JSONObject getQuotaObject(String projectId, Map<String, Long> quotaNum, JSONArray quotaResourceList) {
        long sum = 0L;
        for (Long num : quotaNum.values()) {
            sum += num.longValue();
        }
        JSONObject quotaResource = new JSONObject();
        quotaResource.put((Object)RESOURCE, (Object)"ark.instance.num");
        quotaResource.put((Object)USED, (Object)sum);
        quotaResourceList.add((Object)quotaResource);
        JSONObject usage = new JSONObject();
        usage.put((Object)"resources", (Object)quotaResourceList);
        usage.put((Object)"service_id", (Object)"ark");
        JSONArray usagesList = new JSONArray();
        usagesList.add((Object)usage);
        JSONArray quotas = new JSONArray();
        JSONObject quota = new JSONObject();
        quota.put((Object)"project_id", (Object)projectId);
        quota.put((Object)"usages", (Object)usagesList);
        quotas.add((Object)quota);
        JSONObject returnJson = new JSONObject();
        returnJson.put((Object)"quotas", (Object)quotas);
        return returnJson;
    }

    public ApplicationDao getApplicationDao() {
        return this.applicationDao;
    }

    public void setApplicationDao(ApplicationDao applicationDao) {
        this.applicationDao = applicationDao;
    }
}

