/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.service.impl;

import com.huawei.csr.framework.checker.RecoverFlowChecker;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStageType;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.model.ApplicationQuery;
import com.huawei.csr.framework.common.model.RecoverFlowBo;
import com.huawei.csr.framework.common.model.RecoverFlowQuery;
import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.model.ServiceInstanceQuery;
import com.huawei.csr.framework.common.statusopt.StatusOptChecker;
import com.huawei.csr.framework.common.statusopt.opt.RecoverFlowOpt;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import com.huawei.csr.framework.common.utils.CollectionHelper;
import com.huawei.csr.framework.common.utils.LockUtil;
import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AppPluginManager;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.FlowStepMapDao;
import com.huawei.csr.framework.dao.RecoverFlowChainDao;
import com.huawei.csr.framework.dao.RecoverFlowDao;
import com.huawei.csr.framework.dao.StageFlowMapDao;
import com.huawei.csr.framework.dao.impl.ApplicationDaoImpl;
import com.huawei.csr.framework.dao.impl.FlowStepMapDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverFlowChainDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverFlowDaoImpl;
import com.huawei.csr.framework.dao.impl.StageFlowMapDaoImpl;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.FlowStepMap;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverFlowChain;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.RecoverStageService;
import com.huawei.csr.framework.service.RecoverStepService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service(Name="com.huawei.csr.framework.service.RecoverFlowService", Interface=RecoverFlowService.class, Desc="")
public class RecoverFlowServiceImpl
extends BaseService
implements RecoverFlowService {
    private static final Log LOGGER = LogFactory.getInstance(RecoverFlowServiceImpl.class);
    private static final String FLOW_OPER_TYPE = "createFlow";
    private RecoverFlowDao recoverFlowDao;
    private StageFlowMapDao stageFlowMapDao;
    private RecoverFlowChainDao recoverFlowChainDao;
    private ApplicationDao applicationDao;
    private FlowStepMapDao flowStepMapDao;

    @Override
    public String createFlow(final boolean isGenerateStep, final RecoverFlow recoverFlow) {
        LOGGER.debug((Object)"Start createFlow, name(%s).", new Object[]{recoverFlow.getName()});
        if (VerifyUtil.isEmpty((Object)recoverFlow) || VerifyUtil.isEmpty((String)recoverFlow.getProjectId()) || VerifyUtil.isEmpty((String)recoverFlow.getName()) || VerifyUtil.isEmpty((String)recoverFlow.getAppId())) {
            LOGGER.error((Object)"RecoverFlow or projectId or name is empty or null.");
            throw new LegoCheckedException(1073952400L);
        }
        if (!LockUtil.tryLock(FLOW_OPER_TYPE + recoverFlow.getAppId())) {
            LOGGER.error((Object)"Fetch Lock failed when create flow,projectId:'%s',appId:'%s'.", new Object[]{recoverFlow.getProjectId(), recoverFlow.getAppId()});
            throw new LegoCheckedException(-1L);
        }
        try {
            if (this.recoverFlowDao.getAllRecoverFlowCount() >= 15000L) {
                LOGGER.error((Object)"Recover flow count out of limit:%s.", 15000L);
                throw new LegoCheckedException(1073952602L, new String[]{String.valueOf(15000)});
            }
            if (VerifyUtil.isEmpty((Object)this.applicationDao.getApp(recoverFlow.getAppId()))) {
                LOGGER.error((Object)"App not exist,appId is '%s'.", new Object[]{recoverFlow.getAppId()});
                throw new LegoCheckedException(1073952008L);
            }
            RecoverFlowChecker.checkSingleAppFlowNumLimit(recoverFlow.getAppId());
            RecoverFlowChecker.checkFlowNameExistInProject(recoverFlow.getProjectId(), recoverFlow.getName());
            recoverFlow.setStatus(RecoverStatus.NORMAL.getValue());
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    RecoverFlowServiceImpl.this.recoverFlowDao.save(recoverFlow);
                    if (isGenerateStep) {
                        RecoverFlowServiceImpl.this.createDefaultStep(recoverFlow);
                    }
                }
            });
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Create flow failed, error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Create flow failed, error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
        finally {
            LockUtil.unLock(FLOW_OPER_TYPE + recoverFlow.getAppId());
        }
        return recoverFlow.getId();
    }

    @Override
    public void createDefaultStep(RecoverFlow recoverFlow) {
        LOGGER.debug((Object)"Start createDefaultStep, name(%s).", new Object[]{recoverFlow.getName()});
        RecoverStepService stepService = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        ServiceInstanceQuery instanceQuery = new ServiceInstanceQuery();
        instanceQuery.setProjectId(recoverFlow.getProjectId());
        instanceQuery.setFlowId(recoverFlow.getId());
        List<AppServiceInstance> instanceList = ((AppService)ServiceLocator.getInstance().getService(AppService.class)).queryNotInFlowInstanceList(instanceQuery);
        for (AppServiceInstance instance : instanceList) {
            if (!ServiceInstanceStatus.NORMAL.getValue().equals(instance.getStatus())) {
                LOGGER.warn((Object)"Instance can not create step when status not normal.Instance id is '%s'.", new Object[]{instance.getId()});
                continue;
            }
            Optional<RecoverStepAction> defaultActionOptional = AppPluginManager.getInstance().getAppManager(new AppIdentifier(instance.getServiceType())).getServiceInstanceDefaultAction(RecoverOperateType.from(recoverFlow.getType()));
            if (!defaultActionOptional.isPresent()) {
                LOGGER.info((Object)"Instance '%s' no default step when service type is '%s',flow type is '%s'.", new Object[]{instance.getId(), instance.getServiceType(), recoverFlow.getType()});
                continue;
            }
            RecoverStepQuery stepQuery = new RecoverStepQuery();
            stepQuery.setInstanceId(instance.getId());
            if (stepService.getRecoverStepCount(stepQuery) >= 60L) {
                LOGGER.warn((Object)"Recover Step of single instance out of limit, instance id is '%s'", new Object[]{instance.getId()});
                continue;
            }
            RecoverStep defaultStep = new RecoverStep();
            defaultStep.setProjectId(recoverFlow.getProjectId());
            defaultStep.setName(UUIDGenerator.getUUID());
            defaultStep.setExpectRTO(1L);
            defaultStep.setServiceInstanceId(instance.getId());
            defaultStep.setServiceType(instance.getServiceType());
            defaultStep.setAction(defaultActionOptional.get().getValue());
            defaultStep.setStatus(RecoverStatus.NORMAL.getValue());
            defaultStep.setIsValid(true);
            String defaultStepId = stepService.createRecoverStep(recoverFlow.getProjectId(), defaultStep);
            stepService.addStepToFlow(recoverFlow.getProjectId(), recoverFlow.getId(), defaultStepId);
        }
    }

    @Override
    public void updateFlow(final RecoverFlowBo flowBo) {
        LOGGER.debug((Object)"Start updateFlow, flowId(%s).", new Object[]{flowBo.getFlowId()});
        if (VerifyUtil.isEmpty((Object)flowBo) || VerifyUtil.isEmpty((String)flowBo.getProjectId()) || VerifyUtil.isEmpty((String)flowBo.getFlowId())) {
            LOGGER.error((Object)"RecoverFlowBo or projectId or flowId is empty or null.");
            throw new LegoCheckedException(1073952400L);
        }
        RecoverFlowChecker.checkRecoverFlowExist(flowBo.getFlowId());
        try {
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    RecoverFlowServiceImpl.this.updateFlowName(flowBo);
                    RecoverFlowServiceImpl.this.updateAppIdAndType(flowBo);
                }
            });
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Update flow failed, flowId is '%s', error:%s.", new Object[]{flowBo.getFlowId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Update flow failed, flowId is '%s', error:%s.", new Object[]{flowBo.getFlowId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
    }

    private void updateAppIdAndType(RecoverFlowBo flowBo) {
        String projectId = flowBo.getProjectId();
        String flowId = flowBo.getFlowId();
        String appId = flowBo.getAppId();
        String operationType = flowBo.getOperationType();
        String flowName = flowBo.getFlowName();
        if (!VerifyUtil.isEmpty((String)appId)) {
            RecoverFlowChecker.checkSingleAppFlowNumLimit(appId);
        }
        if (!VerifyUtil.isEmpty((Object)flowBo.getGenerateStep())) {
            if (!VerifyUtil.isEmpty((String)appId) || !VerifyUtil.isEmpty((String)operationType)) {
                RecoverFlowChecker.checkFlowIsRelateStage(flowId);
            }
            RecoverFlow flow = this.getRecoverFlowById(flowId);
            if (!RecoverStatus.NORMAL.getValue().equals(flow.getStatus())) {
                LOGGER.error((Object)"Flow can not update appId and type when status not normal.flowId is '%s'.", new Object[]{flowId});
                throw new LegoCheckedException(1073952403L);
            }
            flow.setProjectId(projectId);
            flow.setId(flowId);
            if (!VerifyUtil.isEmpty((String)appId)) {
                flow.setAppId(appId);
            }
            if (!VerifyUtil.isEmpty((String)operationType)) {
                flow.setType(operationType);
            }
            if (!VerifyUtil.isEmpty((String)flowName)) {
                flow.setName(flowName);
            }
            this.recoverFlowDao.update(flow);
            this.removeFlowStepMapAndDelSingleStep(projectId, flowId);
            if (flowBo.getGenerateStep().booleanValue()) {
                this.createDefaultStep(flow);
            }
        }
    }

    private void updateFlowName(RecoverFlowBo flowBo) {
        String projectId = flowBo.getProjectId();
        String flowId = flowBo.getFlowId();
        String flowName = flowBo.getFlowName();
        RecoverFlow oldFlow = this.getRecoverFlowById(flowId);
        if (!VerifyUtil.isEmpty((String)flowName) && !oldFlow.getName().equals(flowName)) {
            StatusOptChecker.checkRecoverFlowStatusOpt(RecoverStatus.from(oldFlow.getStatus()).getIndex(), RecoverFlowOpt.UPDATE.getIndex(), 1073952403L);
            RecoverFlowChecker.checkFlowNameExistInProject(projectId, flowName);
            RecoverFlow recoverFlow = new RecoverFlow();
            recoverFlow.setProjectId(projectId);
            recoverFlow.setId(flowId);
            recoverFlow.setName(flowName);
            this.recoverFlowDao.update(recoverFlow);
        }
    }

    @Override
    public void deleteFlow(final String projectId, final String flowId, final String preplanId) {
        LOGGER.debug((Object)"Start deleteFlow, flowId(%s).", new Object[]{flowId});
        RecoverFlowChecker.checkFlowId(flowId);
        RecoverFlowChecker.checkRecoverFlowExist(flowId);
        try {
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    StatusOptChecker.checkRecoverFlowStatusOpt(RecoverStatus.from(RecoverFlowServiceImpl.this.getRecoverFlowById(flowId).getStatus()).getIndex(), RecoverFlowOpt.DELETE.getIndex(), 1073952403L);
                    if (VerifyUtil.isEmpty((String)preplanId)) {
                        RecoverFlowServiceImpl.this.removeFlowWithoutPreplanId(projectId, flowId);
                    } else {
                        RecoverFlowServiceImpl.this.removeFlowWithPreplanId(flowId, preplanId);
                    }
                    if (RecoverFlowServiceImpl.this.stageFlowMapDao.getStageFlowMapCountByFlowId(flowId) == 0L) {
                        RecoverFlowServiceImpl.this.recoverFlowDao.delete(projectId, flowId);
                        RecoverFlowServiceImpl.this.removeFlowStepMapAndDelSingleStep(projectId, flowId);
                    }
                }
            });
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Delete flow failed, flowId is '%s', preplanId is '%s', error:%s.", new Object[]{flowId, preplanId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Delete flow failed, flowId is '%s', preplanId is '%s', error:%s.", new Object[]{flowId, preplanId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
    }

    private void removeFlowWithPreplanId(String flowId, String preplanId) {
        Optional<StageFlowMap> stageFlowMapOptional = this.stageFlowMapDao.queryStageFlowMapByFlowIdAndPreplanId(flowId, preplanId);
        if (!stageFlowMapOptional.isPresent()) {
            LOGGER.error((Object)"StageFlowMap not exist.flowId is '%s',preplanId is '%s'", new Object[]{flowId, preplanId});
            throw new LegoCheckedException(1073952612L, new String[]{this.getRecoverFlowById(flowId).getName()});
        }
        String stageId = stageFlowMapOptional.get().getStageId();
        this.stageFlowMapDao.removeFlowFromStage(stageId, flowId);
        RecoverFlowChain preChain = new RecoverFlowChain();
        preChain.setStageId(stageId);
        preChain.setPreFlowId(flowId);
        this.recoverFlowChainDao.delete(preChain);
        RecoverFlowChain nextChain = new RecoverFlowChain();
        nextChain.setStageId(stageId);
        nextChain.setNextFlowId(flowId);
        this.recoverFlowChainDao.delete(nextChain);
    }

    private void removeFlowWithoutPreplanId(String projectId, String flowId) {
        List<String> stageIdList = this.queryStageIdListByFlowId(projectId, flowId);
        this.stageFlowMapDao.batchRemoveFlowFromStageByFlowId(flowId);
        this.recoverFlowChainDao.batchDeleteByFlowId(flowId);
        stageIdList.removeIf(stageId -> this.stageFlowMapDao.getStageFlowMapCountByStageId((String)stageId) > 0L);
        RecoverPreplanService preplanService = (RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class);
        stageIdList.forEach(stageId -> {
            String preplanId = preplanService.queryPreplanByStageId((String)stageId).getId();
            RecoverFlowQuery existQuery = new RecoverFlowQuery();
            existQuery.setPrePlanId(preplanId);
            if (this.recoverFlowDao.queryRecoverFlowsCount(existQuery) == 0) {
                preplanService.deletePreplan(projectId, preplanId);
            } else {
                this.delStageWhenPreOrNextUnsuspend(projectId, (String)stageId);
            }
        });
    }

    private void delStageWhenPreOrNextUnsuspend(String projectId, String stageId) {
        RecoverStageService stageService = (RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class);
        RecoverStage stage = stageService.getStageById(stageId);
        boolean isPreStageSuspend = false;
        boolean isNextStageSuspend = false;
        if (!VerifyUtil.isEmpty((String)stage.getPreStageId())) {
            RecoverStage preStage = stageService.getStageById(stage.getPreStageId());
            isPreStageSuspend = RecoverStageType.SUSPEND.getValue().equals(preStage.getType());
        }
        if (!VerifyUtil.isEmpty((String)stage.getNextStageId())) {
            RecoverStage nextStage = stageService.getStageById(stage.getNextStageId());
            isNextStageSuspend = RecoverStageType.SUSPEND.getValue().equals(nextStage.getType());
        }
        if (!isPreStageSuspend || !isNextStageSuspend) {
            stageService.deleteStage(projectId, stageId);
        }
    }

    private void removeFlowStepMapAndDelSingleStep(String projectId, String flowId) {
        List<FlowStepMap> flowStepMapList = this.flowStepMapDao.queryFlowStepMapByFlowId(flowId);
        RecoverStepService stepService = (RecoverStepService)ServiceLocator.getInstance().getService(RecoverStepService.class);
        flowStepMapList.forEach(flowStepMap -> {
            String stepId = flowStepMap.getRecoverStepId();
            RecoverStepQuery recoverStepQuery = new RecoverStepQuery();
            recoverStepQuery.setProjectId(projectId);
            recoverStepQuery.setStepId(stepId);
            stepService.removeStepFromFlow(projectId, flowId, stepId);
            if (this.flowStepMapDao.getStepMapCountByStepId(stepId) == 0L) {
                stepService.deleteRecoverStep(recoverStepQuery);
            }
        });
    }

    @Override
    public RecoverFlow getRecoverFlowById(String flowId) {
        return this.recoverFlowDao.getRecoverFlowById(flowId);
    }

    @Override
    public List<RecoverFlow> queryRecoverFlowList(RecoverFlowQuery recoverFlowQuery) {
        return this.recoverFlowDao.queryRecoverFlows(recoverFlowQuery);
    }

    @Override
    public long queryRecoverFlowCount(RecoverFlowQuery recoverFlowQuery) {
        return this.recoverFlowDao.queryRecoverFlowsCount(recoverFlowQuery);
    }

    @Override
    public Pair<List<RecoverFlow>, Long> queryRecoverFlowListNotInPreplan(RecoverFlowQuery notInQuery) {
        Set<String> allAppIdSet;
        if (VerifyUtil.isEmpty((Object)notInQuery) || VerifyUtil.isEmpty((String)notInQuery.getPrePlanId())) {
            LOGGER.error((Object)"Query or preplanId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        RecoverPreplan preplan = ((RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class)).queryPreplanById(notInQuery.getPrePlanId());
        RecoverFlowQuery allQuery = new RecoverFlowQuery();
        allQuery.setProjectId(notInQuery.getProjectId());
        allQuery.setType(preplan.getType());
        allQuery.setStatus(notInQuery.getStatus());
        allQuery.setFlowName(notInQuery.getFlowName());
        allQuery.setAppName(notInQuery.getAppName());
        List<RecoverFlow> allFlowList = this.recoverFlowDao.queryRecoverFlows(allQuery);
        RecoverFlowQuery existQuery = new RecoverFlowQuery();
        existQuery.setProjectId(notInQuery.getProjectId());
        existQuery.setPrePlanId(notInQuery.getPrePlanId());
        List<RecoverFlow> existFlowList = this.recoverFlowDao.queryRecoverFlows(existQuery);
        if (existFlowList.size() > 0) {
            allFlowList = CollectionHelper.of(allFlowList).subtract(existFlowList).keyProvider(RecoverFlow::getAppId).collect(Collectors.toList());
        }
        if ((allAppIdSet = this.getAllAppIdBySiteIdAndPlanId(notInQuery.getProjectId(), preplan.getSiteId(), preplan.getRecoverPlanId())).size() > 0) {
            allFlowList.removeIf(flow -> !allAppIdSet.contains(flow.getAppId()));
        }
        allFlowList.removeIf(flow -> this.isFlowStepInstanceNotInPreplanSite(flow.getId(), preplan.getSiteId()));
        ArrayList<RecoverFlow> page = new ArrayList<RecoverFlow>(allFlowList.subList(Math.min(notInQuery.getMarker(), allFlowList.size()), Math.min(notInQuery.getMarker() + notInQuery.getLimit(), allFlowList.size())));
        return Pair.of(page, (Object)allFlowList.size());
    }

    private Set<String> getAllAppIdBySiteIdAndPlanId(String projectId, String siteId, String planId) {
        ApplicationQuery appQuery = new ApplicationQuery();
        appQuery.setProjectId(projectId);
        appQuery.setSiteId(siteId);
        appQuery.setPlanId(planId);
        List<Application> appList = this.applicationDao.getAppList(appQuery);
        HashSet<String> appIdSet = new HashSet<String>();
        appList.forEach(application -> appIdSet.add(application.getId()));
        return appIdSet;
    }

    private boolean isFlowStepInstanceNotInPreplanSite(String flowId, String siteId) {
        long totalStepCount = this.flowStepMapDao.getStepMapCountByFlowId(flowId);
        return totalStepCount > 0L && totalStepCount > this.flowStepMapDao.getStepMapCountByFlowIdAndSiteId(flowId, siteId);
    }

    @Override
    public List<String> queryStageIdListByFlowId(String projectId, String flowId) {
        RecoverFlowChecker.checkFlowId(flowId);
        List<StageFlowMap> stageFlowMapList = this.stageFlowMapDao.queryStageFlowMapByFlowId(flowId);
        ArrayList<String> stageIdList = new ArrayList<String>();
        for (StageFlowMap stageFlowMap : stageFlowMapList) {
            stageIdList.add(stageFlowMap.getStageId());
        }
        return stageIdList;
    }

    @Override
    public long getStageFlowMapCount(String stageId, String flowId) {
        return this.stageFlowMapDao.getStageFlowMapCount(stageId, flowId);
    }

    @Override
    public long getStageFlowMapCountByFlowId(String flowId) {
        return this.stageFlowMapDao.getStageFlowMapCountByFlowId(flowId);
    }

    @Override
    public List<String> queryPreFlowIdList(String stageId, String flowId) {
        RecoverFlowChecker.checkFlowId(flowId);
        List<RecoverFlowChain> flowChainList = this.recoverFlowChainDao.getPreFlowChainList(stageId, flowId);
        ArrayList<String> preFlowIdList = new ArrayList<String>();
        for (RecoverFlowChain recoverFlowChain : flowChainList) {
            preFlowIdList.add(recoverFlowChain.getPreFlowId());
        }
        return preFlowIdList;
    }

    @Override
    public RecoverFlowChain getRecoverFlowChain(RecoverFlowChain recoverFlowChain) {
        return this.recoverFlowChainDao.queryFlowChain(recoverFlowChain);
    }

    @Override
    public long getFlowChainCountByFlowId(String flowId) {
        return this.recoverFlowChainDao.getFlowChainCountByFlowId(flowId);
    }

    public RecoverFlowDao getRecoverFlowDao() {
        return this.recoverFlowDao;
    }

    public void setRecoverFlowDao(RecoverFlowDaoImpl recoverFlowDao) {
        this.recoverFlowDao = recoverFlowDao;
    }

    public StageFlowMapDao getStageFlowMapDao() {
        return this.stageFlowMapDao;
    }

    public void setStageFlowMapDao(StageFlowMapDaoImpl stageFlowMapDao) {
        this.stageFlowMapDao = stageFlowMapDao;
    }

    public RecoverFlowChainDao getRecoverFlowChainDao() {
        return this.recoverFlowChainDao;
    }

    public void setRecoverFlowChainDao(RecoverFlowChainDaoImpl recoverFlowChainDao) {
        this.recoverFlowChainDao = recoverFlowChainDao;
    }

    public ApplicationDao getApplicationDao() {
        return this.applicationDao;
    }

    public void setApplicationDao(ApplicationDaoImpl applicationDao) {
        this.applicationDao = applicationDao;
    }

    public FlowStepMapDao getFlowStepMapDao() {
        return this.flowStepMapDao;
    }

    public void setFlowStepMapDao(FlowStepMapDaoImpl flowStepMapDao) {
        this.flowStepMapDao = flowStepMapDao;
    }
}

