/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.service.impl;

import com.huawei.csr.framework.checker.RecoverPreplanChecker;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStageType;
import com.huawei.csr.framework.common.model.ApplicationQuery;
import com.huawei.csr.framework.common.model.RecoverFlowQuery;
import com.huawei.csr.framework.common.model.RecoverPlanQuery;
import com.huawei.csr.framework.common.model.RecoverPreplanBo;
import com.huawei.csr.framework.common.model.RecoverPreplanQuery;
import com.huawei.csr.framework.common.model.RecoverStageBo;
import com.huawei.csr.framework.common.statusopt.StatusOptChecker;
import com.huawei.csr.framework.common.statusopt.opt.RecoverPreplanOpt;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.common.utils.LockUtil;
import com.huawei.csr.framework.common.utils.RecoverPlanUtil;
import com.huawei.csr.framework.common.utils.ResourceUpdateUtil;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.RecoverPlanDao;
import com.huawei.csr.framework.dao.RecoverPreplanDao;
import com.huawei.csr.framework.dao.SiteInfoDao;
import com.huawei.csr.framework.dao.SitePlanDao;
import com.huawei.csr.framework.dao.SitePlanMapDao;
import com.huawei.csr.framework.dao.impl.ApplicationDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPlanDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPreplanDaoImpl;
import com.huawei.csr.framework.dao.impl.SiteInfoDaoImpl;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverPlan;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.SiteInfo;
import com.huawei.csr.framework.dao.model.SitePlan;
import com.huawei.csr.framework.dao.model.SitePlanMap;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.RecoverStageService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service(Name="com.huawei.csr.framework.service.RecoverPreplanService", Interface=RecoverPreplanService.class, Desc="")
public class RecoverPreplanServiceImpl
extends BaseService
implements RecoverPreplanService {
    private static final Log LOG = LogFactory.getInstance(RecoverPreplanServiceImpl.class);
    private static final String PREPLAN_OPER_TYPE = "createPreplan";
    private ApplicationDao applicationDao;
    private SiteInfoDao siteInfoDao;
    private SitePlanMapDao sitePlanMapDao;
    private SitePlanDao sitePlanDao;
    private RecoverPreplanDao recoverPreplanDao;
    private RecoverPlanDao recoverPlanDao;

    private void checkNewPreplanIsAbleBeCreated(RecoverPreplan recoverPreplan) {
        if (this.recoverPreplanDao.getAllRecoverPreplanCount() >= 3000L) {
            LOG.error((Object)"Recover preplan count out of limit.");
            throw new LegoCheckedException(1073952806L, new String[]{String.valueOf(3000)});
        }
        RecoverPreplanChecker.checkPreplanNameExistInRecoverPlan(recoverPreplan.getRecoverPlanId(), recoverPreplan.getName());
        RecoverPreplanChecker.checkPreplanTypeOutOfLimit(recoverPreplan);
        List<SiteInfo> siteInfoList = this.siteInfoDao.getSiteOfAppByRecoverPlanId(recoverPreplan.getProjectId(), recoverPreplan.getRecoverPlanId());
        if (siteInfoList.size() == 0) {
            LOG.error((Object)"SiteInfo of Recover Plan empty.The planId is '%s'", new Object[]{recoverPreplan.getRecoverPlanId()});
            RecoverPlan recoverPlan = this.recoverPlanDao.getRecoverPlanById(recoverPreplan.getRecoverPlanId());
            throw new LegoCheckedException(1073952108L, new String[]{recoverPlan.getName()});
        }
        if (siteInfoList.stream().noneMatch(siteInfo -> siteInfo.getSiteId().equals(recoverPreplan.getSiteId()))) {
            LOG.error((Object)"SiteInfo of Recover Plan not exists.The siteId is '%s'", new Object[]{recoverPreplan.getSiteId()});
            throw new LegoCheckedException(1073952204L);
        }
    }

    @Override
    public String createPreplan(final boolean isDefaultProcess, final RecoverPreplan recoverPreplan) {
        LOG.debug((Object)"Start createPreplan, siteId(%s), recoverPlanId(%s), name(%s).", new Object[]{recoverPreplan.getSiteId(), recoverPreplan.getRecoverPlanId(), recoverPreplan.getName()});
        if (VerifyUtil.isEmpty((Object)recoverPreplan) || VerifyUtil.isEmpty((String)recoverPreplan.getProjectId()) || VerifyUtil.isEmpty((String)recoverPreplan.getSiteId()) || VerifyUtil.isEmpty((String)recoverPreplan.getRecoverPlanId())) {
            LOG.error((Object)"Preplan or recoverPlanId or siteId is empty or null.");
            throw new LegoCheckedException(1073952400L);
        }
        if (!LockUtil.tryLock(PREPLAN_OPER_TYPE + recoverPreplan.getRecoverPlanId())) {
            LOG.error((Object)"Fetch Lock failed when create preplan,projectId:'%s',siteId:'%s',planId:'%s'.", new Object[]{recoverPreplan.getProjectId(), recoverPreplan.getSiteId(), recoverPreplan.getRecoverPlanId()});
            throw new LegoCheckedException(-1L);
        }
        try {
            this.checkNewPreplanIsAbleBeCreated(recoverPreplan);
            recoverPreplan.setStatus(RecoverStatus.NORMAL.getValue());
            recoverPreplan.setIsValid(true);
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    RecoverPreplanServiceImpl.this.recoverPreplanDao.save(recoverPreplan);
                    if (isDefaultProcess) {
                        RecoverPreplanServiceImpl.this.createDefaultStage(recoverPreplan);
                    }
                }
            });
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Create preplan failed, projectId:'%s',siteId:'%s',planId:'%s', error:%s.", new Object[]{recoverPreplan.getProjectId(), recoverPreplan.getSiteId(), recoverPreplan.getRecoverPlanId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Create preplan failed, projectId:'%s',siteId:'%s',planId:'%s', error:%s.", new Object[]{recoverPreplan.getProjectId(), recoverPreplan.getSiteId(), recoverPreplan.getRecoverPlanId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
        finally {
            LockUtil.unLock(PREPLAN_OPER_TYPE + recoverPreplan.getRecoverPlanId());
        }
        return recoverPreplan.getId();
    }

    private void createDefaultStage(RecoverPreplan preplan) {
        RecoverStageBo stageBo = new RecoverStageBo();
        stageBo.setStageName("defaultStage");
        stageBo.setStageType(RecoverStageType.UNSUSPEND.getValue());
        stageBo.setProjectId(preplan.getProjectId());
        stageBo.setPrePlanId(preplan.getId());
        RecoverStageService stageService = (RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class);
        String defaultStageId = stageService.createStage(stageBo);
        ApplicationQuery appQuery = new ApplicationQuery();
        appQuery.setProjectId(preplan.getProjectId());
        appQuery.setPlanId(preplan.getRecoverPlanId());
        appQuery.setPrePlanId(preplan.getId());
        appQuery.setSiteId(preplan.getSiteId());
        List<Application> applicationList = this.applicationDao.getAppList(appQuery);
        RecoverFlowService flowService = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
        for (Application application : applicationList) {
            String appId = application.getId();
            RecoverFlowQuery flowQuery = new RecoverFlowQuery();
            flowQuery.setAppId(appId);
            if (flowService.queryRecoverFlowCount(flowQuery) >= 60L) {
                LOG.warn((Object)"Recover flow of single app out of limit, appid is '%s'.", new Object[]{appId});
                continue;
            }
            RecoverFlow defaultFlow = new RecoverFlow();
            defaultFlow.setProjectId(preplan.getProjectId());
            defaultFlow.setName(UUIDGenerator.getUUID());
            defaultFlow.setAppId(appId);
            defaultFlow.setType(preplan.getType());
            String defaultFlowId = flowService.createFlow(false, defaultFlow);
            stageService.addFlowToStage(defaultStageId, defaultFlowId);
            flowService.createDefaultStep(flowService.getRecoverFlowById(defaultFlowId));
        }
    }

    @Override
    public void updatePreplan(final RecoverPreplanBo preplanBo) {
        LOG.debug((Object)"Start updatePreplan,recoverPreplanId(%s).", new Object[]{preplanBo.getRecoverPreplanId()});
        try {
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    RecoverPreplan preplan = RecoverPreplanServiceImpl.this.queryPreplanById(preplanBo.getRecoverPreplanId());
                    RecoverPreplanServiceImpl.this.updatePreplanBasicInfo(preplan, preplanBo);
                    RecoverPreplanServiceImpl.this.updatePreplanProcess(preplan, preplanBo);
                }
            });
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Update preplan failed, preplanId is '%s', error:%s.", new Object[]{preplanBo.getRecoverPreplanId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Update preplan failed, preplanId is '%s', error:%s.", new Object[]{preplanBo.getRecoverPreplanId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
    }

    private void updatePreplanProcess(RecoverPreplan preplan, RecoverPreplanBo preplanBo) {
        if (!VerifyUtil.isEmpty((Object)preplanBo.isGenerateDefaultProcess()) && preplanBo.isGenerateDefaultProcess().booleanValue()) {
            StatusOptChecker.checkRecoverPreplanStatusOpt(RecoverStatus.from(preplan.getStatus()).getIndex(), RecoverPreplanOpt.MODIFY_PREPLAN.getIndex(), 1073952403L);
            this.delStageAndUpdatePlanStatus(preplanBo.getProjectId(), preplan);
            if (!RecoverStatus.NORMAL.getValue().equals(preplan.getStatus())) {
                preplan.setStatus(RecoverStatus.NORMAL.getValue());
                this.recoverPreplanDao.update(preplan);
            }
            this.createDefaultStage(preplan);
        }
    }

    private void updatePreplanBasicInfo(RecoverPreplan preplan, RecoverPreplanBo preplanBo) {
        String newName = preplanBo.getName();
        if (!VerifyUtil.isEmpty((String)newName) && !preplan.getName().equals(newName)) {
            StatusOptChecker.checkRecoverPreplanStatusOpt(RecoverStatus.from(preplan.getStatus()).getIndex(), RecoverPreplanOpt.MODIFY_INFO.getIndex(), 1073952403L);
            RecoverPreplanChecker.checkPreplanNameExistInRecoverPlan(preplanBo.getPlanId(), newName);
            preplan.setName(newName);
        }
        if (preplanBo.getExpectRTO() > 0L) {
            preplan.setExpectRTO(preplanBo.getExpectRTO());
        }
        preplan.setDescription(preplanBo.getDescription());
        this.recoverPreplanDao.update(preplan);
    }

    @Override
    public void deletePreplan(final String projectId, final String preplanId) {
        LOG.debug((Object)"Start updatePreplan,preplanId(%s).", new Object[]{preplanId});
        final RecoverPreplan preplan = this.queryPreplanById(preplanId);
        StatusOptChecker.checkRecoverPreplanStatusOpt(RecoverStatus.from(preplan.getStatus()).getIndex(), RecoverPreplanOpt.DELETE.getIndex(), 1073952403L);
        try {
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    RecoverPreplanServiceImpl.this.recoverPreplanDao.delete(projectId, preplanId);
                    RecoverPreplanServiceImpl.this.delStageAndUpdatePlanStatus(projectId, preplan);
                }
            });
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Delete preplan failed, preplanId is '%s', error:%s.", new Object[]{preplanId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Delete preplan failed, preplanId is '%s', error:%s.", new Object[]{preplanId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
    }

    private void delStageAndUpdatePlanStatus(String projectId, RecoverPreplan preplan) {
        RecoverStageService stageService = (RecoverStageService)ServiceLocator.getInstance().getService(RecoverStageService.class);
        List<RecoverStage> stageList = stageService.getStageList(projectId, preplan.getId());
        stageList.forEach(stage -> stageService.deleteStage(projectId, stage.getId()));
        if (RecoverPlanUtil.getFailedStatus(RecoverOperateType.from(preplan.getType())).getValue().equals(preplan.getStatus()) || this.noExistSameTypePreplan(preplan)) {
            RecoverPlan plan = this.recoverPlanDao.getRecoverPlanById(preplan.getRecoverPlanId());
            boolean drFlag = RecoverOperateType.REPROTECT.getValue().equals(preplan.getType()) && !VerifyUtil.isEmpty(ResourceUpdateUtil.getSameSiteDrPreplanList(preplan));
            String planOldStatus = plan.getStatus();
            plan.setStatus(drFlag ? RecoverStatus.DISASTER_RECOVERY_COMPLETED.getValue() : RecoverStatus.NORMAL.getValue());
            this.recoverPlanDao.updatePlanBasicInfo(plan);
            this.checkSitePlanStatusAndUpdate(plan, planOldStatus, preplan);
        }
    }

    private void checkSitePlanStatusAndUpdate(RecoverPlan plan, String planOldStatus, RecoverPreplan preplan) {
        List<SitePlanMap> sitePlanMaps = this.sitePlanMapDao.querySitePlanMapByRecoverPlanId(plan.getId());
        if (VerifyUtil.isEmpty(sitePlanMaps)) {
            LOG.info((Object)"Preplan(%s) of recoverPlan(%s) not relate with sitePlan, no need update siteplan status.", new Object[]{preplan.getId(), plan.getId()});
            return;
        }
        for (SitePlanMap sitePlanMap : sitePlanMaps) {
            SitePlan sitePlan = this.sitePlanDao.querySitePlan(preplan.getProjectId(), sitePlanMap.getSitePlanId());
            if (!preplan.getSiteId().equals(sitePlan.getSiteId()) || !planOldStatus.equals(sitePlan.getStatus())) continue;
            RecoverPlanQuery planQuery = new RecoverPlanQuery();
            planQuery.setSitePlanId(sitePlan.getId());
            List<RecoverPlan> planList = this.recoverPlanDao.queryPlans(planQuery, null);
            boolean cleanFlag = planList.stream().noneMatch(recoverPlan -> {
                RecoverPreplanQuery query = new RecoverPreplanQuery();
                query.setProjectId(preplan.getProjectId());
                query.setPlanId(recoverPlan.getId());
                query.setSiteId(preplan.getSiteId());
                query.setPreplanType(preplan.getType());
                return this.queryPreplansCount(query) > 0;
            });
            if (!cleanFlag) break;
            LOG.info((Object)"Preplan(%s) of recoverPlan(%s) of sitePlan(%s) no other %s preplan,update status to %s", new Object[]{preplan.getId(), plan.getId(), sitePlan.getId(), preplan.getType(), plan.getStatus()});
            sitePlan.setStatus(plan.getStatus());
            this.sitePlanDao.updateSitePlan(sitePlan);
            break;
        }
    }

    private boolean noExistSameTypePreplan(RecoverPreplan preplan) {
        RecoverPreplanQuery preplanQuery = new RecoverPreplanQuery();
        preplanQuery.setProjectId(preplan.getProjectId());
        preplanQuery.setPlanId(preplan.getRecoverPlanId());
        preplanQuery.setPreplanType(preplan.getType());
        return RecoverStatus.NORMAL.getValue().equals(preplan.getStatus()) && this.recoverPreplanDao.queryPreplansCount(preplanQuery) == 0;
    }

    @Override
    public RecoverPreplan queryPreplanById(String preplanId) {
        Optional<RecoverPreplan> recoverPreplanOptional = this.recoverPreplanDao.queryPreplanById(preplanId);
        if (!recoverPreplanOptional.isPresent()) {
            LOG.error((Object)"Recover preplan is not exists. The preplanId is '%s'.", new Object[]{preplanId});
            throw new LegoCheckedException(1073952800L);
        }
        return recoverPreplanOptional.get();
    }

    @Override
    public RecoverPreplan queryPreplanByStageId(String stageId) {
        Optional<RecoverPreplan> recoverPreplanOptional = this.recoverPreplanDao.queryPreplanByStageId(stageId);
        if (!recoverPreplanOptional.isPresent()) {
            LOG.error((Object)"Recover preplan is not exists. The stageId is '%s'.", new Object[]{stageId});
            throw new LegoCheckedException(1073952800L);
        }
        return recoverPreplanOptional.get();
    }

    @Override
    public List<RecoverPreplan> queryPreplans(RecoverPreplanQuery recoverPreplanQuery) {
        return this.recoverPreplanDao.queryPreplans(recoverPreplanQuery);
    }

    @Override
    public int queryPreplansCount(RecoverPreplanQuery recoverPreplanQuery) {
        return this.recoverPreplanDao.queryPreplansCount(recoverPreplanQuery);
    }

    @Override
    public boolean isApplicationProtectedByPreplan(RecoverPreplanBo preplanBo) {
        return this.recoverPreplanDao.isApplicationProtectedByPreplan(preplanBo.getApplicationId(), preplanBo.getRecoverPreplanId());
    }

    @Override
    public Set<String> queryPreplansSiteByFlowId(String flowId) {
        List<RecoverPreplan> preplanList = this.recoverPreplanDao.queryPreplansListByFlowId(flowId);
        HashSet<String> siteSet = new HashSet<String>();
        preplanList.forEach(preplan -> siteSet.add(preplan.getSiteId()));
        return siteSet;
    }

    public ApplicationDao getApplicationDao() {
        return this.applicationDao;
    }

    public void setApplicationDao(ApplicationDaoImpl applicationDao) {
        this.applicationDao = applicationDao;
    }

    public SiteInfoDao getSiteInfoDao() {
        return this.siteInfoDao;
    }

    public void setSiteInfoDao(SiteInfoDaoImpl siteInfoDao) {
        this.siteInfoDao = siteInfoDao;
    }

    public SitePlanMapDao getSitePlanMapDao() {
        return this.sitePlanMapDao;
    }

    public void setSitePlanMapDao(SitePlanMapDao sitePlanMapDao) {
        this.sitePlanMapDao = sitePlanMapDao;
    }

    public SitePlanDao getSitePlanDao() {
        return this.sitePlanDao;
    }

    public void setSitePlanDao(SitePlanDao sitePlanDao) {
        this.sitePlanDao = sitePlanDao;
    }

    public RecoverPreplanDao getRecoverPreplanDao() {
        return this.recoverPreplanDao;
    }

    public void setRecoverPreplanDao(RecoverPreplanDaoImpl recoverPreplanDao) {
        this.recoverPreplanDao = recoverPreplanDao;
    }

    public RecoverPlanDao getRecoverPlanDao() {
        return this.recoverPlanDao;
    }

    public void setRecoverPlanDao(RecoverPlanDaoImpl recoverPlanDao) {
        this.recoverPlanDao = recoverPlanDao;
    }
}

