/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.service.impl;

import com.huawei.csr.framework.checker.RecoverFlowChecker;
import com.huawei.csr.framework.checker.RecoverStageChecker;
import com.huawei.csr.framework.common.constants.RecoverStageType;
import com.huawei.csr.framework.common.model.RecoverStageBo;
import com.huawei.csr.framework.common.statusopt.StatusOptChecker;
import com.huawei.csr.framework.common.statusopt.opt.RecoverFlowOpt;
import com.huawei.csr.framework.common.statusopt.opt.RecoverPreplanOpt;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.common.utils.LockUtil;
import com.huawei.csr.framework.dao.RecoverFlowChainDao;
import com.huawei.csr.framework.dao.RecoverFlowDao;
import com.huawei.csr.framework.dao.RecoverPreplanDao;
import com.huawei.csr.framework.dao.RecoverStageDao;
import com.huawei.csr.framework.dao.StageFlowMapDao;
import com.huawei.csr.framework.dao.impl.RecoverFlowChainDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverFlowDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverPreplanDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverStageDaoImpl;
import com.huawei.csr.framework.dao.impl.StageFlowMapDaoImpl;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverFlowChain;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.RecoverStage;
import com.huawei.csr.framework.dao.model.StageFlowMap;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.RecoverStageService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Optional;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service(Name="com.huawei.csr.framework.service.RecoverStageService", Interface=RecoverStageService.class, Desc="")
public class RecoverStageServiceImpl
extends BaseService
implements RecoverStageService {
    private static final Log LOGGER = LogFactory.getInstance(RecoverStageServiceImpl.class);
    private static final String STAGE_OPER_TYPE = "createStage";
    private RecoverPreplanDao recoverPreplanDao;
    private RecoverStageDao recoverStageDao;
    private RecoverFlowDao recoverFlowDao;
    private StageFlowMapDao stageFlowMapDao;
    private RecoverFlowChainDao flowChainDao;

    private void checkNewStageIsAbleBeCreated(RecoverStageBo createStage) {
        String prePlanId = createStage.getPrePlanId();
        RecoverStageChecker.checkRecoverStageName(createStage.getStageName());
        RecoverStageChecker.checkPrePlanId(prePlanId);
        RecoverStageChecker.checkStageType(createStage.getStageType());
        String preStageId = createStage.getPreStageId();
        if (RecoverStageType.SUSPEND.getValue().equals(createStage.getStageType()) && !VerifyUtil.isEmpty((String)preStageId)) {
            RecoverStageChecker.checkStageIsNotPause(preStageId, 1073952703L, "Create suspend stage after suspend stage is not allowed,The preStage id:" + preStageId, new String[]{this.getStageById(preStageId).getName()});
            String oldNextStageId = this.getStageById(preStageId).getNextStageId();
            if (!VerifyUtil.isEmpty((String)oldNextStageId)) {
                RecoverStageChecker.checkStageIsNotPause(oldNextStageId, 1073952703L, "Create suspend stage before suspend stage is not allowed,The nextStage id:" + oldNextStageId, new String[]{this.getStageById(oldNextStageId).getName()});
            }
        }
        RecoverStageChecker.checkStageNameExistInPreplan(createStage.getStageName(), prePlanId);
        StatusOptChecker.checkRecoverPreplanStatusOpt(RecoverStatus.from(((RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class)).queryPreplanById(prePlanId).getStatus()).getIndex(), RecoverPreplanOpt.MODIFY_PREPLAN.getIndex(), 1073952403L);
        RecoverStageChecker.checkStageOutOfLimit(createStage.getProjectId(), prePlanId);
    }

    @Override
    public String createStage(RecoverStageBo createStage) {
        LOGGER.debug((Object)"Start createStage, stageName(%s).", new Object[]{createStage.getStageName()});
        if (VerifyUtil.isEmpty((Object)createStage) || VerifyUtil.isEmpty((String)createStage.getPrePlanId())) {
            LOGGER.error((Object)"RecoverStageBo or preplanId is empty or null.");
            throw new LegoCheckedException(1073952400L);
        }
        if (!LockUtil.tryLock(STAGE_OPER_TYPE + createStage.getPrePlanId())) {
            LOGGER.error((Object)"Fetch Lock failed when create stage,preplanId:'%s'.", new Object[]{createStage.getPrePlanId()});
            throw new LegoCheckedException(-1L);
        }
        final RecoverStage recoverStage = new RecoverStage();
        final String preStageId = createStage.getPreStageId();
        try {
            this.checkNewStageIsAbleBeCreated(createStage);
            recoverStage.setProjectId(createStage.getProjectId());
            recoverStage.setPrePlanId(createStage.getPrePlanId());
            recoverStage.setName(createStage.getStageName());
            recoverStage.setPreStageId(preStageId);
            recoverStage.setType(createStage.getStageType());
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    RecoverStageServiceImpl.this.recoverStageDao.save(recoverStage);
                    String stageId = recoverStage.getId();
                    if (!VerifyUtil.isEmpty((String)preStageId)) {
                        RecoverStageChecker.checkStageExist(preStageId);
                        String oldNextStageId = RecoverStageServiceImpl.this.getStageById(preStageId).getNextStageId();
                        RecoverStageServiceImpl.this.updateNextStageId(preStageId, stageId);
                        RecoverStageServiceImpl.this.updatePreStageId(stageId, oldNextStageId);
                        RecoverStageServiceImpl.this.updateNextStageId(stageId, oldNextStageId);
                    }
                }
            });
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Create stage failed, stageId is '%s', preStageId is '%s', error:%s.", new Object[]{recoverStage.getId(), preStageId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Create stage failed, stageId is '%s', preStageId is '%s', error:%s.", new Object[]{recoverStage.getId(), preStageId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
        finally {
            LockUtil.unLock(STAGE_OPER_TYPE + createStage.getPrePlanId());
        }
        return recoverStage.getId();
    }

    @Override
    public void updateStage(String stageId, String stageName) {
        LOGGER.debug((Object)"Start updateStage, stageId(%s).", new Object[]{stageId});
        RecoverStageChecker.checkRecoverStageName(stageName);
        RecoverStageChecker.checkStageId(stageId);
        RecoverStage oldStage = this.getStageById(stageId);
        if (!oldStage.getName().equals(stageName)) {
            RecoverStageChecker.checkStageNameExistInPreplan(stageName, oldStage.getPrePlanId());
        }
        RecoverStage recoverStage = this.getStageById(stageId);
        recoverStage.setName(stageName);
        this.recoverStageDao.update(recoverStage);
    }

    @Override
    public void deleteStage(final String projectId, final String stageId) {
        LOGGER.debug((Object)"Start deleteStage, stageId(%s).", new Object[]{stageId});
        RecoverStageChecker.checkStageId(stageId);
        RecoverStageChecker.checkStageExist(stageId);
        final RecoverStage stage = this.getStageById(stageId);
        Optional<RecoverPreplan> recoverPreplanOptional = this.recoverPreplanDao.queryPreplanById(stage.getPrePlanId());
        if (!recoverPreplanOptional.isPresent()) {
            LOGGER.info((Object)"Recover preplan is not exists. The preplanId is '%s',projectId is '%s'.", new Object[]{projectId, stage.getPrePlanId()});
        } else {
            StatusOptChecker.checkRecoverPreplanStatusOpt(RecoverStatus.from(recoverPreplanOptional.get().getStatus()).getIndex(), RecoverPreplanOpt.MODIFY_PREPLAN.getIndex(), 1073952403L);
        }
        try {
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    String preStageId = stage.getPreStageId();
                    String nextStageId = stage.getNextStageId();
                    RecoverStageServiceImpl.this.updateNextStageId(preStageId, nextStageId);
                    RecoverStageServiceImpl.this.updatePreStageId(preStageId, nextStageId);
                    RecoverStageServiceImpl.this.recoverStageDao.delete(stageId);
                    List<StageFlowMap> stageFlowMapList = RecoverStageServiceImpl.this.stageFlowMapDao.queryStageFlowMapByStageId(stageId);
                    RecoverStageServiceImpl.this.stageFlowMapDao.batchRemoveFlowFromStageByStageId(stageId);
                    RecoverFlowService service = (RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class);
                    stageFlowMapList.forEach(stageFlowMap -> {
                        String flowId = stageFlowMap.getFlowId();
                        if (RecoverStageServiceImpl.this.stageFlowMapDao.getStageFlowMapCountByFlowId(flowId) == 0L) {
                            service.deleteFlow(projectId, flowId, null);
                        }
                    });
                }
            });
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Delete stage failed, stageId is '%s', error:%s.", new Object[]{stageId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Delete stage failed, stageId is '%s', error:%s.", new Object[]{stageId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073952404L);
        }
    }

    private void updatePreStageId(String preStageId, String nextStageId) {
        if (!VerifyUtil.isEmpty((String)nextStageId)) {
            RecoverStage nextStage = this.getStageById(nextStageId);
            nextStage.setPreStageId(preStageId);
            this.recoverStageDao.update(nextStage);
        }
    }

    private void updateNextStageId(String preStageId, String nextStageId) {
        if (!VerifyUtil.isEmpty((String)preStageId)) {
            RecoverStage preStage = this.getStageById(preStageId);
            preStage.setNextStageId(nextStageId);
            this.recoverStageDao.update(preStage);
        }
    }

    @Override
    public RecoverStage getStageById(String stageId) {
        return this.recoverStageDao.getRecoverStageById(stageId);
    }

    @Override
    public List<RecoverStage> getStageList(String projectId, String prePlanId) {
        RecoverStageChecker.checkPrePlanId(prePlanId);
        return this.recoverStageDao.getRecoverStageListByPrePlan(projectId, prePlanId);
    }

    @Override
    public int getStageCount(String projectId, String prePlanId) {
        RecoverStageChecker.checkPrePlanId(prePlanId);
        return this.recoverStageDao.getRecoverStageCountByPrePlan(projectId, prePlanId);
    }

    @Override
    public int getStageCountByName(String stageName, String preplanId) {
        return this.recoverStageDao.getStageCountByName(stageName, preplanId);
    }

    @Override
    public void addFlowToStage(String stageId, String flowId) {
        LOGGER.debug((Object)"Start addFlowToStage, stageId(%s), flowId(%s).", new Object[]{stageId, flowId});
        RecoverFlowChecker.checkFlowId(flowId);
        RecoverStageChecker.checkStageId(stageId);
        RecoverFlowChecker.checkRecoverFlowExist(flowId);
        RecoverStageChecker.checkStageExist(stageId);
        RecoverFlow flow = this.recoverFlowDao.getRecoverFlowById(flowId);
        String errMsg = "Stage type of pause can not add flow, stageId:" + stageId + ",flowId:" + flowId;
        RecoverStageChecker.checkStageIsNotPause(stageId, 1073952609L, errMsg, new String[]{flow.getName(), this.getStageById(stageId).getName()});
        RecoverStageChecker.checkFlowAddtoStageLimit(stageId);
        RecoverFlowChecker.checkFlowTypeSameAsPreplan(stageId, flowId);
        RecoverFlowChecker.checkFlowApplicationExistInPreplan(stageId, flowId);
        RecoverFlowChecker.checkFlowExistedInStage(stageId, flowId);
        StatusOptChecker.checkRecoverFlowStatusOpt(RecoverStatus.from(flow.getStatus()).getIndex(), RecoverFlowOpt.ADD_TO_RECOVER_STAGE.getIndex(), 1073952403L);
        StageFlowMap stageFlowMap = new StageFlowMap();
        stageFlowMap.setStageId(stageId);
        stageFlowMap.setFlowId(flowId);
        this.stageFlowMapDao.addFlowToStage(stageFlowMap);
    }

    @Override
    public void removeFlowFromStage(String stageId, String flowId) {
        LOGGER.debug((Object)"Start removeFlowFromStage, stageId(%s), flowId(%s).", new Object[]{stageId, flowId});
        RecoverFlowChecker.checkFlowId(flowId);
        RecoverStageChecker.checkStageId(stageId);
        RecoverFlowChecker.checkFlowNoExistedInStage(stageId, flowId);
        StatusOptChecker.checkRecoverFlowStatusOpt(RecoverStatus.from(this.recoverFlowDao.getRecoverFlowById(flowId).getStatus()).getIndex(), RecoverFlowOpt.REMOVE_FROM_RECOVER_STAGE.getIndex(), 1073952403L);
        this.stageFlowMapDao.removeFlowFromStage(stageId, flowId);
    }

    @Override
    public void updateFlowDepend(String stageId, String preFlowId, String nextFlowId) {
        LOGGER.debug((Object)"Start updateFlowDepend, stageId(%s), preFlowId(%s), nextFlowId(%s).", new Object[]{stageId, preFlowId, nextFlowId});
        RecoverFlowChecker.checkFlowId(preFlowId);
        RecoverFlowChecker.checkFlowId(nextFlowId);
        RecoverStageChecker.checkStageId(stageId);
        RecoverFlowChecker.checkFlowNoExistedInStage(stageId, preFlowId);
        RecoverFlowChecker.checkFlowNoExistedInStage(stageId, nextFlowId);
        RecoverFlowChain flowChain = new RecoverFlowChain();
        flowChain.setStageId(stageId);
        flowChain.setPreFlowId(preFlowId);
        flowChain.setNextFlowId(nextFlowId);
        RecoverFlowChecker.checkFlowChainNoExisted(flowChain);
        StatusOptChecker.checkRecoverFlowStatusOpt(RecoverStatus.from(this.recoverFlowDao.getRecoverFlowById(preFlowId).getStatus()).getIndex(), RecoverFlowOpt.ADD_TO_RECOVER_STAGE.getIndex(), 1073952403L);
        StatusOptChecker.checkRecoverFlowStatusOpt(RecoverStatus.from(this.recoverFlowDao.getRecoverFlowById(nextFlowId).getStatus()).getIndex(), RecoverFlowOpt.ADD_TO_RECOVER_STAGE.getIndex(), 1073952403L);
        this.flowChainDao.save(flowChain);
    }

    @Override
    public void deleteFlowDepend(String stageId, String preFlowId, String nextFlowId) {
        LOGGER.debug((Object)"Start deleteFlowDepend, stageId(%s), preFlowId(%s), nextFlowId(%s).", new Object[]{stageId, preFlowId, nextFlowId});
        RecoverFlowChecker.checkFlowId(preFlowId);
        RecoverFlowChecker.checkFlowId(nextFlowId);
        RecoverStageChecker.checkStageId(stageId);
        RecoverFlowChecker.checkFlowNoExistedInStage(stageId, preFlowId);
        RecoverFlowChecker.checkFlowNoExistedInStage(stageId, nextFlowId);
        RecoverFlowChain flowChain = new RecoverFlowChain();
        flowChain.setStageId(stageId);
        flowChain.setPreFlowId(preFlowId);
        flowChain.setNextFlowId(nextFlowId);
        StatusOptChecker.checkRecoverFlowStatusOpt(RecoverStatus.from(this.recoverFlowDao.getRecoverFlowById(preFlowId).getStatus()).getIndex(), RecoverFlowOpt.REMOVE_FROM_RECOVER_STAGE.getIndex(), 1073952403L);
        StatusOptChecker.checkRecoverFlowStatusOpt(RecoverStatus.from(this.recoverFlowDao.getRecoverFlowById(nextFlowId).getStatus()).getIndex(), RecoverFlowOpt.REMOVE_FROM_RECOVER_STAGE.getIndex(), 1073952403L);
        this.flowChainDao.delete(flowChain);
    }

    @Override
    public long getStageFlowMapCountByStageId(String stageId) {
        return this.stageFlowMapDao.getStageFlowMapCountByStageId(stageId);
    }

    public RecoverPreplanDao getRecoverPreplanDao() {
        return this.recoverPreplanDao;
    }

    public void setRecoverPreplanDao(RecoverPreplanDaoImpl recoverPreplanDao) {
        this.recoverPreplanDao = recoverPreplanDao;
    }

    public RecoverStageDao getRecoverStageDao() {
        return this.recoverStageDao;
    }

    public void setRecoverStageDao(RecoverStageDaoImpl recoverStageDao) {
        this.recoverStageDao = recoverStageDao;
    }

    public RecoverFlowDao getRecoverFlowDao() {
        return this.recoverFlowDao;
    }

    public void setRecoverFlowDao(RecoverFlowDaoImpl recoverFlowDao) {
        this.recoverFlowDao = recoverFlowDao;
    }

    public StageFlowMapDao getStageFlowMapDao() {
        return this.stageFlowMapDao;
    }

    public void setStageFlowMapDao(StageFlowMapDaoImpl stageFlowMapDao) {
        this.stageFlowMapDao = stageFlowMapDao;
    }

    public RecoverFlowChainDao getFlowChainDao() {
        return this.flowChainDao;
    }

    public void setFlowChainDao(RecoverFlowChainDaoImpl flowChainDao) {
        this.flowChainDao = flowChainDao;
    }
}

