/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.service.impl;

import com.huawei.csr.framework.checker.RecoverStepChecker;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.RecoverStepChainQuery;
import com.huawei.csr.framework.common.model.RecoverStepQuery;
import com.huawei.csr.framework.common.model.ServiceInstanceQuery;
import com.huawei.csr.framework.common.statusopt.StatusOptChecker;
import com.huawei.csr.framework.common.statusopt.opt.RecoverStepOpt;
import com.huawei.csr.framework.common.statusopt.status.RecoverStatus;
import com.huawei.csr.framework.common.utils.LockUtil;
import com.huawei.csr.framework.dao.ApplicationDao;
import com.huawei.csr.framework.dao.FlowStepMapDao;
import com.huawei.csr.framework.dao.RecoverFlowDao;
import com.huawei.csr.framework.dao.RecoverStepChainDao;
import com.huawei.csr.framework.dao.RecoverStepDao;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.impl.ApplicationDaoImpl;
import com.huawei.csr.framework.dao.impl.FlowStepMapDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverFlowDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverStepChainDaoImpl;
import com.huawei.csr.framework.dao.impl.RecoverStepDaoImpl;
import com.huawei.csr.framework.dao.impl.ServiceInstanceDaoImpl;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.FlowStepMap;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.StepChain;
import com.huawei.csr.framework.dao.support.TransactionManager;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.RecoverStepService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service(Name="com.huawei.csr.framework.service.RecoverStepService", Interface=RecoverStepService.class, Desc="")
public class RecoverStepServiceImpl
extends BaseService
implements RecoverStepService {
    private static final Log LOG = LogFactory.getInstance(RecoverStepServiceImpl.class);
    private static final String STEP_OPER_TYPE = "createStep";
    private RecoverStepDao recoverStepDao;
    private FlowStepMapDao flowStepMapDao;
    private RecoverStepChainDao recoverStepChainDao;
    private ApplicationDao applicationDao;
    private ServiceInstanceDao serviceInstanceDao;
    private RecoverFlowDao recoverFlowDao;

    @Override
    public String createRecoverStep(String projectId, RecoverStep recoverStep) {
        LOG.debug((Object)"Start createRecoverStep, projectId(%s), recoverStepName(%s).", new Object[]{projectId, recoverStep.getName()});
        if (VerifyUtil.isEmpty((Object)recoverStep) || VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)recoverStep.getServiceInstanceId())) {
            LOG.error((Object)"RecoverStep or projectId or instance id is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        if (!LockUtil.tryLock(STEP_OPER_TYPE + recoverStep.getServiceInstanceId())) {
            LOG.error((Object)"Fetch Lock failed when create step,projectId:'%s',instance id:'%s'.", new Object[]{recoverStep.getProjectId(), recoverStep.getServiceInstanceId()});
            throw new LegoCheckedException(-1L);
        }
        try {
            RecoverStepChecker.checkOperationServiceMatch(recoverStep.getServiceType(), recoverStep.getAction());
            RecoverStepChecker.checkInstanceTypeConsist(recoverStep);
            RecoverStepChecker.checkRecoverStepCount();
            RecoverStepChecker.checkStepInstanceCount(recoverStep.getServiceInstanceId());
            RecoverStepChecker.checkRecoverStepName(projectId, recoverStep.getName());
            this.recoverStepDao.save(recoverStep);
        }
        finally {
            LockUtil.unLock(STEP_OPER_TYPE + recoverStep.getServiceInstanceId());
        }
        return recoverStep.getId();
    }

    @Override
    public void deleteRecoverStep(final RecoverStepQuery recoverStepQuery) {
        LOG.debug((Object)"Start deleteRecoverStep, recoverStepId(%s).", new Object[]{recoverStepQuery.getStepId()});
        if (VerifyUtil.isEmpty((Object)recoverStepQuery)) {
            LOG.error((Object)"RecoverStepQuery para is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        RecoverStep step = this.recoverStepDao.queryRecoverStepById(recoverStepQuery.getStepId());
        if (VerifyUtil.isEmpty((Object)step)) {
            LOG.error((Object)"Recover step: %s does not exist.", new Object[]{recoverStepQuery.getStepId()});
            return;
        }
        StatusOptChecker.checkRecoverStepStatusOpt(RecoverStatus.from(step.getStatus()).getIndex(), RecoverStepOpt.DELETE.getIndex(), 1073952403L);
        try {
            TransactionManager.executeTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    if (!VerifyUtil.isEmpty((String)recoverStepQuery.getFlowId())) {
                        RecoverStepServiceImpl.this.removeStepWithFlowId(recoverStepQuery);
                    } else {
                        RecoverStepServiceImpl.this.removeStepWithoutFlowId(recoverStepQuery);
                    }
                }
            });
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Delete step failed, step query is %s", new Object[]{recoverStepQuery});
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Delete step system error, step query is %s", new Object[]{recoverStepQuery});
            throw new LegoCheckedException(1073952404L);
        }
    }

    private void removeStepWithFlowId(RecoverStepQuery recoverStepQuery) {
        List<FlowStepMap> flowStepMapList = this.flowStepMapDao.queryFlowStepMapByStepId(recoverStepQuery.getStepId());
        if (!flowStepMapList.stream().allMatch(flowStepMap -> recoverStepQuery.getFlowId().equals(flowStepMap.getRecoverFlowId()))) {
            this.flowStepMapDao.removeStepFromFlow(recoverStepQuery.getFlowId(), recoverStepQuery.getStepId());
            RecoverStepChainQuery preStepQuery = new RecoverStepChainQuery();
            preStepQuery.setPrevStepId(recoverStepQuery.getStepId());
            preStepQuery.setFlowId(recoverStepQuery.getFlowId());
            this.recoverStepChainDao.delete(preStepQuery);
            RecoverStepChainQuery nextStepQuery = new RecoverStepChainQuery();
            nextStepQuery.setNextStepId(recoverStepQuery.getStepId());
            nextStepQuery.setFlowId(recoverStepQuery.getFlowId());
            this.recoverStepChainDao.delete(nextStepQuery);
        } else {
            this.deleteRecoverStepOperation(recoverStepQuery);
        }
    }

    private void deleteRecoverStepOperation(RecoverStepQuery recoverStepQuery) {
        RecoverStepChainQuery preStepQuery = new RecoverStepChainQuery();
        preStepQuery.setPrevStepId(recoverStepQuery.getStepId());
        RecoverStepChainQuery nextStepQuery = new RecoverStepChainQuery();
        nextStepQuery.setNextStepId(recoverStepQuery.getStepId());
        this.recoverStepChainDao.delete(preStepQuery);
        this.recoverStepChainDao.delete(nextStepQuery);
        this.flowStepMapDao.deleteAllByStepId(recoverStepQuery.getStepId());
        this.recoverStepDao.delete(recoverStepQuery);
    }

    private void removeStepWithoutFlowId(RecoverStepQuery recoverStepQuery) {
        List<FlowStepMap> flowStepMapList = this.flowStepMapDao.queryFlowStepMapByStepId(recoverStepQuery.getStepId());
        ArrayList canDeleteFlowList = new ArrayList();
        flowStepMapList.forEach(map -> {
            if (this.flowStepMapDao.queryFlowStepMapByFlowId(map.getRecoverFlowId()).stream().allMatch(flowMap -> flowMap.getRecoverStepId().equals(recoverStepQuery.getStepId()))) {
                canDeleteFlowList.add(this.recoverFlowDao.getRecoverFlowById(map.getRecoverFlowId()));
            }
        });
        this.deleteRecoverStepOperation(recoverStepQuery);
        for (RecoverFlow flow : canDeleteFlowList) {
            ((RecoverFlowService)ServiceLocator.getInstance().getService(RecoverFlowService.class)).deleteFlow(recoverStepQuery.getProjectId(), flow.getId(), null);
        }
    }

    @Override
    public RecoverStep modifyRecoverStep(String projectId, RecoverStepQuery query, RecoverStep recoverStep) {
        LOG.debug((Object)"Start modifyRecoverStep, recoverStepId(%s).", new Object[]{query.getStepId()});
        if (VerifyUtil.isEmpty((Object)query) || VerifyUtil.isEmpty((Object)recoverStep)) {
            LOG.error((Object)"RecoverStepQuery or recoverStep is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        RecoverStep step = this.recoverStepDao.queryRecoverStepById(query.getStepId());
        if (VerifyUtil.isEmpty((Object)step)) {
            LOG.error((Object)"Recover step: %s does not exist.", new Object[]{query.getStepId()});
            throw new LegoCheckedException(1073952506L);
        }
        StatusOptChecker.checkRecoverStepStatusOpt(RecoverStatus.from(step.getStatus()).getIndex(), RecoverStepOpt.UPDATE.getIndex(), 1073952403L);
        if (!recoverStep.getName().equals(step.getName())) {
            RecoverStepChecker.checkRecoverStepName(projectId, recoverStep.getName());
        }
        RecoverStepChecker.checkInstanceTypeConsist(recoverStep);
        if (!VerifyUtil.isEmpty(this.flowStepMapDao.queryFlowStepMapByStepId(query.getStepId()))) {
            RecoverStepChecker.checkRecoverPlanIdle(query);
            this.recoverStepDao.modifyRelatedStep(query, recoverStep);
        } else {
            this.recoverStepDao.modify(query, recoverStep);
        }
        return this.recoverStepDao.queryRecoverStep(query);
    }

    @Override
    public List<RecoverStep> queryRecoverStepList(RecoverStepQuery recoverStepQuery) {
        return this.recoverStepDao.queryRecoverStepList(recoverStepQuery);
    }

    @Override
    public long getRecoverStepCount(RecoverStepQuery recoverStepQuery) {
        return this.recoverStepDao.getRecoverStepCount(recoverStepQuery);
    }

    @Override
    public void addStepToFlow(String projectId, String flowId, String stepId) {
        LOG.debug((Object)"Start addStepToFlow, flowId(%s), stepId(%s).", new Object[]{flowId, stepId});
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)flowId) || VerifyUtil.isEmpty((String)"stepId")) {
            LOG.error((Object)"ProjectId or flowId or stepId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        FlowStepMap flowStepMap = new FlowStepMap();
        flowStepMap.setRecoverFlowId(flowId);
        flowStepMap.setRecoverStepId(stepId);
        RecoverStepChecker.checkRecoverFlowExist(flowId);
        RecoverStepChecker.checkRecoverStepExist(stepId);
        RecoverStepChecker.checkFlowStepMapExist(flowId, stepId);
        RecoverStepChecker.checkFlowStepMapCount(flowId);
        RecoverStepChecker.checkStepInstanceOfFlow(flowId, stepId);
        RecoverStepChecker.checkServiceActionExist(flowId, stepId);
        RecoverStepChecker.checkInstanceMatchPreplan(flowId, stepId);
        RecoverStep step = this.recoverStepDao.queryRecoverStepById(stepId);
        StatusOptChecker.checkRecoverStepStatusOpt(RecoverStatus.from(step.getStatus()).getIndex(), RecoverStepOpt.ADD_TO_RECOVER_FLOW.getIndex(), 1073952403L);
        RecoverStepChecker.checkStepFlowConsist(flowId, stepId);
        this.flowStepMapDao.addStepToFlow(flowStepMap);
    }

    @Override
    public void removeStepFromFlow(String projectId, String flowId, String stepId) {
        LOG.debug((Object)"Start removeStepFromFlow, flowId(%s), stepId(%s).", new Object[]{flowId, stepId});
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)flowId) || VerifyUtil.isEmpty((String)"stepId")) {
            LOG.error((Object)"ProjectId or flowId or stepId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        RecoverStepChecker.checkFlowStepMapNotExist(flowId, stepId);
        RecoverStep step = this.recoverStepDao.queryRecoverStepById(stepId);
        StatusOptChecker.checkRecoverStepStatusOpt(RecoverStatus.from(step.getStatus()).getIndex(), RecoverStepOpt.REMOVE_FROM_RECOVER_FLOW.getIndex(), 1073952403L);
        this.flowStepMapDao.removeStepFromFlow(flowId, stepId);
    }

    @Override
    public List<String> getAllPrestepId(String stepId) {
        if (VerifyUtil.isEmpty((String)stepId)) {
            LOG.error((Object)"StepId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        List<StepChain> stepChainList = this.recoverStepChainDao.queryAllPreStepId(stepId);
        return stepChainList.stream().map(StepChain::getPrevStepId).collect(Collectors.toList());
    }

    @Override
    public List<RecoverFlow> getFlowListByStepId(String stepId) {
        if (VerifyUtil.isEmpty((String)stepId)) {
            LOG.error((Object)"StepId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        List<FlowStepMap> flowStepMapList = this.flowStepMapDao.queryFlowStepMapByStepId(stepId);
        return flowStepMapList.stream().map(flowStepMap -> this.recoverFlowDao.getRecoverFlowById(flowStepMap.getRecoverFlowId())).collect(Collectors.toList());
    }

    @Override
    public AppServiceInstance getServiceInstance(String serviceInstanceId) {
        if (VerifyUtil.isEmpty((String)serviceInstanceId)) {
            LOG.error((Object)"ServiceInstanceId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.serviceInstanceDao.getServiceInstanceById(serviceInstanceId);
    }

    @Override
    public RecoverStep queryRecoverStep(RecoverStepQuery recoverStepQuery) {
        if (VerifyUtil.isEmpty((Object)recoverStepQuery)) {
            LOG.error((Object)"Query is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.recoverStepDao.queryRecoverStep(recoverStepQuery);
    }

    @Override
    public void modifyLinkStepFromFlow(String projectId, StepChain chain) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((Object)chain)) {
            LOG.error((Object)"projectId or chain is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        RecoverStepChainQuery query = new RecoverStepChainQuery();
        query.setFlowId(chain.getRecoverFlowId());
        query.setPrevStepId(chain.getPrevStepId());
        query.setNextStepId(chain.getNextStepId());
        StepChain dbChain = this.recoverStepChainDao.queryStepChain(query);
        if (VerifyUtil.isEmpty((Object)dbChain)) {
            this.recoverStepChainDao.save(chain);
        } else {
            this.recoverStepChainDao.modify(chain);
        }
    }

    @Override
    public void deleteLinkStepFromFlow(String projectId, RecoverStepChainQuery query) {
        LOG.debug((Object)"Start removeStepFromFlow, recoverFlowId(%s), prevStepId(%s), nextStepId(%s).", new Object[]{query.getFlowId(), query.getPrevStepId(), query.getNextStepId()});
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((Object)query)) {
            LOG.error((Object)"projectId or query is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        this.recoverStepChainDao.delete(query);
    }

    @Override
    public long getFlowStepMapCountByFlowId(String flowId) {
        if (VerifyUtil.isEmpty((String)flowId)) {
            LOG.error((Object)"FlowId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.flowStepMapDao.getStepMapCountByFlowId(flowId);
    }

    @Override
    public long getFlowStepMapCount(String flowId, String stepId) {
        if (VerifyUtil.isEmpty((String)flowId) || VerifyUtil.isEmpty((String)stepId)) {
            LOG.error((Object)"FlowId or stepId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.flowStepMapDao.getStepMapCount(flowId, stepId);
    }

    @Override
    public long getAllRecoverStepCount() {
        return this.recoverStepDao.getAllRecoverStepCount();
    }

    @Override
    public long getStepChainCount(RecoverStepChainQuery query) {
        if (VerifyUtil.isEmpty((Object)query)) {
            LOG.error((Object)"Query is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.recoverStepChainDao.getStepChainCount(query);
    }

    @Override
    public Pair<List<RecoverStep>, Long> queryRecoverStepsNotInFlow(RecoverStepQuery query, int marker, int limit) {
        if (VerifyUtil.isEmpty((Object)query) || VerifyUtil.isEmpty((String)query.getFlowId())) {
            LOG.error((Object)"Query or flowId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        String flowId = query.getFlowId();
        query.setFlowId(null);
        query.setPage(false);
        ArrayList<RecoverStep> page = new ArrayList<RecoverStep>();
        RecoverFlow recoverFlow = this.recoverFlowDao.getRecoverFlowById(flowId);
        if (VerifyUtil.isEmpty((Object)recoverFlow)) {
            LOG.error((Object)"RecoverFlow is Empty");
            return Pair.of(page, (Object)0L);
        }
        Application application = this.applicationDao.getApp(recoverFlow.getAppId(), query.getProjectId());
        if (VerifyUtil.isEmpty((Object)application)) {
            LOG.error((Object)"Application is Empty");
            return Pair.of(page, (Object)0L);
        }
        ServiceInstanceQuery serviceInstanceQuery = new ServiceInstanceQuery();
        serviceInstanceQuery.setAppId(application.getId());
        serviceInstanceQuery.setProjectId(query.getProjectId());
        List<RecoverStep> appStepList = this.serviceInstanceDao.getRecoverStepByAppQuery(serviceInstanceQuery);
        List<FlowStepMap> flowStepMapList = this.flowStepMapDao.queryFlowStepMapByFlowId(flowId);
        List<RecoverStep> recoverStepList = this.recoverStepDao.queryRecoverStepList(query);
        recoverStepList.removeIf(step -> this.isStepRelatedToFlow((RecoverStep)step, flowStepMapList));
        recoverStepList = recoverStepList.stream().filter(step -> this.isStepInAppStepList((RecoverStep)step, appStepList)).collect(Collectors.toList());
        recoverStepList.removeIf(step -> this.isSameActionInFlow((RecoverStep)step, flowId));
        recoverStepList = recoverStepList.stream().filter(step -> this.isStepActionAllowedInFlow((RecoverStep)step, flowId)).collect(Collectors.toList());
        recoverStepList = recoverStepList.stream().filter(step -> this.isInstanceMatchPreplan((RecoverStep)step, flowId)).collect(Collectors.toList());
        page.addAll(recoverStepList.subList(Math.min(marker, recoverStepList.size()), Math.min(marker + limit, recoverStepList.size())));
        return Pair.of(new ArrayList(page), (Object)recoverStepList.size());
    }

    private boolean isInstanceMatchPreplan(RecoverStep step, String flowId) {
        Set<String> siteIdSet = ((RecoverPreplanService)ServiceLocator.getInstance().getService(RecoverPreplanService.class)).queryPreplansSiteByFlowId(flowId);
        if (VerifyUtil.isEmpty(siteIdSet)) {
            LOG.info((Object)"Recover flow %s does not related to any preplan.", new Object[]{flowId});
            return true;
        }
        AppServiceInstance instance = this.serviceInstanceDao.getServiceInstanceById(step.getServiceInstanceId());
        return siteIdSet.contains(instance.getPdSiteId()) || siteIdSet.contains(instance.getDrSiteId());
    }

    private boolean isStepActionAllowedInFlow(RecoverStep step, String flowId) {
        RecoverFlow flow = this.recoverFlowDao.getRecoverFlowById(flowId);
        if (VerifyUtil.isEmpty((Object)flow)) {
            LOG.error((Object)"Recover flow %s does not exist, flowId is:%s.", new Object[]{flowId});
            throw new LegoCheckedException(1073952601L);
        }
        if (ServiceType.CSHA.getValue().equals(step.getServiceType())) {
            return step.getAction().equals(flow.getType());
        }
        if (ServiceType.RDS.getValue().equals(step.getServiceType()) || ServiceType.DCS.getValue().equals(step.getServiceType())) {
            if (RecoverStepAction.SWITCHOVER.getValue().equals(step.getAction())) {
                return flow.getType().equals(RecoverOperateType.SWITCHBACK.getValue()) || flow.getType().equals(RecoverOperateType.PLANNED_MIGRATION.getValue());
            }
            if (RecoverStepAction.CHECK_INSTANCE.getValue().equals(step.getAction())) {
                return flow.getType().equals(RecoverOperateType.REPROTECT.getValue());
            }
            if (RecoverStepAction.CHECK_PD_STATUS.getValue().equals(step.getAction())) {
                return flow.getType().equals(RecoverOperateType.DISASTER_RECOVERY.getValue());
            }
        }
        return true;
    }

    private boolean isSameActionInFlow(RecoverStep step, String flowId) {
        List<FlowStepMap> flowStepMapList = this.flowStepMapDao.queryFlowStepMapByFlowId(flowId);
        for (FlowStepMap map : flowStepMapList) {
            Optional<RecoverStep> optionalStep = Optional.ofNullable(this.recoverStepDao.queryRecoverStepById(map.getRecoverStepId()));
            if (!optionalStep.isPresent() || !optionalStep.get().getServiceInstanceId().equals(step.getServiceInstanceId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public RecoverStep queryRecoverStepById(String stepId) {
        if (VerifyUtil.isEmpty((String)stepId)) {
            LOG.error((Object)"stepId is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.recoverStepDao.queryRecoverStepById(stepId);
    }

    @Override
    public RecoverStep queryRecoverStepByName(String projectId, String name) {
        if (VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)name)) {
            LOG.error((Object)"projectId or name is empty.");
            throw new LegoCheckedException(1073952400L);
        }
        return this.recoverStepDao.queryRecoverStepByName(projectId, name);
    }

    @Override
    public List<FlowStepMap> queryFlowStepMapListByFlowId(String flowId) {
        return this.flowStepMapDao.queryFlowStepMapByFlowId(flowId);
    }

    @Override
    public long getRecoverStepCountByInstanceId(String serviceInstanceId) {
        return this.recoverStepDao.getRecoverStepCountByInstanceId(serviceInstanceId);
    }

    @Override
    public List<String> queryAllPreStepIdInFlow(String stepId, String flowId) {
        return this.getStepChainDao().queryPreStepList(flowId, stepId).stream().map(StepChain::getPrevStepId).collect(Collectors.toList());
    }

    private boolean isStepInAppStepList(RecoverStep step, List<RecoverStep> stepList) {
        for (RecoverStep stepItem : stepList) {
            if (!step.getId().equals(stepItem.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isStepRelatedToFlow(RecoverStep step, List<FlowStepMap> flowStepMapList) {
        for (FlowStepMap stepItem : flowStepMapList) {
            if (!step.getId().equals(stepItem.getRecoverStepId())) continue;
            return true;
        }
        return false;
    }

    public RecoverStepDao getRecoverStepDao() {
        return this.recoverStepDao;
    }

    public void setRecoverStepDao(RecoverStepDaoImpl recoverStepDao) {
        this.recoverStepDao = recoverStepDao;
    }

    public FlowStepMapDao getFlowStepMapDao() {
        return this.flowStepMapDao;
    }

    public void setFlowStepMapDao(FlowStepMapDaoImpl flowStepMapDao) {
        this.flowStepMapDao = flowStepMapDao;
    }

    public RecoverStepChainDao getStepChainDao() {
        return this.recoverStepChainDao;
    }

    public void setStepChainDao(RecoverStepChainDaoImpl stepChainDao) {
        this.recoverStepChainDao = stepChainDao;
    }

    public ServiceInstanceDao getServiceInstanceDao() {
        return this.serviceInstanceDao;
    }

    public void setServiceInstanceDao(ServiceInstanceDaoImpl serviceInstanceDao) {
        this.serviceInstanceDao = serviceInstanceDao;
    }

    public RecoverFlowDao getRecoverFlowDao() {
        return this.recoverFlowDao;
    }

    public void setRecoverFlowDao(RecoverFlowDaoImpl recoverFlowDao) {
        this.recoverFlowDao = recoverFlowDao;
    }

    public ApplicationDao getApplicationDao() {
        return this.applicationDao;
    }

    public void setApplicationDao(ApplicationDaoImpl applicationDao) {
        this.applicationDao = applicationDao;
    }
}

