/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.statistic.listener;

import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.core.event.entity.RecoverTaskEventEntity;
import com.huawei.csr.framework.core.event.listener.BaseEventListener;
import com.huawei.csr.framework.core.event.objects.RecoverTaskEvent;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.dao.model.StatisticData;
import com.huawei.csr.framework.service.RecoverStepService;
import com.huawei.csr.framework.service.StatisticService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class InstanceStatisticListener
implements BaseEventListener<RecoverTaskEvent> {
    private static final Log logger = LogFactory.getInstance(InstanceStatisticListener.class);
    private StatisticService statisticService;
    private RecoverStepService stepService;

    @Override
    public boolean supportEvent(RecoverTaskEvent event) {
        if (!event.getEventType().equals((Object)RecoverTaskEvent.EventType.RECOVER_TASK)) {
            return false;
        }
        RecoverLog recoverLog = ((RecoverTaskEventEntity)event.getSource()).getRecoverContext().getRecoverLog();
        return RecoverResourceType.RECOVER_STEP.getValue().equals(recoverLog.getResourceType());
    }

    @Override
    public void onEvent(RecoverTaskEvent event) {
        logger.info((Object)"Begin statistic instance results");
        RecoverLog recoverLog = ((RecoverTaskEventEntity)event.getSource()).getRecoverContext().getRecoverLog();
        RecoverStep step = this.stepService.queryRecoverStepById(recoverLog.getResourceId());
        StatisticData data = new StatisticData();
        data.setProjectId(step.getProjectId());
        data.setResourceId(step.getServiceInstanceId());
        data.setResourceType(RecoverResourceType.RECOVER_STEP.getValue());
        data.setActivityType(step.getServiceType());
        data.setResultType(recoverLog.getStatus());
        this.statisticService.updateStatistic(data);
        logger.info((Object)"End statistic instance results");
    }

    public StatisticService getStatisticService() {
        return this.statisticService;
    }

    public void setStatisticService(StatisticService statisticService) {
        this.statisticService = statisticService;
    }

    public RecoverStepService getStepService() {
        return this.stepService;
    }

    public void setStepService(RecoverStepService stepService) {
        this.stepService = stepService;
    }
}

