/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.statistic.listener;

import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.statusopt.status.RecoverLogStatus;
import com.huawei.csr.framework.core.event.entity.RecoverTaskEventEntity;
import com.huawei.csr.framework.core.event.listener.BaseEventListener;
import com.huawei.csr.framework.core.event.objects.RecoverTaskEvent;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.dao.model.RecoverPreplan;
import com.huawei.csr.framework.dao.model.StatisticData;
import com.huawei.csr.framework.service.RecoverPreplanService;
import com.huawei.csr.framework.service.StatisticService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class PlanStatisticListener
implements BaseEventListener<RecoverTaskEvent> {
    private static final Log logger = LogFactory.getInstance(PlanStatisticListener.class);
    private StatisticService statisticService;
    private RecoverPreplanService preplanService;

    @Override
    public boolean supportEvent(RecoverTaskEvent event) {
        if (!event.getEventType().equals((Object)RecoverTaskEvent.EventType.RECOVER_TASK)) {
            return false;
        }
        RecoverLog recoverLog = ((RecoverTaskEventEntity)event.getSource()).getRecoverContext().getRecoverLog();
        return RecoverResourceType.RECOVER_PREPLAN.getValue().equals(recoverLog.getResourceType());
    }

    @Override
    public void onEvent(RecoverTaskEvent event) {
        logger.info((Object)"Begin statistic plan results");
        RecoverLog recoverLog = ((RecoverTaskEventEntity)event.getSource()).getRecoverContext().getRecoverLog();
        RecoverPreplan preplan = this.preplanService.queryPreplanById(recoverLog.getResourceId());
        StatisticData planData = new StatisticData();
        planData.setProjectId(preplan.getProjectId());
        planData.setResourceId(preplan.getId());
        planData.setResourceType(RecoverResourceType.RECOVER_PREPLAN.getValue());
        planData.setActivityType(preplan.getType());
        planData.setResultType(recoverLog.getStatus());
        this.statisticService.updateStatistic(planData);
        StatisticData rtoData = new StatisticData();
        rtoData.setProjectId(preplan.getProjectId());
        rtoData.setResourceId(preplan.getId());
        rtoData.setResourceType(RecoverResourceType.RECOVER_PREPLAN.getValue());
        rtoData.setActivityType("rto");
        if (RecoverLogStatus.FAILED.getValue().equals(recoverLog.getStatus())) {
            rtoData.setResultType("unknown");
        } else {
            long exeTime = recoverLog.getEndTime().getTime() - recoverLog.getStartTime().getTime();
            rtoData.setResultType(exeTime > preplan.getExpectRTO() * 60000L ? "unsatisfied" : "satisfied");
        }
        this.statisticService.updateStatistic(rtoData);
        logger.info((Object)"End statistic plan results");
    }

    public StatisticService getStatisticService() {
        return this.statisticService;
    }

    public void setStatisticService(StatisticService statisticService) {
        this.statisticService = statisticService;
    }

    public RecoverPreplanService getPreplanService() {
        return this.preplanService;
    }

    public void setPreplanService(RecoverPreplanService preplanService) {
        this.preplanService = preplanService;
    }
}

