/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.statistic.listener;

import com.huawei.csr.framework.common.constants.RecoverResourceType;
import com.huawei.csr.framework.common.operationtask.OperationTaskManager;
import com.huawei.csr.framework.common.operationtask.app.RefreshAppTask;
import com.huawei.csr.framework.common.utils.AppServiceUtil;
import com.huawei.csr.framework.core.event.entity.RecoverTaskEventEntity;
import com.huawei.csr.framework.core.event.listener.BaseEventListener;
import com.huawei.csr.framework.core.event.objects.RecoverTaskEvent;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.RecoverFlow;
import com.huawei.csr.framework.dao.model.RecoverLog;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.service.RecoverFlowService;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.auth.util.AuthUtil;
import com.huawei.sdk.connector.auth.Credential;

public class RecoverTaskListener
implements BaseEventListener<RecoverTaskEvent> {
    private static final Log logger = LogFactory.getInstance(RecoverTaskListener.class);
    private AppService appService;
    private RecoverFlowService recoverFlowService;

    @Override
    public boolean supportEvent(RecoverTaskEvent event) {
        if (!event.getEventType().equals((Object)RecoverTaskEvent.EventType.RECOVER_TASK)) {
            return false;
        }
        RecoverLog recoverLog = ((RecoverTaskEventEntity)event.getSource()).getRecoverContext().getRecoverLog();
        return RecoverResourceType.RECOVER_FLOW.getValue().equals(recoverLog.getResourceType());
    }

    @Override
    public void onEvent(RecoverTaskEvent event) {
        this.refreshAppInFlow(event);
    }

    private void refreshAppInFlow(RecoverTaskEvent event) {
        RecoverLog recoverLog = ((RecoverTaskEventEntity)event.getSource()).getRecoverContext().getRecoverLog();
        RecoverFlow recoverFlow = this.recoverFlowService.getRecoverFlowById(recoverLog.getResourceId());
        if (VerifyUtil.isEmpty((Object)recoverFlow)) {
            logger.error((Object)"Query RecoverFlow Failed. resourceId is %s.", new Object[]{recoverLog.getResourceId()});
            return;
        }
        Application application = this.appService.getApplicationById(recoverFlow.getAppId());
        String projectId = application.getProjectId();
        String authToken = null;
        try {
            authToken = AuthUtil.getScopedAuthToken((String)projectId);
        }
        catch (Exception e) {
            logger.error((Object)"Refresh App(%s) fetch authToken failed. msg: %s", new Object[]{application.getId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Fetch AuthToken failed.");
        }
        BackTask backTaskModel = AppServiceUtil.buildBackupTaskModel(projectId, application.getName(), "operation.task.refresh.app");
        Credential credential = new Credential(application.getProjectId(), authToken, null);
        RefreshAppTask refreshAppTask = new RefreshAppTask(backTaskModel, application, credential);
        OperationTaskManager.submitTask(refreshAppTask);
        logger.debug((Object)"Rerfresh app(%s) associated with flow(%s) successed.", new Object[]{application.getId(), recoverFlow.getId()});
    }

    public void setAppService(AppService appService) {
        this.appService = appService;
    }

    public void setRecoverFlowService(RecoverFlowService recoverFlowService) {
        this.recoverFlowService = recoverFlowService;
    }
}

