/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.topo.build;

import com.huawei.csr.framework.common.constants.TopoRelationState;
import com.huawei.csr.framework.dao.model.TopoLink;
import com.huawei.csr.framework.dao.model.TopoNode;
import com.huawei.csr.framework.topo.build.TopoBuilder;
import com.huawei.csr.framework.topo.build.TopoSource;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTopoBuilder
implements TopoBuilder {
    public static final String ENTITY_SEPARATOR = ":";
    private final String supportType;
    private final List<String> dependencies;

    public AbstractTopoBuilder(String supportType, List<String> dependencies) {
        this.supportType = supportType;
        this.dependencies = Collections.unmodifiableList(dependencies);
    }

    protected TopoNode buildCommonNode(TopoSource source, String role) {
        String slave = TopoRelationState.SLAVE.getValue();
        TopoNode topoNode = new TopoNode();
        topoNode.setId(UUIDGenerator.getUUID());
        topoNode.setProjectId(source.getProjectId());
        topoNode.setApplicationId(source.getApplicationId());
        topoNode.setNodeType(source.getNodeType());
        topoNode.setResourceType(source.getResourceType());
        topoNode.setResourceId(source.getResourceId());
        topoNode.setState(role);
        topoNode.setName(slave.equals(role) ? source.getDrName() : source.getPdName());
        topoNode.setNodeStatus(slave.equals(role) ? source.getDrNodeStatus() : source.getPdNodeStatus());
        topoNode.setRegionId(slave.equals(role) ? source.getDrRegionId() : source.getPdRegionId());
        topoNode.setRegionName(slave.equals(role) ? source.getDrRegionName() : source.getPdRegionName());
        topoNode.setAzId(slave.equals(role) ? source.getDrAzId() : source.getPdAzId());
        topoNode.setAzName(slave.equals(role) ? source.getDrAzName() : source.getPdAzName());
        topoNode.setSiteId(slave.equals(role) ? source.getDrSiteId() : source.getPdSiteId());
        return topoNode;
    }

    protected TopoLink buildCommonLink(TopoSource topoSource, TopoNode sourceNode, TopoNode targetNode) {
        TopoLink topoLink = new TopoLink();
        topoLink.setProjectId(topoSource.getProjectId());
        topoLink.setApplicationId(topoSource.getApplicationId());
        topoLink.setSourceId(sourceNode.getId());
        topoLink.setTargetId(targetNode.getId());
        topoLink.setReplicationStatus(topoSource.getReplicaStatus());
        return topoLink;
    }

    @Override
    public String support() {
        return this.supportType;
    }

    @Override
    public List<String> dependencies() {
        return this.dependencies;
    }
}

