/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.topo.build;

import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.topo.build.BuildContext;
import com.huawei.csr.framework.topo.build.TopoBuilder;
import com.huawei.csr.framework.topo.build.TopoBuilderManager;
import com.huawei.csr.framework.topo.build.TopoSource;
import com.huawei.csr.framework.topo.build.TopoSourceFactory;
import com.huawei.lego.core.base.framework.container.support.SystemLauncher;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;

public class TopoBuildHelper {
    private static final Log LOGGER = LogFactory.getInstance(TopoBuildHelper.class);

    public static BuildContext buildTopoValues(Collection<AppServiceInstance> instanceList) {
        ApplicationContext applicationContext = SystemLauncher.getSpringContext();
        TopoBuilderManager manager = (TopoBuilderManager)applicationContext.getBean("topoBuilderManager", TopoBuilderManager.class);
        LOGGER.info((Object)"Begin build topo values, instanceList size:%s.", new Object[]{String.valueOf(instanceList.size())});
        Map<String, List<TopoSource>> topoSourceMap = TopoBuildHelper.buildInstanceMap(instanceList);
        BuildContext context = new BuildContext();
        List<TopoBuilder> sortedBuilders = manager.getSortedBuilders();
        for (TopoBuilder builder : sortedBuilders) {
            List list = topoSourceMap.getOrDefault(builder.support(), Collections.emptyList());
            for (TopoSource topoSource : list) {
                builder.build(context, topoSource);
            }
        }
        LOGGER.info((Object)"End build topo values. node count:%d, link count:%d", new Object[]{context.getTopoNodeList().size(), context.getTopoLinkList().size()});
        return context;
    }

    private static Map<String, List<TopoSource>> buildInstanceMap(Collection<AppServiceInstance> instanceList) {
        HashMap<String, List<TopoSource>> map = new HashMap<String, List<TopoSource>>();
        for (AppServiceInstance instance : instanceList) {
            TopoSource source = TopoSourceFactory.convertTopoSource(instance);
            map.computeIfAbsent(instance.getServiceType(), type -> new ArrayList()).add(source);
        }
        return map;
    }
}

