/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.topo.build;

import com.huawei.csr.framework.topo.build.TopoBuilder;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class TopoBuilderManager {
    private static final Log LOGGER = LogFactory.getInstance(TopoBuilderManager.class);
    private static final Map<String, TopoBuilder> BUILDERS_MAP = new HashMap<String, TopoBuilder>();
    private static final List<TopoBuilder> SORTED_BUILDERS = new ArrayList<TopoBuilder>();

    public void onBind(TopoBuilder builder, Map<String, Object> props) {
        String serviceType = builder.support();
        BUILDERS_MAP.put(serviceType, builder);
        LOGGER.info((Object)"Bind topo builder: %s", new Object[]{serviceType});
    }

    public void onUnbind(TopoBuilder builder, Map<String, Object> props) {
        String serviceType = builder.support();
        BUILDERS_MAP.remove(serviceType);
        LOGGER.info((Object)"Unbind topo builder: %s", new Object[]{serviceType});
    }

    public synchronized List<TopoBuilder> getSortedBuilders() {
        if (SORTED_BUILDERS.isEmpty()) {
            this.sortBuilders();
            LOGGER.info((Object)"Sorted builders: %s.", new Object[]{SORTED_BUILDERS.stream().map(TopoBuilder::support).collect(Collectors.toList())});
        }
        return SORTED_BUILDERS;
    }

    private void sortBuilders() {
        HashMap<String, Node> map = new HashMap<String, Node>();
        for (Map.Entry<String, TopoBuilder> entry : BUILDERS_MAP.entrySet()) {
            Node node = new Node();
            node.type = entry.getKey();
            map.put(node.type, node);
        }
        for (Node node : map.values()) {
            List<String> dependencies = BUILDERS_MAP.get(node.type).dependencies();
            for (String dependency : dependencies) {
                if (!map.containsKey(dependency)) continue;
                Node child = (Node)map.get(dependency);
                node.children.add(child);
                child.parents.add(node);
            }
        }
        this.generateSortedBuilders(map);
    }

    private void generateSortedBuilders(Map<String, Node> map) {
        while (!map.isEmpty()) {
            List filterResult = map.values().stream().filter(node -> node.children.isEmpty()).collect(Collectors.toList());
            if (filterResult.isEmpty()) {
                throw new LegoCheckedException("Sort topo builders error.");
            }
            for (Node node2 : filterResult) {
                SORTED_BUILDERS.add(BUILDERS_MAP.get(node2.type));
                map.remove(node2.type);
                for (Node parent : node2.parents) {
                    parent.children.remove(node2);
                }
            }
        }
    }

    private static class Node {
        String type;
        List<Node> parents = new ArrayList<Node>();
        List<Node> children = new ArrayList<Node>();

        private Node() {
        }
    }
}

